/* libebook-1.2.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "E", lower_case_cprefix = "e_")]
namespace E {
	[Compact]
	[CCode (cheader_filename = "libebook/e-book.h")]
	public class AddressWestern {
		public weak string country;
		public weak string extended;
		public weak string locality;
		public weak string po_box;
		public weak string postal_code;
		public weak string region;
		public weak string street;
		public static unowned E.AddressWestern parse (string in_address);
	}
	[CCode (cheader_filename = "libebook/e-book.h")]
	public class Book : GLib.Object {
		[CCode (has_construct_function = false)]
		public Book (E.Source source) throws GLib.Error;
		public bool add_contact (E.Contact contact) throws GLib.Error;
		public bool add_contacts (GLib.List contacts) throws GLib.Error;
		public uint async_add_contact (E.Contact contact, E.BookIdCallback cb, void* closure);
		public uint async_add_contacts (GLib.List contacts, E.BookCallback cb, void* closure);
		public uint async_authenticate_user (string user, string passwd, string auth_method, E.BookCallback cb, void* closure);
		public uint async_commit_contact (E.Contact contact, E.BookCallback cb, void* closure);
		public uint async_commit_contacts (GLib.List contacts, E.BookCallback cb, void* closure);
		public uint async_get_book_view (E.BookQuery query, GLib.List requested_fields, int max_results, E.BookBookViewCallback cb, void* closure);
		public uint async_get_changes (string changeid, E.BookListCallback cb, void* closure);
		public uint async_get_contact (string id, E.BookContactCallback cb, void* closure);
		public uint async_get_contacts (E.BookQuery query, E.BookListCallback cb, void* closure);
		public uint async_get_required_fields (E.BookEListCallback cb, void* closure);
		public uint async_get_supported_auth_methods (E.BookEListCallback cb, void* closure);
		public uint async_get_supported_fields (E.BookEListCallback cb, void* closure);
		public uint async_open (bool only_if_exists, E.BookCallback open_response, void* closure);
		public uint async_remove (E.BookCallback cb, void* closure);
		public uint async_remove_all_contacts (E.BookCallback cb, void* closure);
		public uint async_remove_contact (E.Contact contact, E.BookCallback cb, void* closure);
		public uint async_remove_contact_by_id (string id, E.BookCallback cb, void* closure);
		public uint async_remove_contacts (GLib.List ids, E.BookCallback cb, void* closure);
		public bool authenticate_user (string user, string passwd, string auth_method) throws GLib.Error;
		public bool cancel () throws GLib.Error;
		public bool check_static_capability (string cap);
		public bool commit_contact (E.Contact contact) throws GLib.Error;
		public bool commit_contacts (GLib.List contacts) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Book.default_addressbook () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public static void free_change_list (GLib.List change_list);
		[CCode (has_construct_function = false)]
		public Book.from_uri (string uri) throws GLib.Error;
		public static bool get_addressbooks (out unowned E.SourceList addressbook_sources) throws GLib.Error;
		public bool get_book_view (E.BookQuery query, GLib.List requested_fields, int max_results, out unowned E.BookView book_view) throws GLib.Error;
		public bool get_changes (string changeid, GLib.List changes) throws GLib.Error;
		public bool get_contact (string id, out unowned E.Contact contact) throws GLib.Error;
		public bool get_contacts (E.BookQuery query, GLib.List contacts) throws GLib.Error;
		public bool get_required_fields (GLib.List fields) throws GLib.Error;
		public static bool get_self (out unowned E.Contact contact, out unowned E.Book book) throws GLib.Error;
		public unowned E.Source get_source ();
		public unowned string get_static_capabilities () throws GLib.Error;
		public bool get_supported_auth_methods (GLib.List auth_methods) throws GLib.Error;
		public bool get_supported_fields (GLib.List fields) throws GLib.Error;
		public unowned string get_uri ();
		public bool is_online ();
		public bool is_opened ();
		public static bool is_self (E.Contact contact);
		public bool is_writable ();
		public bool open (bool only_if_exists) throws GLib.Error;
		public bool remove () throws GLib.Error;
		public bool remove_all_contacts () throws GLib.Error;
		public bool remove_contact (string id) throws GLib.Error;
		public bool remove_contacts (GLib.List ids) throws GLib.Error;
		public bool set_default_addressbook () throws GLib.Error;
		public static bool set_default_source (E.Source source) throws GLib.Error;
		public bool set_self (E.Contact contact) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Book.system_addressbook () throws GLib.Error;
		public static void util_remove_duplicates (GLib.List haystack, GLib.List needles, GLib.List duplicate_ids);
		public bool util_remove_duplicates_using_book (GLib.List contacts, GLib.List duplicate_ids) throws GLib.Error;
		public virtual signal void auth_required ();
		public virtual signal void backend_died ();
		public virtual signal void connection_status (bool connected);
		public virtual signal void writable_status (bool writable);
	}
	[Compact]
	[CCode (cheader_filename = "libebook/e-book.h")]
	public class BookChange {
		public E.BookChangeType change_type;
		public weak E.Contact contact;
	}
	[Compact]
	[CCode (ref_function = "e_book_query_ref", unref_function = "e_book_query_unref", type_id = "E_TYPE_BOOK_QUERY", cheader_filename = "libebook/e-book.h")]
	public class BookQuery {
		public static unowned E.BookQuery and (int nqs, out unowned E.BookQuery qs, bool unref);
		public unowned E.BookQuery andv ();
		public static unowned E.BookQuery any_field_contains (string value);
		public unowned E.BookQuery copy ();
		public static unowned E.BookQuery field_exists (E.ContactField field);
		public static unowned E.BookQuery field_test (E.ContactField field, E.BookQueryTest test, string value);
		public static unowned E.BookQuery from_string (string query_string);
		public unowned E.BookQuery not (bool unref);
		public static unowned E.BookQuery or (int nqs, out unowned E.BookQuery qs, bool unref);
		public unowned E.BookQuery orv ();
		public unowned string to_string ();
		public static unowned E.BookQuery vcard_field_exists (string field);
		public static unowned E.BookQuery vcard_field_test (string field, E.BookQueryTest test, string value);
	}
	[CCode (cheader_filename = "libebook/e-book.h")]
	public class BookSExp : GLib.Object {
		[CCode (has_construct_function = false)]
		public BookSExp (string text);
		public bool match_contact (E.Contact contact);
		public bool match_vcard (string vcard);
		public bool parse (string text);
	}
	[CCode (cheader_filename = "libebook/e-book.h")]
	public class BookView : GLib.Object {
		public void* get_book ();
		public bool get_parse_vcards ();
		public void* get_query ();
		public bool is_freezable ();
		public void set_freezable (bool freezable);
		public void set_parse_vcards (bool parse_vcards);
		public void set_sort_order (string query_term);
		public void start ();
		public void stop ();
		public void thaw ();
		public virtual signal void contacts_added (void* contacts);
		public virtual signal void contacts_changed (void* contacts);
		public virtual signal void contacts_removed (void* ids);
		public virtual signal void sequence_complete (int status);
		public virtual signal void status_message (string message);
	}
	[CCode (cheader_filename = "libebook/e-book.h")]
	public class Contact : E.VCard {
		[CCode (has_construct_function = false)]
		public Contact ();
		public unowned E.Contact duplicate ();
		public static E.ContactField field_id (string field_name);
		public static E.ContactField field_id_from_vcard (string vcard_field);
		public static unowned string field_name (E.ContactField field_id);
		[CCode (has_construct_function = false)]
		public Contact.from_vcard (string vcard);
		public void* @get (E.ContactField field_id);
		public unowned GLib.List get_attributes (E.ContactField field_id);
		public void* get_const (E.ContactField field_id);
		public bool inline_data ();
		public bool is_syncable ();
		public bool persist_data (string dir);
		public static unowned string pretty_name (E.ContactField field_id);
		public void @set (E.ContactField field_id, void* value);
		public void set_attributes (E.ContactField field_id, GLib.List attributes);
		public static unowned string vcard_attribute (E.ContactField field_id);
		[NoAccessorMethod]
		public string Rev { owned get; set; }
		[NoAccessorMethod]
		public void* address { get; set; }
		[NoAccessorMethod]
		public E.ContactAddress address_home { owned get; set; }
		[NoAccessorMethod]
		public string address_label_home { owned get; set; }
		[NoAccessorMethod]
		public string address_label_other { owned get; set; }
		[NoAccessorMethod]
		public string address_label_work { owned get; set; }
		[NoAccessorMethod]
		public E.ContactAddress address_other { owned get; set; }
		[NoAccessorMethod]
		public E.ContactAddress address_work { owned get; set; }
		[NoAccessorMethod]
		public E.ContactDate anniversary { owned get; set; }
		[NoAccessorMethod]
		public string assistant { owned get; set; }
		[NoAccessorMethod]
		public string assistant_phone { owned get; set; }
		[NoAccessorMethod]
		public E.ContactDate birth_date { owned get; set; }
		[NoAccessorMethod]
		public string blog_url { owned get; set; }
		[NoAccessorMethod]
		public string book_uri { owned get; set; }
		[NoAccessorMethod]
		public string business_fax { owned get; set; }
		[NoAccessorMethod]
		public string business_phone { owned get; set; }
		[NoAccessorMethod]
		public string business_phone_2 { owned get; set; }
		[NoAccessorMethod]
		public string callback_phone { owned get; set; }
		[NoAccessorMethod]
		public string caluri { owned get; set; }
		[NoAccessorMethod]
		public string car_phone { owned get; set; }
		[NoAccessorMethod]
		public string categories { owned get; set; }
		[NoAccessorMethod]
		public void* category_list { get; set; }
		[NoAccessorMethod]
		public string company_phone { owned get; set; }
		[NoAccessorMethod]
		public void* email { get; set; }
		[NoAccessorMethod]
		public string email_1 { owned get; set; }
		[NoAccessorMethod]
		public string email_2 { owned get; set; }
		[NoAccessorMethod]
		public string email_3 { owned get; set; }
		[NoAccessorMethod]
		public string email_4 { owned get; set; }
		[NoAccessorMethod]
		public string family_name { owned get; set; }
		[NoAccessorMethod]
		public string fburl { owned get; set; }
		[NoAccessorMethod]
		public string file_as { owned get; set; }
		[NoAccessorMethod]
		public string full_name { owned get; set; }
		[NoAccessorMethod]
		public E.ContactGeo geo { owned get; set; }
		[NoAccessorMethod]
		public string given_name { owned get; set; }
		[NoAccessorMethod]
		public string home_fax { owned get; set; }
		[NoAccessorMethod]
		public string home_phone { owned get; set; }
		[NoAccessorMethod]
		public string home_phone_2 { owned get; set; }
		[NoAccessorMethod]
		public string homepage_url { owned get; set; }
		[NoAccessorMethod]
		public string icscalendar { owned get; set; }
		[NoAccessorMethod]
		public string id { owned get; set; }
		[NoAccessorMethod]
		public void* im_aim { get; set; }
		[NoAccessorMethod]
		public string im_aim_home_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_aim_home_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_aim_home_3 { owned get; set; }
		[NoAccessorMethod]
		public string im_aim_work_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_aim_work_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_aim_work_3 { owned get; set; }
		[NoAccessorMethod]
		public void* im_gadugadu { get; set; }
		[NoAccessorMethod]
		public string im_gadugadu_home_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_gadugadu_home_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_gadugadu_home_3 { owned get; set; }
		[NoAccessorMethod]
		public string im_gadugadu_work_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_gadugadu_work_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_gadugadu_work_3 { owned get; set; }
		[NoAccessorMethod]
		public void* im_groupwise { get; set; }
		[NoAccessorMethod]
		public string im_groupwise_home_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_groupwise_home_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_groupwise_home_3 { owned get; set; }
		[NoAccessorMethod]
		public string im_groupwise_work_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_groupwise_work_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_groupwise_work_3 { owned get; set; }
		[NoAccessorMethod]
		public void* im_icq { get; set; }
		[NoAccessorMethod]
		public string im_icq_home_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_icq_home_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_icq_home_3 { owned get; set; }
		[NoAccessorMethod]
		public string im_icq_work_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_icq_work_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_icq_work_3 { owned get; set; }
		[NoAccessorMethod]
		public void* im_jabber { get; set; }
		[NoAccessorMethod]
		public string im_jabber_home_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_jabber_home_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_jabber_home_3 { owned get; set; }
		[NoAccessorMethod]
		public string im_jabber_work_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_jabber_work_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_jabber_work_3 { owned get; set; }
		[NoAccessorMethod]
		public void* im_msn { get; set; }
		[NoAccessorMethod]
		public string im_msn_home_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_msn_home_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_msn_home_3 { owned get; set; }
		[NoAccessorMethod]
		public string im_msn_work_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_msn_work_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_msn_work_3 { owned get; set; }
		[NoAccessorMethod]
		public void* im_skype { get; set; }
		[NoAccessorMethod]
		public string im_skype_home_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_skype_home_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_skype_home_3 { owned get; set; }
		[NoAccessorMethod]
		public string im_skype_work_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_skype_work_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_skype_work_3 { owned get; set; }
		[NoAccessorMethod]
		public void* im_yahoo { get; set; }
		[NoAccessorMethod]
		public string im_yahoo_home_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_yahoo_home_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_yahoo_home_3 { owned get; set; }
		[NoAccessorMethod]
		public string im_yahoo_work_1 { owned get; set; }
		[NoAccessorMethod]
		public string im_yahoo_work_2 { owned get; set; }
		[NoAccessorMethod]
		public string im_yahoo_work_3 { owned get; set; }
		[NoAccessorMethod]
		public string isdn_phone { owned get; set; }
		[NoAccessorMethod]
		public bool list { get; set; }
		[NoAccessorMethod]
		public bool list_show_addresses { get; set; }
		[NoAccessorMethod]
		public E.ContactPhoto logo { owned get; set; }
		[NoAccessorMethod]
		public string mailer { owned get; set; }
		[NoAccessorMethod]
		public string manager { owned get; set; }
		[NoAccessorMethod]
		public string mobile_phone { owned get; set; }
		[NoAccessorMethod]
		public E.ContactName name { owned get; set; }
		[NoAccessorMethod]
		public string name_or_org { owned get; }
		[NoAccessorMethod]
		public string nickname { owned get; set; }
		[NoAccessorMethod]
		public string note { owned get; set; }
		[NoAccessorMethod]
		public string office { owned get; set; }
		[NoAccessorMethod]
		public string org { owned get; set; }
		[NoAccessorMethod]
		public string org_unit { owned get; set; }
		[NoAccessorMethod]
		public string other_fax { owned get; set; }
		[NoAccessorMethod]
		public string other_phone { owned get; set; }
		[NoAccessorMethod]
		public string pager { owned get; set; }
		[NoAccessorMethod]
		public void* phone { get; set; }
		[NoAccessorMethod]
		public E.ContactPhoto photo { owned get; set; }
		[NoAccessorMethod]
		public string primary_phone { owned get; set; }
		[NoAccessorMethod]
		public string radio { owned get; set; }
		[NoAccessorMethod]
		public string role { owned get; set; }
		[NoAccessorMethod]
		public void* sip { get; set; }
		[NoAccessorMethod]
		public string spouse { owned get; set; }
		[NoAccessorMethod]
		public string telex { owned get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		[NoAccessorMethod]
		public string tty { owned get; set; }
		[NoAccessorMethod]
		public string video_url { owned get; set; }
		[NoAccessorMethod]
		public bool wants_html { get; set; }
		[NoAccessorMethod]
		public E.ContactCert x509Cert { owned get; set; }
	}
	[Compact]
	[CCode (type_id = "E_TYPE_CONTACT_ADDRESS", cheader_filename = "libebook/e-book.h")]
	public class ContactAddress {
		public weak string address_format;
		public weak string code;
		public weak string country;
		public weak string ext;
		public weak string locality;
		public weak string po;
		public weak string region;
		public weak string street;
	}
	[Compact]
	[CCode (type_id = "E_TYPE_CONTACT_CERT", cheader_filename = "libebook/e-book.h")]
	public class ContactCert {
		public weak string data;
		public size_t length;
	}
	[Compact]
	[CCode (type_id = "E_TYPE_CONTACT_DATE", cheader_filename = "libebook/e-book.h")]
	public class ContactDate {
		public uint day;
		public uint month;
		public uint year;
		[CCode (has_construct_function = false)]
		public ContactDate ();
		public bool equal (E.ContactDate dt2);
		public static unowned E.ContactDate from_string (string str);
		public unowned string to_string ();
	}
	[Compact]
	[CCode (type_id = "E_TYPE_CONTACT_GEO", cheader_filename = "libebook/e-book.h")]
	public class ContactGeo {
		public double latitude;
		public double longitude;
	}
	[Compact]
	[CCode (copy_function = "e_contact_name_copy", type_id = "E_TYPE_CONTACT_NAME", cheader_filename = "libebook/e-book.h")]
	public class ContactName {
		public weak string additional;
		public weak string family;
		public weak string given;
		public weak string prefixes;
		public weak string suffixes;
		[CCode (has_construct_function = false)]
		public ContactName ();
		public unowned E.ContactName copy ();
		public static unowned E.ContactName from_string (string name_str);
		public unowned string to_string ();
	}
	[Compact]
	[CCode (type_id = "E_TYPE_CONTACT_PHOTO", cheader_filename = "libebook/e-book.h")]
	public class ContactPhoto {
		public void* data;
		public E.ContactPhotoType type;
	}
	[Compact]
	[CCode (cheader_filename = "libebook/e-book.h")]
	public class NameWestern {
		public weak string first;
		public weak string full;
		public weak string last;
		public weak string middle;
		public weak string nick;
		public weak string prefix;
		public weak string suffix;
		public static unowned E.NameWestern parse (string full_name);
	}
	[CCode (cheader_filename = "libebook/e-book.h")]
	public class VCard : GLib.Object {
		[CCode (has_construct_function = false)]
		public VCard ();
		public virtual void add_attribute (E.VCardAttribute attr);
		public void add_attribute_with_value (owned E.VCardAttribute attr, string value);
		public void add_attribute_with_values (owned E.VCardAttribute attr, ...);
		public bool @construct (string str);
		public bool construct_with_uid (string str, string uid);
		public void dump_structure ();
		public static unowned string escape_string (string s);
		[CCode (has_construct_function = false)]
		public VCard.from_string (string str);
		public unowned E.VCardAttribute get_attribute (string name);
		public unowned GLib.List get_attributes ();
		public bool is_parsed ();
		public bool is_parsing ();
		public virtual void remove_attribute (E.VCardAttribute attr);
		public void remove_attributes (string attr_group, string attr_name);
		public unowned string to_string (E.VCardFormat format);
		public static unowned string unescape_string (string s);
		public static unowned GLib.List util_split_cards (string str, size_t len);
	}
	[Compact]
	[CCode (copy_function = "e_vcard_attribute_copy", type_id = "E_TYPE_VCARD_ATTRIBUTE", cheader_filename = "libebook/e-book.h")]
	public class VCardAttribute {
		[CCode (has_construct_function = false)]
		public VCardAttribute (string? attr_group, string attr_name);
		public void add_param (E.VCardAttributeParam param);
		public void add_param_with_value (owned E.VCardAttributeParam param, string value);
		public void add_param_with_values (owned E.VCardAttributeParam param, ...);
		public void add_value (string value);
		public void add_value_decoded (string value, int len);
		public void add_values ();
		public unowned E.VCardAttribute copy ();
		public bool equal (E.VCardAttribute attr_b);
		public unowned string get_group ();
		public unowned string get_name ();
		public unowned GLib.List get_param (string name);
		public unowned GLib.List get_params ();
		public unowned string get_value ();
		public unowned GLib.StringBuilder get_value_decoded ();
		public unowned GLib.List get_values ();
		public unowned GLib.List get_values_decoded ();
		public bool has_type (string typestr);
		public bool is_single_valued ();
		public void remove_param (string param_name);
		public void remove_param_value (string param_name, string s);
		public void remove_params ();
		public void remove_value (string s);
		public void remove_values ();
	}
	[Compact]
	[CCode (copy_function = "e_vcard_attribute_param_copy", cheader_filename = "libebook/e-book.h")]
	public class VCardAttributeParam {
		[CCode (has_construct_function = false)]
		public VCardAttributeParam (string name);
		public void add_value (string value);
		public void add_values ();
		public unowned E.VCardAttributeParam copy ();
		public unowned string get_name ();
		public unowned GLib.List get_values ();
		public void remove_values ();
	}
	[CCode (cprefix = "E_BOOK_CHANGE_CARD_", has_type_id = false, cheader_filename = "libebook/e-book.h")]
	public enum BookChangeType {
		ADDED,
		DELETED,
		MODIFIED
	}
	[CCode (cprefix = "E_BOOK_QUERY_", has_type_id = false, cheader_filename = "libebook/e-book.h")]
	public enum BookQueryTest {
		IS,
		CONTAINS,
		BEGINS_WITH,
		ENDS_WITH
	}
	[CCode (cprefix = "E_BOOK_ERROR_", has_type_id = false, cheader_filename = "libebook/e-book.h")]
	public enum BookStatus {
		OK,
		INVALID_ARG,
		BUSY,
		REPOSITORY_OFFLINE,
		NO_SUCH_BOOK,
		NO_SELF_CONTACT,
		SOURCE_NOT_LOADED,
		SOURCE_ALREADY_LOADED,
		PERMISSION_DENIED,
		CONTACT_NOT_FOUND,
		CONTACT_ID_ALREADY_EXISTS,
		PROTOCOL_NOT_SUPPORTED,
		CANCELLED,
		COULD_NOT_CANCEL,
		AUTHENTICATION_FAILED,
		AUTHENTICATION_REQUIRED,
		TLS_NOT_AVAILABLE,
		CORBA_EXCEPTION,
		NO_SUCH_SOURCE,
		OFFLINE_UNAVAILABLE,
		OTHER_ERROR,
		INVALID_SERVER_VERSION,
		NO_SPACE,
		INVALID_FIELD
	}
	[CCode (cprefix = "E_BOOK_VIEW_", has_type_id = false, cheader_filename = "libebook/e-book.h")]
	public enum BookViewStatus {
		STATUS_OK,
		STATUS_TIME_LIMIT_EXCEEDED,
		STATUS_SIZE_LIMIT_EXCEEDED,
		ERROR_INVALID_QUERY,
		ERROR_QUERY_REFUSED,
		ERROR_OTHER_ERROR
	}
	[CCode (cprefix = "E_CONTACT_", has_type_id = false, cheader_filename = "libebook/e-book.h")]
	public enum ContactField {
		UID,
		FILE_AS,
		BOOK_URI,
		FULL_NAME,
		GIVEN_NAME,
		FAMILY_NAME,
		NICKNAME,
		EMAIL_1,
		EMAIL_2,
		EMAIL_3,
		EMAIL_4,
		MAILER,
		ADDRESS_LABEL_HOME,
		ADDRESS_LABEL_WORK,
		ADDRESS_LABEL_OTHER,
		PHONE_ASSISTANT,
		PHONE_BUSINESS,
		PHONE_BUSINESS_2,
		PHONE_BUSINESS_FAX,
		PHONE_CALLBACK,
		PHONE_CAR,
		PHONE_COMPANY,
		PHONE_HOME,
		PHONE_HOME_2,
		PHONE_HOME_FAX,
		PHONE_ISDN,
		PHONE_MOBILE,
		PHONE_OTHER,
		PHONE_OTHER_FAX,
		PHONE_PAGER,
		PHONE_PRIMARY,
		PHONE_RADIO,
		PHONE_TELEX,
		PHONE_TTYTDD,
		ORG,
		ORG_UNIT,
		OFFICE,
		TITLE,
		ROLE,
		MANAGER,
		ASSISTANT,
		HOMEPAGE_URL,
		BLOG_URL,
		CATEGORIES,
		CALENDAR_URI,
		FREEBUSY_URL,
		ICS_CALENDAR,
		VIDEO_URL,
		SPOUSE,
		NOTE,
		IM_AIM_HOME_1,
		IM_AIM_HOME_2,
		IM_AIM_HOME_3,
		IM_AIM_WORK_1,
		IM_AIM_WORK_2,
		IM_AIM_WORK_3,
		IM_GROUPWISE_HOME_1,
		IM_GROUPWISE_HOME_2,
		IM_GROUPWISE_HOME_3,
		IM_GROUPWISE_WORK_1,
		IM_GROUPWISE_WORK_2,
		IM_GROUPWISE_WORK_3,
		IM_JABBER_HOME_1,
		IM_JABBER_HOME_2,
		IM_JABBER_HOME_3,
		IM_JABBER_WORK_1,
		IM_JABBER_WORK_2,
		IM_JABBER_WORK_3,
		IM_YAHOO_HOME_1,
		IM_YAHOO_HOME_2,
		IM_YAHOO_HOME_3,
		IM_YAHOO_WORK_1,
		IM_YAHOO_WORK_2,
		IM_YAHOO_WORK_3,
		IM_MSN_HOME_1,
		IM_MSN_HOME_2,
		IM_MSN_HOME_3,
		IM_MSN_WORK_1,
		IM_MSN_WORK_2,
		IM_MSN_WORK_3,
		IM_ICQ_HOME_1,
		IM_ICQ_HOME_2,
		IM_ICQ_HOME_3,
		IM_ICQ_WORK_1,
		IM_ICQ_WORK_2,
		IM_ICQ_WORK_3,
		REV,
		NAME_OR_ORG,
		ADDRESS,
		ADDRESS_HOME,
		ADDRESS_WORK,
		ADDRESS_OTHER,
		CATEGORY_LIST,
		PHOTO,
		LOGO,
		NAME,
		EMAIL,
		IM_AIM,
		IM_GROUPWISE,
		IM_JABBER,
		IM_YAHOO,
		IM_MSN,
		IM_ICQ,
		WANTS_HTML,
		IS_LIST,
		LIST_SHOW_ADDRESSES,
		BIRTH_DATE,
		ANNIVERSARY,
		X509_CERT,
		IM_GADUGADU_HOME_1,
		IM_GADUGADU_HOME_2,
		IM_GADUGADU_HOME_3,
		IM_GADUGADU_WORK_1,
		IM_GADUGADU_WORK_2,
		IM_GADUGADU_WORK_3,
		IM_GADUGADU,
		GEO,
		TEL,
		SIP,
		IM_SKYPE_HOME_1,
		IM_SKYPE_HOME_2,
		IM_SKYPE_HOME_3,
		IM_SKYPE_WORK_1,
		IM_SKYPE_WORK_2,
		IM_SKYPE_WORK_3,
		IM_SKYPE,
		FIELD_LAST,
		FIELD_FIRST,
		LAST_SIMPLE_STRING,
		FIRST_PHONE_ID,
		LAST_PHONE_ID,
		FIRST_EMAIL_ID,
		LAST_EMAIL_ID,
		FIRST_ADDRESS_ID,
		LAST_ADDRESS_ID,
		FIRST_LABEL_ID,
		LAST_LABEL_ID
	}
	[CCode (cprefix = "E_CONTACT_PHOTO_TYPE_", has_type_id = false, cheader_filename = "libebook/e-book.h")]
	public enum ContactPhotoType {
		INLINED,
		URI
	}
	[CCode (cprefix = "EVC_FORMAT_VCARD_", has_type_id = false, cheader_filename = "libebook/e-book.h")]
	public enum VCardFormat {
		@21,
		@30
	}
	[CCode (cheader_filename = "libebook/e-book.h", has_target = false)]
	public delegate void BookBookViewCallback (E.Book book, E.BookStatus status, E.BookView book_view, void* closure);
	[CCode (cheader_filename = "libebook/e-book.h", has_target = false)]
	public delegate void BookCallback (E.Book book, E.BookStatus status, void* closure);
	[CCode (cheader_filename = "libebook/e-book.h", has_target = false)]
	public delegate void BookContactCallback (E.Book book, E.BookStatus status, E.Contact contact, void* closure);
	[CCode (cheader_filename = "libebook/e-book.h", has_target = false)]
	public delegate void BookEListCallback (E.Book book, E.BookStatus status, E.List list, void* closure);
	[CCode (cheader_filename = "libebook/e-book.h", has_target = false)]
	public delegate void BookIdCallback (E.Book book, E.BookStatus status, string id, void* closure);
	[CCode (cheader_filename = "libebook/e-book.h", has_target = false)]
	public delegate void BookListCallback (E.Book book, E.BookStatus status, GLib.List list, void* closure);
	[CCode (cheader_filename = "libebook/e-book.h", has_target = false)]
	public delegate void BookOpenProgressCallback (E.Book book, string status_message, short percent, void* closure);
	[CCode (cname = "EVC_EMAIL", cheader_filename = "libebook/e-book.h")]
	public const string EVC_EMAIL;
	[CCode (cname = "EVC_FN", cheader_filename = "libebook/e-book.h")]
	public const string EVC_FN;
	[CCode (cname = "EVC_N", cheader_filename = "libebook/e-book.h")]
	public const string EVC_N;
	[CCode (cname = "EVC_TEL", cheader_filename = "libebook/e-book.h")]
	public const string EVC_TEL;
	[CCode (cname = "EVC_TYPE", cheader_filename = "libebook/e-book.h")]
	public const string EVC_TYPE;
	[CCode (cheader_filename = "libebook/e-book.h")]
	public const int PARAM_READABLE;
	[CCode (cheader_filename = "libebook/e-book.h")]
	public const int PARAM_READWRITE;
	[CCode (cheader_filename = "libebook/e-book-util.h")]
	public static unowned string normalize_phone_number (string phone_number);
}
