#include "contactchooser.h"

#include <QDebug>


/*!
  No functionality in the constructor.
*/
ContactChooser::ContactChooser(QObject *parent) :
    QObject(parent)
{
}


/*!
  contactChooser opens the user interface dialogs to select a proper contact
  with its phone number.
*/
bool ContactChooser::contactChooser(Contact *contact)
{
    QString contactId = "";
    QString contactName = "";
    QString contactNumber = 0;

    // open contact selector
    OssoABookContact* ossoContact = GetOssoABookContact();

    // did we perform a selection?
    if (ossoContact) {
        contactId = QString::fromLatin1((const char*)
                      osso_abook_contact_get_persistent_uid(ossoContact));
        contactName = QString::fromLatin1((const char*)
                      osso_abook_contact_get_display_name(ossoContact));
        //EContact* eContact = E_CONTACT(contact);
        //const char* id = (const char*)e_contact_get_const(eContact, E_CONTACT_UID);

        contactNumber = GetOssoABookPhoneNumber(ossoContact);
    }

    // did we select a proper phone number?
    if (contactNumber != 0) {
        contact->itsName = contactName;
        contact->itsPhoneNumber = contactNumber;
        contact->itsId = contactId;
        return true;
    }
    else
        return false;
}


/*!
  GetOssoABookContact uses the Maemo native dialog to select a contact
  (but no single phone number yet).
*/
OssoABookContact* ContactChooser::GetOssoABookContact()
{
    OssoABookContact* contact = 0;

    GtkWidget* contactChooser = osso_abook_contact_chooser_new_with_capabilities(
            NULL, qPrintable(tr("Please select a contact")),
            OSSO_ABOOK_CAPS_PHONE,  // OSSO_ABOOK_CAPS_ALL,
            OSSO_ABOOK_CONTACT_ORDER_NAME);

    // show contact selection dialog
    if (gtk_dialog_run(GTK_DIALOG(contactChooser)) == GTK_RESPONSE_OK) {
        GList* contactList = osso_abook_contact_chooser_get_selection(
                        OSSO_ABOOK_CONTACT_CHOOSER(contactChooser)); // do not free

        if (contactList) {
            contact = (OssoABookContact*) contactList->data;
        }
    }

    gtk_widget_destroy(contactChooser);

    return contact;
}


/*!
  GetOssoABookPhoneNumber gets a single phone number for the given contact.
  If the contact only has a single number this is returned. Otherwise a
  selection popup is used.
*/
QString ContactChooser::GetOssoABookPhoneNumber(OssoABookContact* contact)
{
    QString contactNumber = 0;

    // check whether this contact has multiple phone numbers
    OssoABookContactDetailStore* contactDetailStore =
            osso_abook_contact_detail_store_new(contact,
                                        OSSO_ABOOK_CONTACT_DETAIL_PHONE);
    GSequence *fields = osso_abook_contact_detail_store_get_fields(contactDetailStore);
    int nrFields = g_sequence_get_length(fields);

    // if we face multiple numbers, show selection dialog
    if (nrFields > 1) {
        // show contact detail selection dialog
        GtkWidget* detailSelector = osso_abook_contact_detail_selector_new_for_contact(
                NULL, contact, OSSO_ABOOK_CONTACT_DETAIL_PHONE);
        if (gtk_dialog_run(GTK_DIALOG(detailSelector)) == GTK_RESPONSE_OK) {
            OssoABookContactField* selectedNumber =
                    osso_abook_contact_detail_selector_get_selected_field(
                            OSSO_ABOOK_CONTACT_DETAIL_SELECTOR(detailSelector));

            contactNumber = QString::fromLatin1((const char*)
                osso_abook_contact_field_get_display_value(selectedNumber));
        }
        gtk_widget_destroy(detailSelector);
    }
    else if (nrFields == 1) {
        // we have only one phone number, take it
        OssoABookContactField* selectedNumber = (OssoABookContactField*)
                            g_sequence_get(g_sequence_get_begin_iter(fields));
        contactNumber = QString::fromLatin1((const char*)
            osso_abook_contact_field_get_display_value(selectedNumber));
    }

    return contactNumber;
}
