# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher
2010-2011(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Abstract interface object
'''

import gtk, hildon, dbus
from advpowcommon.ui.Banners import HildonBanner
from advpowcommon.ui.Animation import DITPBCachedAnimator
from advpowcommon.ui.ToggleControl import ToggleControlMaemo5
from advpowcommon.util.execn import *
import advifswlib.util.cacher as cacher
import advifswlib.util.config as config
import advifswlib.util.locale as locale

class AbstractInterface():

  def __init__(self, bus=None, cb_status_area=None, cb_show_settings_dialog=None):
    self.__name = 'IFace'
    self.__processing = False
    self.__bus = bus
    self.__set_status_area_icon = cb_status_area
    self.__show_settings_dialog = cb_show_settings_dialog
    self.__interfaces = {}
    self.__lcl = locale.get()
    self.interfaces = {}
    self.indication = 'on'
    self.state = {}
    self.__config = config.get()
    self.pre_init()
    self.__name = self.state['name']
    self.__config_path = 'settings/%s' % (self.__name.lower())
    self.__button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
    self.__button.set_image(gtk.Image())
    self.__button.set_image_position(gtk.POS_LEFT)
    self.__button.set_alignment(0.5,0.5,1,1)
    self.__button.set_image_alignment(0.5,0.5)
    self.__button.set_title_alignment(0,0.5)
    self.__button.set_value_alignment(0,0.5)
    self.__button.connect('clicked', self.__button_clicked)
    self.__button.tap_and_hold_setup(None, None, 0)
    self.__button.connect('tap-and-hold', self.__button_tap_and_hold)
    self.__button.connect('destroy', self.__destroy)
    self.__smi_cacher = cacher.get()
    self.__smi_animator = DITPBCachedAnimator([], self.__button.get_image().set_from_pixbuf, cacher=self.__smi_cacher, time_out=250)
    self.state_control = None
    self.mode_control = None

    self.set_config_option('mode-on-startup', self.get_modes())

    self.start_animation()
    self.__init_interfaces()
    self.__get_status()
    self.__init_signals()
    self.stop_animation()

    start_state = int(self.get_config_value('enable-on-startup'))
    self.__switch_state(start_state)
    if start_state:
      self.__switch_mode(self.get_modes().index(self.get_config_value('mode-on-startup')))

    #print self.__name, self.state['value'], self.state['mode'], self.state['strength']
    #self.__show_switch_dialog()

  def pre_init(self):
    pass

  def turn_on(self):
    pass

  def turn_off(self):
    pass

  def get_name(self):
    return self.__name

  def get_button(self):
    return self.__button

  def get_bus(self):
    return self.__bus

  def get_modes(self):
    return list(self.state['modes'])

  def set_config_option(self, key, values):
    self.__config.set_option('%s/%s' % (self.__config_path, key), values)

  def get_config_value(self, key):
    return self.__config.get_value('%s/%s' % (self.__config_path, key))

  def destroy(self):
    self.__destroy()

  def __destroy(self, button=None):
    self.__destroy_signals()
    self.__destroy_interfaces()

  def __init_signals(self):
    for key in self.state['dbus']: self.__init_signal(key)

  def __init_signal(self, x):
    try:
      def callback(*args, **kwargs): self.__received_signal(x, *args, **kwargs)
      setattr(self, 'received_%s' % x, callback)
      self.state['dbus'][x]['match'] = self.__bus.add_signal_receiver(getattr(self, 'received_%s' % x), signal_name=self.state['dbus'][x]['name'], dbus_interface=self.state['dbus'][x]['iface'], path=self.state['dbus'][x]['path'], **self.state['dbus'][x]['args'])
    except:
      pass

  def reinit_signal(self, x):
    self.__destroy_signal(x)
    self.__init_signal(x)

  def __destroy_signals(self):
    for key in self.state['dbus']: self.__destroy_signal(key)

  def __destroy_signal(self, x):
    receiver_match = self.state['dbus'][x]['match']
    self.__bus.clean_up_signal_match(receiver_match)
    self.__bus.remove_signal_receiver(receiver_match)
    receiver_match.remove()

  def __received_signal(self, key, *args, **kwargs):
    #try: 
    value, mode, strength = getattr(self, 'process_signal_%s' % key)(*args, **kwargs)
    #except Exception, e: print 'Error: ', e
    show_banner = False
    update_ui = False
    if value != None and value != self.state['value']:
      self.state['value'] = value
      show_banner = True
      update_ui = True
      if self.state_control: self.state_control.set_active(value)
    if mode != None and mode != self.state['mode']:
      self.state['mode'] = mode
      show_banner = True
      if self.mode_control: self.mode_control.set_active(mode)
    if strength != None and strength != self.state['strength']:
      self.state['strength'] = strength
      update_ui = True
    if update_ui: self.__update_ui()
    windex = self.state['value']
    if show_banner and self.state['banner'][windex]:
      text = '%s: %s' % (self.__name, self.__lcl.get_item(self.state['text'][windex]))
      if len(self.state['modes']) > 1:
        text = '%s (%s)' % (text, self.__lcl.get(self.state['modes'][self.state['mode']]))
      HildonBanner.show_information(self.__button, text)

  def __init_interfaces(self):
    for x in self.interfaces: self.__init_interface(x)

  def __init_interface(self, x, force=False):
    try:
      loaded = True
      if self.interfaces[x][3] and not force:
          loaded = get_shell_command_output('ps aux | grep \'%s\' | grep -v \'grep\' | awk {\'print $3\'}' % (self.interfaces[x][3])) != ''
      if loaded:
        self.__interfaces[x] = dbus.Interface(self.get_bus().get_object(self.interfaces[x][0], self.interfaces[x][1], introspect=self.interfaces[x][4], follow_name_owner_changes=True), self.interfaces[x][2])
    except Exception, e:
      self.__interfaces[x] = None

  def reinit_interface(self, x, force=False):
    self.__destroy_interface(x)
    self.__init_interface(x, force)

  def get_interface(self, x):
    try:
      if self.__interfaces[x] == None: self.__init_interface(x)
      return self.__interfaces[x]
    except:
      return None

  def __destroy_interfaces(self):
    for x in self.interfaces: self.__destroy_interface(x)

  def __destroy_interface(self, x):
    try: self.__interfaces[x] = None
    except: pass

  def __get_status(self):
    self.state['value'], self.state['mode'], self.state['strength'] = self.get_status()
    self.__update_ui()

  def switched(self):
    self.__processing = False
    self.stop_animation()

  def __update_ui(self):
    windex = self.state['value']
    image = self.state['images'][windex]
    if windex == 2 and self.state['strength'] > 0: image = self.state['images_st'][self.state['strength']]
    self.__set_si(image)
    self.__button.set_value(self.__lcl.get_item(self.state['text'][windex]))

  def __button_clicked(self, button=None, user_data=None):
    return self.__switch(self.get_config_value('show-state-dialog'))

  def __button_tap_and_hold(self, button=None, user_data=None):
    return self.__switch(not(self.get_config_value('show-state-dialog')))

  def __switch(self, show_dialog):
    if not self.__processing:
      self.__processing = True
      self.start_animation()
      if show_dialog: gobject.idle_add(self.__show_switch_dialog)
      else: self.__switch_state(int(self.state['value'] == 0))
      self.__button.get_toplevel().hide()
    return True

  def __show_switch_dialog(self):
    settings_dialog = gtk.Dialog('%s' % (self.__name), None, gtk.DIALOG_MODAL | gtk.DIALOG_NO_SEPARATOR, (gtk.STOCK_PREFERENCES, gtk.RESPONSE_OK))
    self.state_control = ToggleControlMaemo5(self.__get_state_controls())
    self.state_control.set_active(self.state['value'])
    settings_dialog.vbox.pack_start(self.state_control.get_box(), True)
    height = self.state_control.get_height()

    if len(self.state['modes']) > 1:
      self.mode_control = ToggleControlMaemo5(self.__get_mode_controls())
      self.mode_control.set_active(self.state['mode'])
      settings_dialog.vbox.pack_start(self.mode_control.get_box(), True)
      height += self.mode_control.get_height()

    settings_button = settings_dialog.action_area.get_children()[0]
    settings_button.connect('clicked', self.__show_settings_dialog)

    settings_dialog.vbox.set_size_request(-1, min(350, height))
    settings_dialog.show_all()
    self.__processing = False

  def __get_state_controls(self):
    texts = map(self.__lcl.get_item, list(self.state['text']))
    return zip(texts, [self.__turn_state for t in texts])

  def __get_mode_controls(self):
    texts = map(self.__lcl.get, list(self.state['modes']))
    return zip(texts, [self.__turn_mode for t in texts])

  def __turn_state(self, widget=None, control=None, cstate=None):
    if widget.get_active():
      if not(cstate): cstate = control.get_active()
      chstate = min(1, int(cstate))
      if chstate != self.state['value']:
        try:
          self.__switch_state(chstate)
        except:
          self.switched()
          self.__update_ui()
      elif cstate != self.state['value']: control.set_active(self.state['value'])

  def __turn_mode(self, widget=None, control=None, cmode=None):
    if widget.get_active():
      if not(cmode): cmode = control.get_active()
      chmode = max(0, control.get_active())
      if self.state['value'] and  chmode != self.state['mode']:
        try:
          self.__switch_mode(chmode)
        except:
          self.switched()
          self.__update_ui()
      elif cmode != self.state['mode']: control.set_active(self.state['mode'])

  def __switch_state(self, new_state):
    cstate = min(1, self.state['value'])
    new_state = max(0, min(new_state, len(self.state['text']) - 1))
    if new_state != cstate:
      self.__button.set_value('...')
      try:
        if new_state: self.turn_on()
        else: self.turn_off()
      except:
        self.switched()
        self.__update_ui()
    else:
      self.__processing = False

  def __switch_mode(self, new_mode):
    cmode = max(0, self.state['mode'])
    new_mode = max(0, min(new_mode, len(self.state['modes']) - 1))
    if new_mode != cmode:
      try:
        self.turn_mode(new_mode)
      except:
        self.switched()
        self.__update_ui()

  def turn_mode(self, mode):
    pass

  def start_animation(self):
    self.__smi_animator.start()

  def stop_animation(self):
    self.__smi_animator.stop()

  def __set_si(self, key):
    self.__set_smi(key)
    self.__set_sai(key)

  def __set_smi(self, key):
    self.__button.get_image().set_from_pixbuf(self.__smi_cacher.get(key))

  def __set_sai(self, key):
    if any(self.state['show']):
      if self.state['show'][self.state['value']]: self.__set_status_area_icon(self.__name, key)
      else: self.__set_status_area_icon(self.__name, None, False)
