# -*- coding: utf-8 -*-
import xml.etree.ElementTree as et
import time

def indent(elem, level=0):
	i = "\n" + level*"  "
	if len(elem):
		if not elem.text or not elem.text.strip():
			elem.text = i + "  "
		for elem in elem:
			indent(elem, level+1)
			if not elem.tail or not elem.tail.strip():
				elem.tail = i + "  "
		if not elem.tail or not elem.tail.strip():
			elem.tail = i
	else:
		if level and (not elem.tail or not elem.tail.strip()):
			elem.tail = i

class AccFileIF:
	def Save(self, dataList, filename="reading.xml"):
		_tb = et.TreeBuilder()
		tree = _tb.start("accDisplayData",{"timestamp":time.ctime(time.time())})
		for dt in dataList:
			tmp = _tb.start("entry",{'x':str(dt[0]), 'y':str(dt[1]), 'z':str(dt[2])})
			tmp = _tb.end("entry")
		
		tree = _tb.end("accDisplayData")
		indent(tree)
		fileOut = open(filename,'w')
		fileOut.write(et.tostring(tree))
		fileOut.close()

	def Load(self, filename="reading.xml"):
		root = et.ElementTree(file=filename)
		
		data_ts = ""
		retrieved_data = []
		
		data_ts = root.getroot().get('timestamp')
		
		samples = root.getroot().findall("entry")
		for entry in samples:
			sample = []
			sample.append(float(entry.get('x')))
			sample.append(float(entry.get('y')))
			sample.append(float(entry.get('z')))
			retrieved_data.append(sample)
		
		return data_ts,retrieved_data

if __name__ == "__main__":
	fbe = AccFileIF()
	fbe.Save([[1,2,3], [39,596,77]])
	print fbe.Load()