/*
 * Copyright (C) 2008 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef WEBKIT_WEB_DOWNLOAD_H
#define WEBKIT_WEB_DOWNLOAD_H

#include <glib-object.h>

#include <webkit/webkitdefines.h>

G_BEGIN_DECLS

#define WEBKIT_TYPE_WEB_DOWNLOAD            (webkit_web_download_get_type())
#define WEBKIT_WEB_DOWNLOAD(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), WEBKIT_TYPE_WEB_DOWNLOAD, WebKitWebDownload))
#define WEBKIT_WEB_DOWNLOAD_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),  WEBKIT_TYPE_WEB_DOWNLOAD, WebKitWebDownloadClass))
#define WEBKIT_IS_WEB_DOWNLOAD(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), WEBKIT_TYPE_WEB_DOWNLOAD))
#define WEBKIT_IS_WEB_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  WEBKIT_TYPE_WEB_DOWNLOAD))
#define WEBKIT_WEB_DOWNLOAD_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),  WEBKIT_TYPE_WEB_DOWNLOAD, WebKitWebDownloadClass))

typedef enum {    
    WEBKIT_WEB_DOWNLOAD_STATE_ERROR = -1,
    WEBKIT_WEB_DOWNLOAD_STATE_CREATED = 0,
    WEBKIT_WEB_DOWNLOAD_STATE_STARTED,
    WEBKIT_WEB_DOWNLOAD_STATE_CANCELLED,
    WEBKIT_WEB_DOWNLOAD_STATE_FINISHED
} WebKitWebDownloadState;

typedef enum {    
    WEBKIT_WEB_DOWNLOAD_ERROR_CANCELLED_BY_USER,
    WEBKIT_WEB_DOWNLOAD_ERROR_NETWORK
} WebKitWebDownloadError;

struct _WebKitWebDownload {
    GObject parent;
};

struct _WebKitWebDownloadClass {
    GObjectClass parent;
};

WEBKIT_API GType
webkit_web_download_get_type                    (void);

WEBKIT_API WebKitWebDownload *
webkit_web_download_new                         (const gchar *uri);

WEBKIT_API WebKitWebDownload *
webkit_web_download_new_from_request            (WebKitNetworkRequest *request);

WEBKIT_API void
webkit_web_download_start                       (WebKitWebDownload    *download);

WEBKIT_API void
webkit_web_download_cancel                      (WebKitWebDownload    *download);

WEBKIT_API const gchar*
webkit_web_download_get_uri                     (WebKitWebDownload    *download);

WEBKIT_API WebKitNetworkRequest*
webkit_web_download_get_network_request         (WebKitWebDownload    *download);

WEBKIT_API const gchar*
webkit_web_download_get_suggested_filename      (WebKitWebDownload    *download);

WEBKIT_API void
webkit_web_download_set_suggested_filename      (WebKitWebDownload    *download,
                                                 const gchar          *filename);

WEBKIT_API const gchar*
webkit_web_download_get_local_uri               (WebKitWebDownload    *download);

WEBKIT_API void
webkit_web_download_set_local_uri               (WebKitWebDownload    *download,
                                                 const gchar          *local_uri);

WEBKIT_API guint64
webkit_web_download_get_total_size              (WebKitWebDownload    *download);

WEBKIT_API guint64
webkit_web_download_get_current_size            (WebKitWebDownload    *download);

WEBKIT_API WebKitWebDownloadState
webkit_web_download_get_state                   (WebKitWebDownload    *download);

G_END_DECLS

#endif
