/*
* Copyright (C) 2008 Luke Kenneth Casson Leighton <lkcl@lkcl.net>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public License
* along with this library; see the file COPYING.LIB.  If not, write to
* the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301, USA.
*/


#ifndef GSTRING_CONVERT_H
#define GSTRING_CONVERT_H

/* convenience functions for converting various webkit string types into a utf8 glib string */

#include "AtomicString.h"
#include "CString.h"
#include "KURL.h"
#include "PlatformString.h"
//#include "unicode/ustring.h"

inline gchar * gdom_gstring_convert(WebCore::String const& s) { return g_strdup(s.utf8().data()); }
inline gchar * gdom_gstring_convert(WebCore::KURL const& s) { return g_strdup(s.string().utf8().data()); }
inline gchar * gdom_gstring_convert(const JSC::UString & s) { return g_strdup(s.UTF8String().c_str()); }
inline gchar * gdom_gstring_convert(WebCore::AtomicString const&s) { return g_strdup(s.string().utf8().data()); }

#endif /* GSTRING_CONVERT_H */
