
import logging
import cgi, urllib, pycurl
from lib.error import Error

class Authentication(object, ):
    
    STATE_READY = 0
    STATE_INITED = 1
    STATE_AUTHORIZE_PENDING = 2
    STATE_AUTHORIZED = 3
    STATE_FINISHED = 4
    TIMEOUT = 20
    def __init__(self, initUrl, authUrl, tokenUrl, cb, cbError, consumerKey, consumerSecret, method='PLAINTEXT'):
        self._initUrl = initUrl
        self._authUrl = authUrl
        self._tokenUrl = tokenUrl
        self._cb = cb
        self._cbError = cbError
        self._consumerKey = consumerKey
        self._consumerSecret = consumerSecret
        self._method = method
        self._response = ''
        self._curl = None
        self._state = self.STATE_READY
        self._request_token = None
        self._request_token_secret = None
        self._authorize_verifier = None
        self._access_token = None
        self._access_token_secret = None
    def initCurl(self):
        self._curl = pycurl.Curl()
        self._curl.setopt(pycurl.WRITEFUNCTION, self.curlWrite)
        self._curl.setopt(pycurl.SSL_VERIFYPEER, False)
        self._curl.setopt(pycurl.HTTPHEADER, ['Keep-alive: 300', 'Connection: keep-alive'])
        self._curl.setopt(pycurl.CONNECTTIMEOUT, self.TIMEOUT)
        self._curl.setopt(pycurl.FOLLOWLOCATION, True)
        self._curl.setopt(pycurl.IPRESOLVE, pycurl.IPRESOLVE_V4)
    def closeCurl(self):
        if (self._curl != None):
            self._curl.close()
            self._curl = None
    def initialize(self):
        if (self._state != self.STATE_READY):
            raise StateError(self._state, self.STATE_READY)
        self.initCurl()
        try:
            logging.info('Sending initialize request')
            response = self.makeInitRequest()
            params = self._parseQs(response)
            logging.info(response)
            logging.info(params)
            try:
                self._request_token = params['oauth_token']
                self._request_token_secret = params['oauth_token_secret']
                self._state = self.STATE_INITED
                logging.info('Initialize request successful')
            except KeyError, key:
                raise AuthenticationError('Initializing failed, invalid response, no such key "%s" in received data.', key)
            return True
        except AuthenticationError, e:
            raise e
        except Exception, e:
            raise AuthenticationError('Initializing failed, request error: "%s"', str(e))
    def authorize(self, callback, unique, name='N900', register=False):
        
        if (self._state != self.STATE_INITED):
            raise StateError(self._state, self.STATE_INITED)
        url = self.makeAuthUrl(self._request_token, unique, name, register)
        try:
            logging.info('Calling authorize url')
            self._state = self.STATE_AUTHORIZE_PENDING
            callback(url)
            return True
        except Exception, e:
            raise AuthenticationError('Authorize call to provided callback failed: %s', str(e))
    def authorized(self, url):
        
        if (self._state != self.STATE_AUTHORIZE_PENDING):
            raise StateError(self._state, self.STATE_AUTHORIZE_PENDING)
        split = url.split('?')
        (bareUrl, qs) = (split[0].rstrip('/'), '?'.join(split[1:]))
        params = self._parseQs(qs)
        logging.info('Processing authorized callback')
        if (bareUrl == self._cb):
            try:
                self._authorize_verifier = params['verifier']
                self._state = self.STATE_AUTHORIZED
                logging.info('Authorization successful')
            except KeyError, key:
                raise AuthenticationError('Invalid authorization callback. No such key "%s" in received data.', key)
        else:
            if (bareUrl == self._cbError):
                raise AuthenticationError('Authorized error callback received: %s', url)
            else:
                raise AuthenticationError('Authorized expected callback for url "%s" but got "%s"', self._cb, bareUrl)
    def token(self):
        if (self._state != self.STATE_AUTHORIZED):
            raise StateError(self._state, self.STATE_AUTHORIZED)
        try:
            logging.info('Sending token request')
            response = self.makeTokenRequest(self._authorize_verifier, self._request_token_secret)
            params = self._parseQs(response)
            try:
                self._access_token = params['oauth_token']
                self._access_token_secret = params['oauth_token_secret']
                self._state = self.STATE_FINISHED
                logging.info('Token received. Success!')
            except KeyError, key:
                raise AuthenticationError('Getting token failed, invalid response, no such key "%s" in received data.', key)
        except AuthenticationError, e:
            raise e
        except Exception, e:
            raise AuthenticationError('Getting token failed, request error: "%s"', str(e))
    def getAccessToken(self):
        if (self._state != self.STATE_FINISHED):
            raise StateError(self._state, self.STATE_FINISHED)
        return (self._access_token, self._access_token_secret)
    def makeInitRequest(self):
        
        post = self._getConsumerData()
        post.update(self._getCallbackData())
        return self._curlRequest(self._initUrl, None, post)
    def makeAuthUrl(self, requestToken, unique, name='N900', register=False):
        
        get = {'oauth_token': requestToken, 'name': name, 'unique': unique}
        if register:
            get['register'] = ''
        return self._encodeUrl(self._authUrl, get)
    def makeTokenRequest(self, verifier, secret):
        
        post = self._getConsumerData(secret)
        post['oauth_verifier'] = verifier
        return self._curlRequest(self._tokenUrl, None, post)
    def _getConsumerData(self, secret=None):
        
        return {'oauth_consumer_key': self._consumerKey, 'oauth_signature_method': self._method, 'oauth_signature': self._getSignature(secret)}
    def _getCallbackData(self):
        
        return {'oauth_callback': self._cb, 'error_callback': self._cbError}
    def _getSignature(self, secret=None):
        return ('%s&%s' % (self._consumerSecret, (secret if secret else '')))
    def _encodeUrl(self, url, get=None):
        return (('%s?%s' % (url, urllib.urlencode(get))) if (get and (len(get) > 0)) else url)
    def _parseQs(self, qs):
        dic = cgi.parse_qs(qs)
        return dict(zip(dic.keys(), map(lambda item: (item[0] if (type(item) == list) else item), dic.values())))
    def _curlRequest(self, url, get=None, post=None):
        self._response = ''
        url = self._encodeUrl(url, get)
        logging.debug('Requesting %s, Post: %s', url, post)
        if (self._curl == None):
            self.initCurl()
        self._curl.setopt(pycurl.URL, url)
        if (post != None):
            self._curl.setopt(pycurl.POST, 1)
            self._curl.setopt(pycurl.POSTFIELDS, urllib.urlencode(post))
        self._curl.perform()
        return self._response
    def curlWrite(self, buf):
        self._response = (self._response + buf)

class AuthenticationError(Error, ):
    pass

class StateError(AuthenticationError, ):
    msg = 'State is %d (should be %d)'
