
import time
import urllib
import pycurl
import uuid
import simplejson
import logging
from error import Error
from util.task import Task

class Sync(object, ):
    TIMEOUT = 30
    def __init__(self, token, secret, consumerKey, consumerSecret, method='PLAINTEXT'):
        self._consumerKey = consumerKey
        self._consumerSecret = consumerSecret
        self._method = method
        self._token = token
        self._secret = secret
        self._response = ''
        self._headers = []
        self._curl = None
    def initCurl(self):
        self._curl = pycurl.Curl()
        self._curl.setopt(pycurl.WRITEFUNCTION, self.curlWrite)
        self._curl.setopt(pycurl.HEADERFUNCTION, self.curlWriteHeader)
        self._curl.setopt(pycurl.SSL_VERIFYPEER, False)
        self._curl.setopt(pycurl.HTTPHEADER, ['Keep-alive: 300', 'Connection: keep-alive'])
        self._curl.setopt(pycurl.CONNECTTIMEOUT, self.TIMEOUT)
        self._curl.setopt(pycurl.FOLLOWLOCATION, True)
        self._curl.setopt(pycurl.IPRESOLVE, pycurl.IPRESOLVE_V4)
    def closeCurl(self):
        if (self._curl != None):
            self._curl.close()
            self._curl = None
    def request(self, apiUrl, method, data=None, cb=None):
        logging.info('Requesting method %s on api %s. Callback specified: %s', method, apiUrl, cb)
        Task(self.requestFunc, cb).start(apiUrl, method, data)
    def requestFunc(self, apiUrl, method, data=None):
        (get, post) = (None, None)
        if (data != None):
            post = self._getRequestData()
            post['data'] = self._dataToJson(data)
        else:
            get = self._getRequestData()
        try:
            response = self._curlRequest(self._makeApiUrl(apiUrl, method), get, post)
            if ((len(self._headers) > 0) and self._headers[0].startswith('HTTP/1.1 401')):
                raise AuthorizationError('Authorization error when requesting api.')
            logging.info('Response: %s', response)
            data = self._jsonToData(response)
            logging.info('Response decoded: %s', str(data))
            (yield data)
        except AuthorizationError, e:
            (yield e)
        except Exception, e:
            (yield RequestError('Error requesting api: %s', str(e)))
    def requestSettings(self, api, currency, locale, timezone, version, initial=False, cb=None):
        return self.request(api, 'settings', {'currency': currency, 'locale': locale, 'timezone': timezone, 'initial_sync': initial, 'version': version}, cb)
    def requestTags(self, api, cb):
        return self.request(api, 'tags', cb=cb)
    def postTags(self, api, data, cb):
        return self.request(api, 'tags', data, cb=cb)
    def requestExpenses(self, api, cb):
        return self.request(api, 'expenses', cb=cb)
    def postExpenses(self, api, data, cb):
        return self.request(api, 'expenses', data, cb=cb)
    def _makeApiUrl(self, url, method):
        return ('%s%s/' % (url, method))
    def _dataToJson(self, data):
        return simplejson.dumps(data, ensure_ascii=False)
    def _jsonToData(self, json):
        try:
            if (len(json) == 0):
                return None
            return simplejson.loads(json)
        except ValueError, e:
            raise SyncError('Cannot decode JSON %s: %s', json, str(e))
    def _getConsumerData(self):
        
        return {'oauth_consumer_key': self._consumerKey, 'oauth_signature_method': self._method, 'oauth_signature': self._getSignature()}
    def _getRequestData(self):
        data = self._getConsumerData()
        data.update({'oauth_timestamp': int(time.time()), 'oauth_nonce': str(uuid.uuid4()), 'oauth_token': self._token})
        return data
    def _getSignature(self):
        return ('%s&%s' % (self._consumerSecret, self._secret))
    def _curlRequest(self, url, get=None, post=None):
        self._response = ''
        self._headers = []
        url = self._encodeUrl(url, get)
        logging.debug('Requesting %s with Post: %s', url, post)
        if (self._curl == None):
            self.initCurl()
        self._curl.setopt(pycurl.URL, url)
        if (post != None):
            self._curl.setopt(pycurl.POST, 1)
            self._curl.setopt(pycurl.POSTFIELDS, urllib.urlencode(post))
        else:
            self._curl.setopt(pycurl.POST, 0)
        self._curl.perform()
        return self._response
    def curlWrite(self, buf):
        self._response = (self._response + buf)
    def curlWriteHeader(self, buf):
        self._headers.append(buf)
    def _encodeUrl(self, url, get=None):
        return (('%s?%s' % (url, urllib.urlencode(get))) if (get and (len(get) > 0)) else url)
    def _parseQs(self, qs):
        dic = cgi.parse_qs(qs)
        return dict(zip(dic.keys(), map(lambda item: (item[0] if (type(item) == list) else item), dic.values())))

class SyncError(Error, ):
    pass

class RequestError(SyncError, ):
    pass

class AuthorizationError(SyncError, ):
    pass
