
import sys
import logging
import gtk, hildon

class Application:
    
    _program = None
    _views = {}
    _views_auto_ = []
    def __init__(self):
        self._initialize()
    def _initialize(self):
        
        logging.info('Initializing application')
        self._program = hildon.Program.get_instance()
        self._init_()
    def _init_(self):
        
        pass
    def _destroy_(self):
        
        pass
    def destroy(self, widget):
        logging.info('Destroying application')
        self._destroy_()
        gtk.main_quit()
    def main(self):
        
        gtk.gdk.threads_init()
        self.getView('main').getWidget().connect('destroy', self.destroy)
        self.getView('main').show()
        gtk.main()
    def getView(self, name, ctrl=False, autoload=True, force_reload=False):
        
        view = None
        if ((name in self._views) and not(force_reload)):
            view = self._views[name]
        else:
            if autoload:
                if force_reload:
                    self.clearView(name)
                logging.info('Trying to autoload view "%s"', name)
                view = self._autoload(name)
                if view:
                    self.addView(view)
        if not(view):
            raise ToshlException('Failed to get view "%s"', name)
        return (view.getCtrl() if ctrl else view)
    def viewLoaded(self, name):
        return (name in self._views)
    def addView(self, view):
        
        name = view.getName()
        assert (name not in self._views), ('View naming conflict, view "%s" already exists' % name)
        self._views[name] = view
    def clearView(self, name):
        if (name in self._views):
            del self._views[name]
    def pushView(self, name):
        view = self.getView(name)
        window = view.getWidget()
        assert isinstance(window, hildon.StackableWindow)
        self.getStack().push_1(window)
        window.show_all()
    def popView(self, name=None, literal=False):
        if name:
            fullname = (name if literal else ('%s_root' % name))
            windows = self.getStack().get_windows()
            if (len(windows) > 0):
                if (windows[0].get_name() == fullname):
                    self.getStack().pop_1()
        else:
            self.getStack().pop_1()
    def getStack(self):
        return hildon.WindowStack.get_default()
    def showLoading(self, view='main'):
        dialog = self.getView(view).getWidget()
        hildon.hildon_gtk_window_set_progress_indicator(dialog, 1)
    def hideLoading(self, view='main'):
        dialog = self.getView(view).getWidget()
        hildon.hildon_gtk_window_set_progress_indicator(dialog, 0)
    def _autoload(self, name):
        
        assert ((name in self._views_auto_) or (name == 'main')), ('No definition for autoloading view "%s"' % name)
        try:
            viewModuleName = ('app.view.%s' % name)
            ctrlModuleName = ('app.ctrl.%s' % name)
            __import__(viewModuleName)
            __import__(ctrlModuleName)
            viewClassName = ('%sView' % name.capitalize())
            ctrlClassName = ('%sCtrl' % name.capitalize())
            viewClass = sys.modules[viewModuleName].__getattribute__(viewClassName)
            ctrlClass = sys.modules[ctrlModuleName].__getattribute__(ctrlClassName)
            view = viewClass(name, ctrlClass(), self)
            return view
        except KeyError, e:
            raise e
            logging.error('Autoloading view "%s" failed. Error happened: %s', name, e.message)
            return None
