# coding=utf-8

import os, logging

config = {
    'data_path': '~/.toshl',
    'toshl_root': '/opt/toshl',
    'src_dir': 'src',
    'scheme_file': 'data/scheme.sql',
    'theme_file': 'data/theme.gtkrc',
    'db_file': 'toshl.db',
    'currencies': {
        'EUR': ['Euro', '€'],
        'USD': ['United States dollar', '$'],
        'GBP': ['Pound Sterling', '£'],
        'JPY': ['Japanese yen', '¥'],
        'CNY': ['Chinese renminbi', '¥'],
        'INR': ['Indian rupee', 'RS'],
        'CAD': ['Canadian dollar', '$'],
        'AUD': ['Australian dollar', '$'],
        'BRL': ['Brazilian real', 'R$'],
        'PLN': ['Polish złoty', 'zł'],
        'TRY': ['Turkish lira', 'TL'],
        'RUB': ['Russian ruble', 'pyб'],
        'SEK': ['Swedish krona', 'kr'],
        'HRK': ['Croatian kuna', 'kn'],
        'CHF': ['Swiss franc', 'CHF'],
    },
    'currency_default': 'EUR',
    'sync_options': [
        'on mobile connection or WiFi',
        'only when on WiFi',
        'don\'t sync',
    ],
    'log_file': 'log_daemon',
    'log_level': logging.DEBUG,
    'version': '1.5.5',
}

def get(name):
    return config[name]

def currency(abb):
    return get('currencies')[abb]

def joinData(path):
    return os.path.join(os.path.expanduser(config['data_path']), path)
    
def joinRoot(path):
    return os.path.join(config['toshl_root'], path)
    
def getThemeFile():
    return joinRoot(config['theme_file'])

def getSchemeFile():
    return joinRoot(config['scheme_file'])

def getDbFile():
    return joinData(config['db_file'])
    
def getLogFile():
    return joinData(config['log_file'])
    
def getCurrencyFromSymbol(sym):
    for abb, data in get('currencies').items():
        if data[1] == sym:
            return abb
    return get('currency_default')