
import gobject, gtk, hildon, pango
def _fillParameters(obj, **kwargs):
    for (key, value) in kwargs.items():
        methodName = ('set_%s' % key)
        if (value == None):
            obj.__getattribute__(methodName)()
        else:
            if not(isinstance(value, tuple)):
                value = (value,)
            obj.__getattribute__(methodName)(*value)
    return obj
def makeNew(clas, *args, **kwargs):
    obj = clas(*args)
    return _fillParameters(obj, **kwargs)
def newLabel(*args, **kwargs):
    return makeNew(gtk.Label, *args, **kwargs)
def newVBox(*args, **kwargs):
    return makeNew(gtk.VBox, *args, **kwargs)
def newHBox(*args, **kwargs):
    return makeNew(gtk.HBox, *args, **kwargs)
def newButton(**kwargs):
    return makeNew(hildon.Button, gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_HORIZONTAL, **kwargs)
def newFingerButton(**kwargs):
    return makeNew(hildon.Button, (gtk.HILDON_SIZE_FINGER_HEIGHT | gtk.HILDON_SIZE_AUTO_WIDTH), hildon.BUTTON_ARRANGEMENT_HORIZONTAL, **kwargs)
def newEventBox(**kwargs):
    return makeNew(gtk.EventBox, **kwargs)
def newWindow(**kwargs):
    return makeNew(hildon.StackableWindow, **kwargs)
def newEntry(size=gtk.HILDON_SIZE_AUTO, **kwargs):
    return makeNew(hildon.Entry, size, **kwargs)
def newAlignment(xalign=0.5, yalign=0.5, xscale=0.0, yscale=0.0, **kwargs):
    return makeNew(gtk.Alignment, xalign, yalign, xscale, yscale, **kwargs)
def align(widget, xalign=0.5, yalign=0.5, xscale=0.0, yscale=0.0, **kwargs):
    al = newAlignment(xalign, yalign, xscale, yscale, **kwargs)
    al.add(widget)
    return al
def pad(widget, top=0, bottom=0, right=0, left=0, **kwargs):
    kwargs['padding'] = (top, bottom, left, right)
    al = newAlignment(xscale=1.0, yscale=1.0, **kwargs)
    al.add(widget)
    return al
def newFixed(**kwargs):
    return makeNew(gtk.Fixed, **kwargs)
def newImage(**kwargs):
    return makeNew(gtk.Image, **kwargs)
def wrap(obj, wrapper):
    wrapper.add(obj)
    return wrapper

class AutocompleteEntry(hildon.Entry, ):
    _delimiters_ = (',',)
    def __init__(self, size=gtk.HILDON_SIZE_AUTO):
        hildon.Entry.__init__(self, size)
        self._dict = ['abc', 'moja mama', 'hahahahaha', 'haloooo', 'ca']
        self.set_input_mode(gtk.HILDON_GTK_INPUT_MODE_FULL)
        self._handler = self.connect('insert-text', self.on_insert_text)
        self._transform = None
        self._completed = False
    def set_dictionary(self, d):
        self._dict = d
    def _get_begin_of_word(self, text, pos, delimiters=None):
        delimiters = (delimiters if delimiters else self._delimiters_)
        begin = []
        i = pos
        while (i >= len(text)):
            i -= 1
        try:
            c = text[(i + 1)]
            if (c not in ((' ',) + delimiters)):
                return None
        except IndexError:
            pass
        while ((i > -1) and (text[i] not in delimiters)):
            begin.append(text[i])
            i -= 1
        begin.reverse()
        return (''.join(begin).lstrip() if (len(begin) > 0) else None)
    def _find_end(self, begin):
        l = len(begin)
        for item in self._dict:
            if (item[:l] == begin):
                return item[l:]
        return None
    def on_insert_text(self, widget, new_text, new_text_length, position, data=None):
        self._completed = False
        pos = widget.get_position()
        begin = self._get_begin_of_word((widget.get_text() + new_text), pos)
        if begin:
            end = self._find_end(begin)
            if end:
                self._completed = True
                end = (self._transform(end) if self._transform else end)
                self.handler_block(self._handler)
                widget.insert_text(end, (pos + 1))
                self.handler_unblock(self._handler)
                gobject.idle_add(widget.select_region, (pos + 1), ((pos + len(end)) + 1))
    def set_transform(self, cb):
        self._transform = cb

class TextView(hildon.TextView, ):
    def __init__(self):
        hildon.TextView.__init__(self)
        self.set_wrap_mode(gtk.WRAP_WORD)
    def get_text(self):
        b = self.get_buffer()
        return b.get_text(b.get_start_iter(), b.get_end_iter())
    def set_text(self, text):
        self.get_buffer().set_text(text)
def newTextView(**kwargs):
    return makeNew(TextView, **kwargs)

class AppMenu(hildon.AppMenu, ):
    def __init__(self):
        hildon.AppMenu.__init__(self)
        self._firstFilter = None
    def add_button(self, label, **kwargs):
        button = newButton(label=label, **kwargs)
        self.append(button)
        return button
    def add_filter(self, label, icon, left=True):
        radio = makeNew(gtk.RadioButton)
        radio.set_mode(False)
        im = newImage(from_file=icon)
        imBox = newVBox()
        imBox.pack_start(newLabel(size_request=(-1, 5)))
        imBox.pack_start(im)
        hbox = newHBox(spacing=10)
        if left:
            hbox.pack_start(imBox, expand=False)
        hbox.pack_start(newLabel(label=label), expand=False)
        if not(left):
            hbox.pack_start(imBox, expand=False)
        radio.add(align(hbox))
        if not(self._firstFilter):
            self._firstFilter = radio
        else:
            radio.set_group(self._firstFilter)
        hildon.AppMenu.add_filter(self, radio)
        return radio
    def add_custom_button(self, label, **kwargs):
        button = newButton(size_request=(100, 70), **kwargs)
        label = newLabel(text=label, name='GtkLabel')
        black = gtk.gdk.color_parse('#111111')
        label.modify_fg(gtk.STATE_NORMAL, black)
        label.modify_fg(gtk.STATE_PRELIGHT, black)
        label.modify_fg(gtk.STATE_ACTIVE, black)
        button.add(label)
        vbox = self.get_child()
        vbox.pack_end(button, expand=True, fill=True)
        vbox.show_all()
        return button
    def remove_custom_button(self, button):
        vbox = self.get_child()
        try:
            vbox.remove(button)
        except:
            pass
def newAppMenu(**kwargs):
    return makeNew(AppMenu, **kwargs)

class PannableArea(hildon.PannableArea, ):
    MODE_PUSH = hildon.PANNABLE_AREA_MODE_PUSH
    MODE_ACCEL = hildon.PANNABLE_AREA_MODE_ACCEL
    MODE_AUTO = hildon.PANNABLE_AREA_MODE_AUTO
    ORIENT_HORIZ = hildon.MOVEMENT_MODE_HORIZ
    ORIENT_VERT = hildon.MOVEMENT_MODE_VERT
    ORIENT_BOTH = hildon.MOVEMENT_MODE_BOTH
    def __init__(self):
        hildon.PannableArea.__init__(self)
    def set_mode(self, mode):
        assert (mode in [self.MODE_PUSH, self.MODE_ACCEL, self.MODE_AUTO])
        self.set_property('mode', mode)
    def set_orientation(self, orient):
        assert (orient in [self.ORIENT_HORIZ, self.ORIENT_VERT, self.ORIENT_BOTH])
        self.set_property('mov-mode', orient)
def newPannableArea(**kwargs):
    return makeNew(PannableArea, **kwargs)

class PickerDialogFake(hildon.PickerDialog, ):
    
    def __init__(self, title, window):
        hildon.PickerDialog.__init__(self, window)
        self.set_decorated(False)
        self._vbox = newVBox()
        self._vbox.pack_start(self._get_titlebar(title), fill=False, expand=False)
        alignment = self.get_child()
        self.remove(alignment)
        self._vbox.pack_start(alignment, fill=True, expand=True)
        self.add(self._vbox)
    def _get_titlebar(self, title):
        label = wrap(newLabel(text=title, size_request=(-1, 49)), newEventBox(name='wm_picker_dialog_titlebar'))
        return label

class DialogFake(hildon.Dialog, ):
    def __init__(self, title):
        hildon.Dialog.__init__(self)
        self.set_title(title)
        self.set_decorated(False)
        self._vbox = newVBox()
        self._vbox.pack_start(self._get_titlebar(title), fill=False, expand=False)
        alignment = self.get_child()
        self.remove(alignment)
        self._vbox.pack_start(alignment, fill=True, expand=True)
        self.add(self._vbox)
    def _get_titlebar(self, title):
        label = wrap(newLabel(text=title, size_request=(-1, 49)), newEventBox(name='wm_picker_dialog_titlebar'))
        return label
def newPickerDialog(title, window, **kwargs):
    return makeNew(PickerDialogFake, title, window, **kwargs)

class TextTouchSelector(hildon.TouchSelector, ):
    def __init__(self):
        hildon.TouchSelector.__init__(self)
        self._store = gtk.ListStore(str)
        self.append_text_column(self._store, True)
        self.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
    def append_row(self, name):
        self._store.append((name,))
def newTextTouchSelector(**kwargs):
    return makeNew(TextTouchSelector, **kwargs)

class Switcher(gtk.EventBox, ):
    __gsignals__ = {'switch': (gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, (str,))}
    def __init__(self):
        gtk.EventBox.__init__(self)
        self._items = {}
        self._shown = False
    def add_item(self, name, item):
        assert (name not in self._items), ('Switcher already has item "%s"' % name)
        self._items[name] = item
    def get_item(self, name):
        return self._items[name]
    def do_switch(self, name):
        item = self.get_item(name)
        if self._shown:
            self.remove(self.get_item(self._shown))
        self.add(item)
        self._shown = name
    def switch(self, name, show=False):
        assert (name in self._items), ('Cannot switch to "%s". No such item' % name)
        self.emit('switch', name)
        if show:
            self.show_all()
def newSwitcher(**kwargs):
    return makeNew(Switcher, **kwargs)
def newToggle(side0, side1, **kwargs):
    return makeNew(Toggle, side0, side1, **kwargs)

class Toggle(gtk.Button, ):
    __gsignals__ = {'switch': (gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, (int,))}
    def __init__(self, side0, side1):
        gtk.Button.__init__(self)
        self._sides = [side0, side1]
        self._current = 0
        self._render(False)
        self.connect('clicked', self.on_click)
    def _render(self, show=True):
        child = self.get_child()
        if child:
            self.remove(child)
        self.add(self._sides[self._current])
        if show:
            self.show_all()
    def getCurrent(self):
        return self._current
    def switch(self):
        new = int(not(bool(self._current)))
        self.emit('switch', new)
    def do_switch(self, value):
        self._current = value
        self._render()
    def on_click(self, widget, data=None):
        self.switch()
def newToolbar(**kwargs):
    return makeNew(gtk.Toolbar, **kwargs)
def toolItem(wid, **kwargs):
    assert isinstance(wid, gtk.Widget), 'Need widget'
    tool = makeNew(gtk.ToolItem, **kwargs)
    tool.add(wid)
    return tool
def truncateText(text, width=305, charMax=50, font='Nokia Sans 18', trans=lambda text: (text.rstrip('.')[:-1] + '..'), end=None, widget=None):
    if (len(text) > charMax):
        text = text[:charMax]
    if not(widget):
        widget = gtk.DrawingArea()
    def getWidth(text):
        layout = widget.create_pango_layout(text)
        layout.set_font_description(pango.FontDescription(font))
        return (layout.get_size()[0] / pango.SCALE)
    w = getWidth(text)
    while (w > width):
        text = trans(text)
        w = getWidth((text + (end if end else '')))
    return (text + (end if end else ''))
