
import format
from expense import ExpenseCtrl
from app.view.expense import ExpenseSection
from lib.util import locality

class TagsCtrl(ExpenseCtrl, ):
    _type = ExpenseSection.TYPE_TAGS
    _detail = 'tagsdetail'
    def getSectionByLetter(self, letter):
        
        ids = sorted((self._ids + [letter]), locality.getStrCol())
        try:
            i = ids.index(letter)
            try:
                return ids[(i + 1)]
            except:
                return ids[(i - 1)]
        except:
            return None
    def _afterFill(self):
        ts = ('%s:' % format.formatTimespan(self.getApp().getTimespan()))
        self.getView().mapSections(lambda s: s.setTotalLabel(ts))
        form = self.getApp().getAccount().getNumberFormat()
        def setSummer(section):
            section.updateSummer()
        self.getView().mapSections(lambda s: s.updateSummer(form))
    def _sectionIdToTitle(self, id):
        return id
    def _getSectionPos(self, id):
        ids = sorted((self._ids + [id]), locality.getStrCol())
        return ids.index(id)
    def _doFill(self):
        self._generator = self.getApp().getStore().selectExpensesForDisplay(self.getApp().getTimespanRange(), self.FILL_LIMIT, True)
        self.fill_on()
    def _doFillRow(self, row, insert=False):
        import logging
        dateFormatted = format.formatDateSmart(row[2], self.getApp().getAccount().getDateFormat())
        amountFormatted = format.formatAmountTruncate(row[1], self.getApp().getAccount().getNumberFormat(), 140)
        self.addRow(row[3], row[0], dateFormatted, amountFormatted, row[1], row[2].isoformat(), insert)
    def _doFillEnd(self):
        self.afterFill()
        self.selectFirst()
        self._filled = True
