
import logging
from lib.mvc.ctrl import Ctrl
from add import AddCtrl

class EdittagsCtrl(Ctrl, ):
    def _init_(self):
        self._changed = False
        self.getWidget('tag_list').register_submit(self.on_tag_submit)
    def on_show(self, widget, data=None):
        self._changed = False
    def on_delete_event(self, widget, data=None):
        if (self._changed == True):
            self.getCtrl('area').fill()
        self.getApp().popView()
        return True
    def fill(self):
        list = self.getWidget('tag_list')
        list.clear()
        tags = self.getApp().getStore().selectTagsForEdit()
        for tag in tags:
            list.add_row(tag['uuid'], tag['name'], tag['count'])
    def on_tag_submit(self, uuid, new_name):
        exist = self.getApp().getStore().selectTagsByNames([new_name])
        row = exist.fetchone()
        if (row and (row[0] != uuid)):
            self.getApp().getContext().sysNote('Tag with this name already exists')
            return False
        else:
            if (len(new_name) > AddCtrl.TAG_MAX):
                self.getApp().getContext().sysNote(('Tag can have max %d characters' % AddCtrl.TAG_MAX))
            else:
                try:
                    self.getApp().getStore().renameTag(uuid, new_name)
                    self.getApp().getStore().commit()
                    self._changed = True
                    self.getApp().getContext().sysNote('Tag saved')
                    return True
                except:
                    return False
        logging.info('Submiting tag %s, new name: %s', uuid, new_name)
        return False
