
import gtk, hildon
import format
import logging
from lib.mvc.ctrl import Ctrl
from lib.mvc.widgets import *
from view.settings import *

class SettingsCtrl(Ctrl, ):
    def _init_(self):
        self.getWidget('currency_dropdown').connect_on_show(self.on_currency_dd_show)
        self.getWidget('currency_dropdown').connect_on_selected(self.on_currency_dd_selected)
        self.getWidget('sync_dropdown').connect_on_show(self.on_sync_dd_show)
        self.getWidget('sync_dropdown').connect_on_selected(self.on_sync_dd_selected)
    def on_show(self, widget, data=None):
        account = self.getApp().getAccount()
        if account.isLoggedIn():
            self.getWidget('account_info').switch('logged')
            if account.isPro():
                self.getWidget('account_info_logged').setPro(True)
            else:
                self.getWidget('account_info_logged').setPro(False)
            self.getWidget('account_info_logged').setEmail(account.get('email'))
            self.getView().setSyncLabel(self.getApp().getAccount().getLastSync())
            self.getWidget('sync_dropdown').set_label_text(config.get('sync_options')[self.getApp().getStore().getPref('sync_when')])
            self.getWidget('sync_switcher').switch('sync', True)
        else:
            self.getWidget('account_info').switch('default')
            self.getWidget('sync_switcher').switch('empty', True)
        self.getWidget('currency_dropdown').set_label_text(format.formatCurrency(account.getCurrency()))
        self.getView().setTagsLabel(self.getApp().getStore().countTags())
    def on_delete_event(self, widget, data=None):
        self.getApp().popView()
        return True
    def on_login_button_clicked(self, widget, data=None):
        self.getApp().getContext().authenticate(False, self.getApp().getContext().AUTH_SRC_SETTINGS)
    def on_register_button_clicked(self, widget, data=None):
        self.getApp().getContext().authenticate(True, self.getApp().getContext().AUTH_SRC_SETTINGS)
    def on_sync_button_clicked(self, widget, data=None):
        self.getApp().getContext().synchronize()
    def on_tags_button_clicked(self, widget, data=None):
        self.getCtrl('edittags').fill()
        self.getApp().pushView('edittags')
    def on_currency_dd_show(self, dropDown):
        dialog = DropdownDialog(self.getView('main').getWidget(), dropDown, 'Your currency')
        accountCurrency = self.getApp().getAccount().getCurrency()
        isCustom = self.getApp().getAccount().hasCustomCurrency()
        (i, active) = (0, False)
        for cur in config.get('currencies_order'):
            display = format.formatCurrency(cur)
            dialog.appendRow(display)
            if (cur == accountCurrency):
                active = True
                dropDown.set_active(i)
                dropDown.set_label_text(display)
            i += 1
        dialog.appendRow(('Custom currency%s' % ((' %s' % accountCurrency) if isCustom else '')))
        if not(active):
            dropDown.set_active(i)
            dropDown.set_label_text(('Custom currency%s' % ((' %s' % accountCurrency) if isCustom else '')))
        return dialog
    def on_currency_dd_selected(self, i):
        curs = config.get('currencies_order')
        try:
            cur = curs[i]
            if (self.getApp().getAccount().getCurrency() != cur):
                self.getApp().getStore().updateAccount(currency_default=cur)
                self.getWidget('currency_dropdown').set_label_text(format.formatCurrency(cur))
                self.getCtrl('area').fill()
        except IndexError, e:
            dialog = DialogFake('Enter custom currency')
            dialog.add_button('Done', 1)
            vbox = dialog.get_children()[0].get_children()[1].get_child().get_children()[0]
            entry = newEntry(max_length=3, name='settings_currency_entry', size_request=(-1, 60), input_mode=gtk.HILDON_GTK_INPUT_MODE_FULL)
            if self.getApp().getAccount().hasCustomCurrency():
                entry.set_text(self.getApp().getAccount().getCurrency())
            vbox.pack_start(pad(entry, top=5), expand=False, fill=False)
            dialog.show_all()
            res = dialog.run()
            if (res == 1):
                cur = unicode(entry.get_text())
                if (len(cur) < 1):
                    self.getApp().getContext().sysNote('Currency must be at least 1 character long')
                else:
                    if (len(cur) > 3):
                        self.getApp().getContext().sysNote('Currency must not be longer than 3 characters')
                    else:
                        if (self.getApp().getAccount().getCurrency() != cur):
                            self.getApp().getStore().updateAccount(currency_default=cur)
                            self.getWidget('currency_dropdown').set_label_text(format.formatCurrency(cur))
                            self.getCtrl('area').fill()
            dialog.destroy()
    def on_sync_dd_show(self, dropDown):
        dialog = DropdownDialog(self.getView('main').getWidget(), dropDown, 'Sync with Toshl.com')
        prefSync = self.getApp().getStore().getPref('sync_when')
        i = 0
        for name in config.get('sync_options'):
            dialog.appendRow(name)
            if (i == prefSync):
                dropDown.set_active(i)
                dropDown.set_label_text(name)
            i += 1
        return dialog
    def on_sync_dd_selected(self, i):
        if ((self.getApp().getStore().getPref('sync_when') != i) and (i in range(3))):
            self.getApp().getStore().setPref('sync_when', i)
            self.getWidget('sync_dropdown').set_label_text(config.get('sync_options')[i])
