
import logging
import datetime
import gobject, hildon
import format
from lib.util import locality, tz, removeFromList
from lib.mvc.ctrl import Ctrl
from lib.mvc.widgets import newPickerDialog

class AddCtrl(Ctrl, ):
    YEAR_RANGE = 10
    MODE_ADD = 0
    MODE_EDIT = 1
    AMOUNT_MAX = (pow(10, 12) - 1)
    DESC_MAX = 500
    TAG_MAX = 150
    def _init_(self):
        self.set_amount_symbol(self.getApp().getAccount().getCurrencySymbol())
        self.getWidget('tags_buttons').setCallback(self.on_tag_selected)
        self._mode = self.MODE_ADD
        self._uuid = None
        self._processing = False
        self._prevDate = None
    def on_show(self, widget, data=None):
        self.getWidget('amount_entry').grab_focus()
        self.set_amount_symbol(self.getApp().getAccount().getCurrencySymbol())
    def on_delete_event(self, widget, data=None):
        self.getApp().popView('add')
        return True
    def on_done_button_clicked(self, widget, data=None):
        if not(self._processing):
            self._processing = True
            self.getApp().showLoading('add')
            gobject.idle_add(self.cb_done)
    def cb_done(self):
        
        afterAdd = False
        error = False
        try:
            parsedAmount = format.parseAmount(self.getWidget('amount_entry').get_text())
            if (parsedAmount == None):
                raise Exception()
            if (parsedAmount <= 0):
                raise Exception()
            else:
                if (parsedAmount > self.AMOUNT_MAX):
                    self.getApp().getContext().sysNote('Amount is too big')
                    error = True
        except:
            self.getApp().getContext().sysNote('Please enter amount')
            error = True
        if not(error):
            try:
                parsedTags = format.parseTags(self.getWidget('tags_entry').get_text())
                if ((type(parsedTags) != list) or (len(parsedTags) < 1)):
                    raise Exception()
                for tag in parsedTags:
                    if (len(tag) > self.TAG_MAX):
                        self.getApp().getContext().sysNote(('Tag can have max %d characters' % self.TAG_MAX))
                        error = True
            except:
                self.getApp().getContext().sysNote('Please choose at least one tag')
                error = True
        if not(error):
            desc = self.getWidget('description_entry').get_text()
            if (len(desc) > self.DESC_MAX):
                self.getApp().getContext().sysNote(('Description can be max %d characters' % self.DESC_MAX))
                error = True
        if error:
            self._processing = False
            self.getApp().hideLoading('add')
            return
        uuid = None
        if (self._mode == self.MODE_ADD):
            try:
                uuid = self.getApp().getStore().userInsertExpense(parsedAmount, parsedTags, desc, self._currentDate)
                self.getApp().getStore().commit()
                if self.getApp().dateInTimespan(self._currentDate):
                    afterAdd = True
            except Exception, e:
                logging.error('Failed inserting new user expense: %s', e)
        if ((self._mode == self.MODE_EDIT) and (self._uuid != None)):
            try:
                uuid = self._uuid
                self.getApp().getStore().userUpdateExpense(self._uuid, parsedAmount, parsedTags, desc, self._currentDate)
                self.getApp().getStore().commit()
                empty = self.getCtrl('area').remove_row(self._uuid, None, (self._currentDate != self._prevDate))
                if ((empty == False) and self.getApp().dateInTimespan(self._currentDate)):
                    afterAdd = True
            except Exception, e:
                logging.error('Failed updating expense %s: %s', self._uuid, e)
        self._processing = False
        self.getApp().hideLoading('add')
        self.getApp().popView('add')
        if (afterAdd == True):
            self.after_add(uuid, parsedAmount, self._currentDate, parsedTags)
    def before_add(self):
        self._mode = self.MODE_ADD
        self.getWidget('done_button').set_label('Add')
        self.getWidget('amount_entry').set_text_manually('')
        self.getWidget('tags_entry').set_text('')
        self.getWidget('description_entry').set_text('')
        self.set_date(datetime.datetime.now().date())
        self.feed_tags(self.getApp().getStore().getTopTags())
        self.feed_amounts(self.getApp().getStore().getAmountsForComplete())
    def before_edit(self, uuid):
        row = self.getApp().getStore().getExpense(uuid)
        if not(row):
            self.before_add()
        else:
            self._prevDate = row['date']
            self._mode = self.MODE_EDIT
            self._uuid = uuid
            self.getWidget('done_button').set_label('Done')
            amountFormatted = format.formatAmount(row['amount'], self.getApp().getAccount().getBareNumberFormat())
            self.getWidget('amount_entry').set_text_manually(amountFormatted)
            self.getWidget('tags_entry').set_text(', '.join(row['tags']))
            self.getWidget('description_entry').set_text(row['description'])
            self.set_date(row['date'])
            self.feed_tags(removeFromList(self.getApp().getStore().getTopTags(), row['tags']))
            self.feed_amounts(self.getApp().getStore().getAmountsForComplete())
    def after_add(self, uuid, parsedAmount, curDate, parsedTags):
        self.getApp().showLoading('main')
        canSelect = self.getCtrl('area').add_row([uuid, parsedAmount, curDate, parsedTags], True)
        if (canSelect != False):
            gobject.idle_add(self.getCtrl('area').select, uuid)
            self.getCtrl('area').reswitch()
        self.getApp().hideLoading('main')
    def set_amount_symbol(self, sym):
        self.getWidget('amount_symbol').set_text((' %s' % sym))
    def on_amount_entry_focus_in_event(self, widget, event, data=None):
        entry = self.getWidget('amount_entry')
        entry.select_region(-1, -1)
    def feed_amounts(self, amounts):
        self.getWidget('amount_entry').set_dictionary(amounts)
    def on_tag_selected(self, name):
        entry = self.getWidget('tags_entry')
        prev = entry.get_text()
        entry.set_text((('%s, %s, ' % (prev.rstrip(' ,'), name)) if (len(prev) > 0) else ('%s, ' % name)))
        entry.grab_focus()
        entry.select_region(-1, -1)
    def feed_tags(self, tags):
        self.getWidget('tags_entry').set_dictionary(tags)
        self.getWidget('tags_buttons').feed(tags)
    def on_tags_entry_focus_in_event(self, widget, event, data=None):
        entry = self.getWidget('tags_entry')
        entry.select_region(-1, -1)
    def set_date(self, date):
        self._currentDate = date
        self.getWidget('date_entry').set_text(date.strftime(self.getApp().getAccount().getDateFormat()))
        logging.debug('Selected date: %s', date.isoformat())
    def date_selected(self, result, startYear):
        (year, month, day) = result
        self.set_date(datetime.date((startYear + year), (month + 1), (day + 1)))
    def on_date_entry_focus_in_event(self, widget, event, data=None):
        year = datetime.datetime.now().year
        (startYear, endYear) = ((year - self.YEAR_RANGE), (year + self.YEAR_RANGE))
        (iday, imonth, iyear) = (0, 1, 2)
        dialog = newPickerDialog('Choose date', self.getWidget())
        dialog.connect('realize', self.on_date_dialog_realize)
        selector = hildon.hildon_date_selector_new_with_year_range(startYear, endYear)
        for i in (0, 1, 2):
            model = selector.get_model(i)
            first = model.get_value(model[0].iter, 1)
            if (first == 0):
                imonth = i
            else:
                if (first == 1):
                    iday = i
                else:
                    iyear = i
        dialog.set_selector(selector)
        dialog.show_all()
        dialog.run()
        result = map(selector.get_active, (iyear, imonth, iday))
        dialog.destroy()
        self.date_selected(result, startYear)
        self.getWidget('description_entry').grab_focus()
    def on_date_dialog_realize(self, dialog, data=None):
        selector = dialog.get_selector()
        selector.select_current_date(self._currentDate.year, (self._currentDate.month - 1), self._currentDate.day)
