
import os
import logging
import gtk
import datetime
import config, store, context
from lib.util import tz
from lib.mvc.app import Application
from lib.maemo.context import Context

class Toshl(Application, ):
    
    _store = None
    _views_auto_ = ['main', 'area', 'timeline', 'tags', 'tldetail', 'tagsdetail', 'add', 'welcome', 'loader', 'settings', 'edittags']
    _tasks = {}
    _context = None
    _timespan = 'month'
    INIT_STORE_DELAY = 1000
    LAST_MONT_RANGE = 30
    def _init_(self):
        self._initTheme()
        self._initContext()
        self.getContext().app_on()
        self.initStore()
    def _destroy_(self):
        self.getContext().app_off(self._store.getPref('sync_when'), (self._store.thingsChanged() and self.getAccount().isLoggedIn()))
        if self._store:
            self._store.close()
    def _initTheme(self):
        
        logging.info('Initializing gtk theme')
        gtk.rc_set_default_files((gtk.rc_get_default_files() + (config.getThemeFile(),)))
    def _initContext(self):
        self._context = context.AppContext(self)
    def getContext(self):
        return self._context
    def initStore(self):
        
        if self._store:
            self._store.close()
            self._store = None
        try:
            logging.info('Initializing store with sqlite file %s', config.getDbFile())
            self._store = store.Store(config.getDbFile(), config.getSchemeFile())
        except:
            gobject.timeout_add(self.INIT_STORE_DELAY, self.initStore)
    def closeStore(self):
        logging.info('Closing store')
        self._store.close()
    def getStore(self):
        return self._store
    def getAccount(self):
        return self._store.getAccount()
    def setTimespan(self, ts):
        if ((ts in ['month', 'all']) or isinstance(ts, datetime.date)):
            self._timespan = ts
    def getTimespan(self):
        return self._timespan
    def getTimespanRange(self):
        (ts, start) = (None, None)
        if (self._timespan == 'all'):
            return None
        if (self._timespan == 'month'):
            (end, today) = (self.getStore().getLastExpenseDate(), datetime.datetime.now().date())
            if (end > today):
                end = today
            start = (end - datetime.timedelta(self.LAST_MONT_RANGE))
            return (start, end)
        else:
            temp = self._timespan
        start = datetime.date(temp.year, temp.month, 1)
        end = (datetime.date(((start.year + 1) if (start.month == 12) else start.year), ((start.month + 1) if (start.month < 12) else 1), 1) - datetime.timedelta(1))
        return (start, end)
    def dateInTimespan(self, date):
        range = self.getTimespanRange()
        if (range == None):
            return True
        (start, end) = range
        return ((date <= end) and (date >= start))
    def setTask(self, name, task):
        self._tasks[name] = task
    def getTask(self, name):
        if (name in self._tasks):
            return self._tasks[name]
        return None
