
import datetime
import format
from expense import ExpenseCtrl
from lib.mvc.widgets import newEventBox, newHBox, newLabel, truncateText
from lib.util import tz, locality

class TimelineCtrl(ExpenseCtrl, ):
    def _init_(self):
        ExpenseCtrl._init_(self)
        self._summerContainer = None
        self._summer = None
        self._sumInteger = 0L
    def _afterFill(self):
        sums = self.getView().mapSections(lambda section: long(section.getSum()))
        self._sumInteger = reduce(long.__add__, sums)
        sum = format.formatAmount(self._sumInteger, self.getApp().getAccount().getNumberFormat())
        if not(self._summerContainer):
            self._summerContainer = newEventBox(name='expense_section_summer_red', size_request=(-1, 44))
            hbox = newHBox()
            hbox.pack_start(newLabel(text=('%s:' % format.formatTimespan(self.getApp().getTimespan())), padding=(15, 0), alignment=(0.0, 0.5)))
            self._summer = newLabel(text=sum, name='expense_section_summer_small', padding=(15, 1), alignment=(1.0, 0.5))
            hbox.pack_end(self._summer)
            self._summerContainer.add(hbox)
            self.getWidget('section_space').pack_end(self._summerContainer, expand=False, fill=False)
            self._summerContainer.show_all()
        else:
            self.updateSummer()
    def _sectionIdToTitle(self, id):
        return format.formatDateSmart(format.parseDate(id), self.getApp().getAccount().getDateFormat())
    def _getSectionPos(self, id):
        ids = sorted((self._ids + [id]), locality.getStrCol())
        ids.reverse()
        return ids.index(id)
    def updateSummer(self):
        if self._summer:
            sum = format.formatAmount(self._sumInteger, self.getApp().getAccount().getNumberFormat())
            self._summer.set_text(sum)
    def addToSum(self, sum):
        self._sumInteger += sum
    def clear(self):
        ExpenseCtrl.clear(self)
        self._summer = None
        self._summerContainer = None
    def _doFill(self):
        self._generator = self.getApp().getStore().selectExpensesForDisplay(self.getApp().getTimespanRange(), self.FILL_LIMIT)
        self.fill_on()
    def _doFillRow(self, row, insert=False):
        amountFormatted = format.formatAmountTruncate(row[1], self.getApp().getAccount().getNumberFormat(), 140)
        self.addRow([row[2].isoformat()], row[0], truncateText(', '.join(row[3])), amountFormatted, row[1], row[2].isoformat(), insert)
    def _doFillEnd(self):
        self.afterFill()
        self.selectFirst()
        self._filled = True
