/*
 * track_listview.c
 *
 *  Created on: 2009-10-22
 *      Author: marcin
 */

#include <hildon/hildon.h>
#include "track_listview.h"
#include "data_structs.h"
#include "jamendo_api.h"
#include "player.h"


/****************************************************************************
 *
 */

enum {
	COLUMN_NAME, COLUMN_DURATION, COLUMN_RATING, COLUMN_TRACK_PTR, NUM_COLUMNS
};

/****************************************************************************
 *
 */
static void track_row_tapped(GtkTreeView* treeview, GtkTreePath* path, gpointer data) {
	GtkTreeModel *model;
	GtkTreeIter iter;
	Track* track = NULL;

	model = gtk_tree_view_get_model(treeview);
	if (gtk_tree_model_get_iter(model, &iter, path)) {
		gtk_tree_model_get(model,&iter,COLUMN_TRACK_PTR,&track,-1);
	}

	play_track(track);
}

/*****************************************************************************
 *
 */
GtkTreeModel* track_listview_create_model(GList* track_list, gint flags) {
	GtkListStore *store;
	GtkTreeIter iter;

	GList* track_iter;
	gchar* stars[]={"","*","**","***","****","*****"};

	store = gtk_list_store_new(NUM_COLUMNS,  G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER);

	if (!track_list)
		return GTK_TREE_MODEL(store);

	for (track_iter = g_list_first(track_list); track_iter; track_iter = track_iter->next) {
		Track* track = (Track*) track_iter->data;
		gchar* name;
		gchar* duration = g_strdup_printf("%02d:%02d",track->duration/60,track->duration%60);
		gchar* rating =  g_strdup_printf("<span color='orange' size='medium' weight='bold'>%s</span>", stars[(int)(track->rating * 5.0 + 0.5)]);
		if (flags & TRACK_LISTVIEW_ARTIST) {
			name = g_strdup_printf("%s - %s", track->artist_name, track->name);
		} else {
			name = g_strdup_printf("%s", track->name);
		}
		gtk_list_store_append(store, &iter);
		gtk_list_store_set(store, &iter,
				COLUMN_NAME, name,
				COLUMN_DURATION, duration,
				COLUMN_RATING, rating,
				COLUMN_TRACK_PTR, track,
				-1);
		g_free(name);
		g_free(duration);
		g_free(rating);
	}

	return GTK_TREE_MODEL( store );
}

static void track_listview_add_columns(GtkTreeView *treeview) {
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Name", renderer, "text", COLUMN_NAME, NULL);
	gtk_tree_view_column_set_expand(column,TRUE);
	gtk_tree_view_column_set_sizing(column,GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_append_column(treeview, column);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Duration", renderer, "text", COLUMN_DURATION, NULL);
	// TODO: width should be calculated runtime
	gtk_tree_view_column_set_fixed_width(column,70);
	gtk_tree_view_append_column(treeview, column);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Rating", renderer, "markup", COLUMN_RATING, NULL);
	// TODO: width should be calculated runtime
	gtk_tree_view_column_set_fixed_width(column,60);
	gtk_tree_view_append_column(treeview, column);
}

GtkWidget* track_listview_create(GList* track_list, gint flags) {
	GtkWidget* treeview;
	GtkTreeModel* model;

	if(track_list) {
		model = track_listview_create_model(track_list, flags);
		treeview = gtk_tree_view_new_with_model(model);
		g_object_unref(model);
	}
	else {
		treeview = gtk_tree_view_new();
	}

	gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview)), GTK_SELECTION_NONE);
	track_listview_add_columns(GTK_TREE_VIEW(treeview));

	g_signal_connect(treeview, "hildon-row-tapped", G_CALLBACK(track_row_tapped), NULL);

	return treeview;
}
