/*
 * search_screen.c
 *
 *  Created on: 2009-10-13
 *      Author: marcin
 */

#include <hildon/hildon.h>
#include "search_screen.h"
#include "jamendo_api.h"
#include "album_listview.h"

/** TODO: Get rid of global variables */
GtkWidget* album_listview = NULL;
int search_mode = 1;
GtkWidget* search_toolbar = NULL;

typedef GList* (*SearchFunction)(const gchar*);

struct {
	const gchar* name;
	SearchFunction function;
} search_mode_data[] = {
		{ "Artist", jamendo_search_for_albums_by_artist },
		{ "Tag", jamendo_search_for_albums_by_tag },
//		{ "User Playlist", jamendo_search_for_user_playlist },
		{ "User Starred Albums", jamendo_search_for_user_starred_albums } };

static void search_mode_menu_clicked(GtkButton *button, int idx) {
	search_mode = idx;
	g_object_set(G_OBJECT(search_toolbar), "label", search_mode_data[search_mode].name, NULL);
}

static HildonAppMenu* search_mode_menu_create() {
	HildonAppMenu *menu = HILDON_APP_MENU (hildon_app_menu_new ());
	int i;
	GtkWidget* button = NULL;
	for (i = 0; i < G_N_ELEMENTS(search_mode_data); i++) {
		button = hildon_gtk_radio_button_new_from_widget(HILDON_SIZE_AUTO, GTK_RADIO_BUTTON(button));
		gtk_button_set_label(GTK_BUTTON(button), search_mode_data[i].name);
		g_signal_connect_after(button, "clicked", G_CALLBACK(search_mode_menu_clicked), (gpointer)i);
		if (search_mode == i) {
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
		}

		hildon_app_menu_append(menu, GTK_BUTTON(button));
	}
	gtk_widget_show_all(GTK_WIDGET (menu));
	return menu;
}

typedef struct {
	SearchFunction func;
	gchar* query;
	GtkWidget* win;
} SearchData;

gboolean do_searching(SearchData* data) {
	GList* album_list = NULL;
	if (data->func) {
		album_list = data->func(data->query);
		album_listview_update_model(album_listview, album_list);

		if (!album_list) {
			hildon_banner_show_information(data->win, NULL, "Not found");
		}

		album_list_free(album_list);
	} else {
		hildon_banner_show_information(data->win, NULL, "Not implemented");
	}

	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->win), 0);
	g_free(data->query);
	g_free(data);
	return FALSE;
}

static void search_clicked(HildonFindToolbar* toolbar, GtkWidget* win) {
	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(win), 1);
	hildon_banner_show_information(win, NULL, "Searching");

	SearchData* data = g_new0(SearchData,1);
	data->func = search_mode_data[search_mode].function;
	g_object_get(G_OBJECT(toolbar), "prefix", &data->query, NULL);
	data->win = win;

	g_idle_add((GSourceFunc) do_searching, data);
}

static void close_clicked(HildonFindToolbar* toolbar, GtkWidget* win) {
	g_object_set(G_OBJECT(toolbar), "prefix", "", NULL);
}

GtkWidget* search_screen_new() {
	GtkWidget* window;
	GtkWidget *pannable_area;
	HildonAppMenu* menu;

	window = hildon_stackable_window_new();
	gtk_window_set_title(GTK_WINDOW(window), "Search");

	pannable_area = hildon_pannable_area_new();
	album_listview = album_listview_create(NULL);
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(pannable_area), album_listview);
	gtk_container_add(GTK_CONTAINER(window), pannable_area);

	/* Create search toolbar */
	search_toolbar = hildon_find_toolbar_new(NULL);
	g_signal_connect(G_OBJECT(search_toolbar), "search", G_CALLBACK(search_clicked), window);
	g_signal_connect(G_OBJECT(search_toolbar), "close", G_CALLBACK(close_clicked), window);
	hildon_window_add_toolbar(HILDON_WINDOW(window), GTK_TOOLBAR(search_toolbar));

	/* Create menu */
	menu = search_mode_menu_create();
	hildon_window_set_app_menu(HILDON_WINDOW (window), menu);

	return window;
}
