/*
 * playlistselector_screen.c
 *
 *  Created on: 2010-01-26
 *      Author: jaroslaw.jaryszew@teleca.com
 */

#include <hildon/hildon.h>
#include "playlistselector_screen.h"
#include "data_structs.h"
#include "jamendo_api.h"
#include "http_utils.h"
#include "resource_utils.h"
#include "playlist_screen.h"

GList* user_playlists_local;
GList* user_playlists_server;
static GtkWidget* main_win;

typedef struct _special_items{
	gpointer plstsel_local_list;
	gpointer plstsel_add_item;
} special_items;

static special_items spec_items;
void playlistselector_listview_update_model(GtkWidget* listview, GList* playlists_list);

enum{
	COLUMN_PLST_TITLE, PLST_PTR, NUM_COLUMNS
};


static void playlist_selected(GtkTreeView* treeview, GtkTreePath* path, gpointer data) {
	//GtkWidget *win;
	GtkTreeModel *model;
	GtkTreeIter iter;

	model = gtk_tree_view_get_model(treeview);
	if (!gtk_tree_model_get_iter(model, &iter, path)) return;

	if (iter.user_data == spec_items.plstsel_local_list) return;

	if (iter.user_data == spec_items.plstsel_add_item){

		   GtkWidget *dialog, *entry, *content_area;
		   /* Create the widgets */
		   dialog = gtk_dialog_new_with_buttons ("Message",
		                                         main_win,
		                                         GTK_DIALOG_DESTROY_WITH_PARENT,
		                                         GTK_STOCK_OK,
		                                         GTK_RESPONSE_NONE,
		                                         NULL);
		   content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
		   entry = gtk_entry_new ();
		   /* Ensure that the dialog box is destroyed when the user responds. */
		   g_signal_connect_swapped (dialog,
		                             "response",
		                             G_CALLBACK (gtk_widget_destroy),
		                             dialog);
		   /* Add the label, and show everything we've added to the dialog. */
		   gtk_container_add (GTK_CONTAINER (content_area), entry);
		   gtk_widget_show_all (dialog);





		user_playlists_local = g_list_append(user_playlists_local, "Nowa Lista");
		playlistselector_listview_update_model((GtkWidget*)treeview, NULL);
	}

//	if (radio) {
//		GList* track_list = jamendo_get_radio_playlist(radio);
//		win = playlist_screen_new(track_list,radio->name);
//		gtk_widget_show_all(win);
//	}

}

void playlistselector_listview_update_model(GtkWidget* listview, GList* playlists_list) {
	GtkListStore *store;
	GtkTreeIter iter;
	//GList* radio_iter;

	//if(!playlists_list) return;

	store = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(listview)));

	gtk_list_store_clear(store);

	gchar* local_playlists = g_markup_printf_escaped("<span size='medium'><u>Localy stored playlists:</u></span>");
	gtk_list_store_append(store, &iter);
	gtk_list_store_set(store, &iter,
			COLUMN_PLST_TITLE, local_playlists,
			-1);
	g_free(local_playlists);
	spec_items.plstsel_local_list = iter.user_data;

	GList* iter_list = user_playlists_local;

	for (iter_list = g_list_first(iter_list);
	iter_list; iter_list = iter_list->next){
		gchar* playlist_title = g_markup_printf_escaped("<span size='small'>%s</span>", (gchar*)user_playlists_local->data);
		gtk_list_store_append(store, &iter);
		gtk_list_store_set(store, &iter,
				COLUMN_PLST_TITLE, playlist_title,
				-1);
		g_free(local_playlists);
	}

	gchar* add_playlist = g_markup_printf_escaped("<span size='large' color='yellow'><b>+</b></span><span size='large'>Add playlist</span>");
	gtk_list_store_append(store, &iter);
	gtk_list_store_set(store, &iter,
			COLUMN_PLST_TITLE, add_playlist,
			-1);
	g_free(add_playlist);
	spec_items.plstsel_add_item = iter.user_data;





	/** images downloaded in background */
//	LoadImagesData* data = g_new0(LoadImagesData,1);
//	data->model = GTK_TREE_MODEL(store);
//	data->thread = g_thread_create((GThreadFunc)load_images, data, TRUE, NULL);
//
//	/* when listview is destroyed, destroy also radio_list */
//	g_signal_connect(G_OBJECT(listview), "destroy", G_CALLBACK(radio_listview_destroyed), data);
}

static void playlistselector_listview_add_columns(GtkTreeView *treeview) {
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

//	renderer = gtk_cell_renderer_pixbuf_new();
//	g_object_set(G_OBJECT (renderer), "follow-state", FALSE, NULL);
//
//	column = gtk_tree_view_column_new_with_attributes("Image", renderer, "pixbuf", COLUMN_PLST_TITLE, NULL);
//	gtk_tree_view_append_column(treeview, column);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Radio", renderer, "markup", COLUMN_PLST_TITLE, NULL);
 	gtk_tree_view_append_column(treeview, column);

}


GtkWidget* playlistselector_listview_create(GList* playlistselector_list) {
	GtkWidget *listview;
	GtkTreeModel *model;

	model = GTK_TREE_MODEL( gtk_list_store_new(NUM_COLUMNS, G_TYPE_STRING, G_TYPE_RADIO) );
	listview = gtk_tree_view_new_with_model(model);
	playlistselector_listview_update_model(listview ,playlistselector_list);
	g_object_unref(model);

	gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(listview)), GTK_SELECTION_NONE);
	playlistselector_listview_add_columns(GTK_TREE_VIEW(listview));

	g_signal_connect(listview, "hildon-row-tapped", G_CALLBACK(playlist_selected),NULL);

	return listview;
}


GtkWidget* playlistselector_screen_new() {
	GtkWidget* win;
	GtkWidget *treeview;
	GtkWidget* playlistselector_box;
	user_playlists_local = NULL;

	/* Create the main window */
	win = hildon_stackable_window_new();
	gtk_window_set_title(GTK_WINDOW(win), "Playlists");

	//player_set_radio_list(radio_list);
	treeview = playlistselector_listview_create(NULL);

	playlistselector_box = hildon_pannable_area_new();
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(playlistselector_box), treeview);

	GtkWidget* main_box = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(main_box), playlistselector_box, TRUE,TRUE,0);
	gtk_container_add(GTK_CONTAINER(win), main_box);

	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(win),1);
	hildon_banner_show_information(win,NULL,"Loading");

	playlistselector_listview_update_model(treeview, user_playlists_local);

	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(win),0);
	gtk_widget_show_all(win);

	main_win = win;
	return win;
}
