/*
 * main.c
 *
 *  Created on: 2009-10-01
 *      Author: marcin
 */

#include <hildon/hildon.h>
#include <gst/gst.h>

#include "home_screen.h"
#include "data_structs.h"
#include "player.h"

int main(int argc, char **argv) {
	HildonProgram *program;
	GtkWidget *win;

	if (!g_thread_supported()) {
		g_thread_init(NULL);
	}
	gdk_threads_init();
	gdk_threads_enter();

	hildon_gtk_init(&argc, &argv);
	gst_init(&argc,&argv);

	program = hildon_program_get_instance();
	g_set_application_name("Jamendo");

	/* register boxed types */
	data_structs_type_register();

	win = home_screen_new();

	hildon_program_set_common_toolbar(program, GTK_TOOLBAR(player_toolbar_create()));

	g_signal_connect(win, "destroy", G_CALLBACK(gtk_main_quit), NULL);

	/* This call show the window and also add the window to the stack */
	gtk_widget_show(win);
	gtk_main();

	gdk_threads_leave();

	return 0;
}

