/*
 * data_structs.c
 *
 *  Created on: 2009-10-05
 *      Author: marcin
 */

#include <glib.h>
#include <glib-object.h>

#include "data_structs.h"

int G_TYPE_ALBUM = 0;
int G_TYPE_RADIO = 0;

void data_structs_type_register() {
	if(!G_TYPE_ALBUM) {
		G_TYPE_ALBUM = g_boxed_type_register_static("Album", (GBoxedCopyFunc)album_copy, (GBoxedFreeFunc)album_free);
	}
	if(!G_TYPE_RADIO) {
		G_TYPE_RADIO = g_boxed_type_register_static("Radio", (GBoxedCopyFunc)radio_copy, (GBoxedFreeFunc)radio_free);
	}
}

Album* album_new() {
	return g_new0(Album, 1);
}

Album* album_copy(Album* album) {
	Album* newAlbum =  g_new0(Album, 1);
	album_set_id(newAlbum,album->id);
	album_set_image(newAlbum,album->image);
	album_set_name(newAlbum,album->name);
	album_set_rating(newAlbum,album->rating);
	album_set_artist_name(newAlbum,album->artist_name);
	return newAlbum;
}

void album_set_id(Album* album, const gint id) {
	album->id = id;
}

void album_set_image(Album* album, const gchar* image) {
	album->image = g_strdup(image);
}

gchar* album_get_image(Album* album, gint size) {
	return g_strdup_printf("http://api.jamendo.com/get2/image/album/redirect/?id=%d&imagesize=%d",album->id,size);
}

void album_set_name(Album* album, const gchar* name) {
	album->name = g_strdup(name);
}

void album_set_rating(Album* album, const gdouble rating) {
	album->rating = rating;
}

void album_set_artist_name(Album* album, const gchar* artist_name) {
	album->artist_name = g_strdup(artist_name);
}


void album_free(Album* album) {
	g_free(album->image);
	g_free(album->name);
	g_free(album->artist_name);
	g_free(album);
}

void album_dump(Album* album) {
	g_debug("id: %d", album->id);
	g_debug("image: %s", album->image);
	g_debug("name: %s", album->name);
	g_debug("rating: %g", album->rating);
	g_debug("artist name: %s", album->artist_name);
}

Album* album_new_from_xml(xmlNode* album_node) {
	Album* album = NULL;
	if (album_node->type == XML_ELEMENT_NODE && g_strcmp0((gchar*) album_node->name, "album") == 0) {
		xmlNode* cur_node;
		album = album_new();
		for (cur_node = album_node->children; cur_node; cur_node = cur_node->next) {
			if (!(cur_node->type == XML_ELEMENT_NODE && cur_node->children))
				continue;
			if (g_strcmp0((gchar*) cur_node->name, "id") == 0) {
				album_set_id(album, g_ascii_strtoll((gchar*) cur_node->children->content, NULL, 10));
			} else if (g_strcmp0((gchar*) cur_node->name, "name") == 0) {
				album_set_name(album, (gchar*) cur_node->children->content);
				/*album_set_name(album, (gchar*)xmlNodeGetContent(cur_node));*/
			} else if (g_strcmp0((gchar*) cur_node->name, "image") == 0) {
				album_set_image(album, (gchar*) cur_node->children->content);
			} else if (g_strcmp0((gchar*) cur_node->name, "rating") == 0) {
				album_set_rating(album, g_ascii_strtod((gchar*) cur_node->children->content, NULL));
			} else if (g_strcmp0((gchar*) cur_node->name, "artist_name") == 0) {
				album_set_artist_name(album, (gchar*) cur_node->children->content);
			}
		}
	}

	if(album) {
		g_free(album->image);
		album->image=g_strdup_printf("http://api.jamendo.com/get2/image/album/redirect/?id=%d&imagesize=100",album->id);
	}
	return album;
}

static void album_list_free_item(Album* album, gpointer data) {
	album_free(album);
}

void album_list_free(GList* album_list) {
	if (album_list) {
		g_debug("album_list_free length: %d", g_list_length(album_list));
		g_list_foreach(album_list, (GFunc) album_list_free_item, NULL);
		g_list_free(album_list);
	}
}

/***
 * TRACK
 */

Track* track_new() {
	return g_new0(Track, 1);
}

Track* track_new_from_xml(xmlNode* track_node) {
	Track* track = NULL;

	if (track_node->type == XML_ELEMENT_NODE && g_strcmp0((gchar*) track_node->name, "track") == 0) {
		xmlNode* cur_node;
		track = track_new();
		for (cur_node = track_node->children; cur_node; cur_node = cur_node->next) {
			if (!(cur_node->type == XML_ELEMENT_NODE && cur_node->children))
				continue;
			if (g_strcmp0((gchar*) cur_node->name, "id") == 0) {
				track_set_id(track, g_ascii_strtoll((gchar*) cur_node->children->content, NULL, 10));
			} else if (g_strcmp0((gchar*) cur_node->name, "name") == 0) {
				track_set_name(track, (gchar*) cur_node->children->content);
				/*track_set_name(track, (gchar*)xmlNodeGetContent(cur_node));*/
			} else if (g_strcmp0((gchar*) cur_node->name, "duration") == 0) {
				track_set_duration(track, g_ascii_strtoll((gchar*) cur_node->children->content, NULL, 10));
			} else if (g_strcmp0((gchar*) cur_node->name, "stream") == 0) {
				track_set_stream(track, (gchar*) cur_node->children->content);
			} else if (g_strcmp0((gchar*) cur_node->name, "rating") == 0) {
				track_set_rating(track, g_ascii_strtod((gchar*) cur_node->children->content, NULL));
			} else if (g_strcmp0((gchar*) cur_node->name, "artist_id") == 0) {
				track_set_artist_id(track, g_ascii_strtoll((gchar*) cur_node->children->content, NULL, 10));
			} else if (g_strcmp0((gchar*) cur_node->name, "artist_name") == 0) {
				track_set_artist_name(track, (gchar*) cur_node->children->content);
			} else if (g_strcmp0((gchar*) cur_node->name, "album_id") == 0) {
				track_set_album_id(track, g_ascii_strtoll((gchar*) cur_node->children->content, NULL, 10));
			} else if (g_strcmp0((gchar*) cur_node->name, "album_name") == 0) {
				track_set_album_name(track, (gchar*) cur_node->children->content);
			}
		}
	}

	return track;
}

void track_free(Track* track) {
	g_free(track->name);
	g_free(track->stream);
	g_free(track->album_name);
	g_free(track->artist_name);
	g_free(track);
}


void track_set_id(Track* track, const gint id) {
	track->id = id;
}

void track_set_name(Track* track, const gchar* name) {
	track->name = g_strdup(name);
}

void track_set_duration(Track* track, const gint duration) {
	track->duration = duration;
}

void track_set_stream(Track* track, const gchar* stream) {
	track->stream = g_strdup(stream);
}

void track_set_rating(Track* track, const gdouble rating) {
	track->rating = rating;
}

void track_set_artist_id(Track* track, const gint artist_id) {
	track->artist_id = artist_id;
}

void track_set_artist_name(Track* track, const gchar* artist_name) {
	track->artist_name = g_strdup(artist_name);
}

void track_set_album_id(Track* track, const gint album_id) {
	track->album_id = album_id;
}

void track_set_album_name(Track* track, const gchar* album_name) {
	track->album_name = g_strdup(album_name);
}

static void track_list_free_item(Track* track, gpointer data) {
	track_free(track);
}

void track_list_free(GList* track_list)
{
	if (track_list) {
		g_debug("track_list_free length: %d", g_list_length(track_list));
		g_list_foreach(track_list, (GFunc) track_list_free_item, NULL);
		g_list_free(track_list);
	}
}

/***
 * RADIO
 */

Radio* radio_new() {
	return g_new0(Radio, 1);
}

Radio* radio_copy(Radio* radio) {
	Radio* newRadio =  g_new0(Radio, 1);
	radio_set_id(newRadio,radio->id);
	radio_set_image(newRadio,radio->image);
	radio_set_name(newRadio,radio->name);
	return newRadio;
}

Radio* radio_new_from_xml(xmlNode* radio_node) {
	Radio* radio = NULL;
	if (radio_node->type == XML_ELEMENT_NODE && g_strcmp0((gchar*) radio_node->name, "radio") == 0) {
		xmlNode* cur_node;
		radio = radio_new();
		for (cur_node = radio_node->children; cur_node; cur_node = cur_node->next) {
			if (!(cur_node->type == XML_ELEMENT_NODE && cur_node->children))
				continue;
			if (g_strcmp0((gchar*) cur_node->name, "id") == 0) {
				radio_set_id(radio, g_ascii_strtoll((gchar*) cur_node->children->content, NULL, 10));
			} else if (g_strcmp0((gchar*) cur_node->name, "idstr") == 0) {
				radio_set_name(radio, (gchar*) cur_node->children->content);
				/*radio_set_name(radio, (gchar*)xmlNodeGetContent(cur_node));*/
			} else if (g_strcmp0((gchar*) cur_node->name, "image") == 0) {
				radio_set_image(radio, (gchar*) cur_node->children->content);
			}
		}
	}

	return radio;
}

void radio_free(Radio* radio) {
	g_free(radio->image);
	g_free(radio->name);
	g_free(radio);
}

void radio_set_id(Radio* radio, const gint id) {
	radio->id = id;
}

void radio_set_name(Radio* radio, const gchar* name) {
	radio->name = g_strdup(name);
}

void radio_set_image(Radio* radio, const gchar* image) {
	radio->image = g_strdup(image);
}

static void radio_list_free_item(Radio* radio, gpointer data) {
	radio_free(radio);
}
void radio_list_free(GList* radio_list) {
	if (radio_list) {
		g_debug("radio_list_free length: %d", g_list_length(radio_list));
		g_list_foreach(radio_list, (GFunc) radio_list_free_item, NULL);
		g_list_free(radio_list);
	}
}
