/*
 * album_screen.c
 *
 *  Created on: 2009-10-12
 *      Author: marcin
 */
#include <hildon/hildon.h>
#include "album_screen.h"
#include "jamendo_api.h"
#include "track_listview.h"
#include "player.h"
#include "http_utils.h"

GtkWidget* album_screen_new(Album* album) {
	GtkWidget* win;
	GtkWidget *cover_box;
	GtkWidget *label;
	GtkWidget *treeview;
	GtkWidget* track_box;
	GtkWidget* image;
	GList* track_list;

	/* Create the main window */
	win = hildon_stackable_window_new();
	gtk_window_set_title(GTK_WINDOW(win), album->name);
	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(win),1);
	gtk_widget_show(win);
	while(gtk_events_pending()) gtk_main_iteration();

	/* Setting a label in the new window */
	label = gtk_label_new("");
	gchar* markup = g_markup_printf_escaped("<span size='x-large'>%s</span>\n<span size='large'>%s</span>",album->name,album->artist_name);
	gtk_label_set_markup(GTK_LABEL(label),markup);
	g_free(markup);

	gchar* image_name = album_get_image(album,200);
	GdkPixbuf* pixbuf = http_get_image(image_name,200,-1);
	g_free(image_name);
	image = gtk_image_new_from_pixbuf(pixbuf);
	g_object_unref(pixbuf);

	cover_box = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(cover_box), image, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(cover_box), label, TRUE, TRUE, 0);

	track_list = jamendo_get_album_tracks(album);
	player_set_track_list(track_list);
	treeview = track_listview_create(track_list, TRACK_LISTVIEW_NAME);
	// track list not freed automatically as player uses it
	//g_signal_connect_swapped(G_OBJECT(treeview), "destroy", G_CALLBACK(track_list_free), track_list);

	track_box = hildon_pannable_area_new();
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(track_box), treeview);

	GtkWidget* main_box = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(main_box), cover_box, TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(main_box), track_box, TRUE,TRUE,0);
	gtk_container_add(GTK_CONTAINER(win), main_box);


	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(win),0);

	hildon_program_add_window(hildon_program_get_instance(),HILDON_WINDOW(win));

	gtk_widget_show(player_toolbar_create());

	return win;
}
