/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.Icon;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.inspector.IconManager;

public class XMBean {
    private ObjectName objectName;
    private Icon icon;
    private String text;
    private boolean broadcaster;
    private MBeanInfo mbeanInfo;
    private MBeansTab mbeansTab;

    public XMBean(ObjectName objectName, MBeansTab mbeansTab) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        this.mbeansTab = mbeansTab;
        this.setObjectName(objectName);
        this.icon = MBeanServerDelegate.DELEGATE_NAME.equals(objectName) ? IconManager.MBEANSERVERDELEGATE : IconManager.MBEAN;
        this.broadcaster = this.isBroadcaster(objectName);
        this.mbeanInfo = this.getMBeanInfo(objectName);
    }

    MBeanServerConnection getMBeanServerConnection() {
        return this.mbeansTab.getMBeanServerConnection();
    }

    public boolean isBroadcaster() {
        return this.broadcaster;
    }

    private boolean isBroadcaster(ObjectName name) {
        try {
            return this.getMBeanServerConnection().isInstanceOf(name, "javax.management.NotificationBroadcaster");
        }
        catch (Exception e) {
            System.out.println("Error calling isBroadcaster: " + e.getMessage());
            return false;
        }
    }

    public Object invoke(String operationName) throws Exception {
        Object result = this.getMBeanServerConnection().invoke(this.getObjectName(), operationName, new Object[0], new String[0]);
        return result;
    }

    public Object invoke(String operationName, Object[] params, String[] sig) throws Exception {
        Object result = this.getMBeanServerConnection().invoke(this.getObjectName(), operationName, params, sig);
        return result;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.getMBeanServerConnection().setAttribute(this.getObjectName(), attribute);
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getAttribute(this.getObjectName(), attributeName);
    }

    public AttributeList getAttributes(String[] attributeNames) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getAttributes(this.getObjectName(), attributeNames);
    }

    public AttributeList getAttributes(MBeanAttributeInfo[] attributeNames) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String[] attributeString = new String[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeString[i] = attributeNames[i].getName();
        }
        return this.getAttributes(attributeString);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    private void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
        String name = this.getObjectName().getKeyProperty("name");
        if (name == null) {
            this.setText(this.getObjectName().getDomain());
        } else {
            this.setText(name);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    private MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getMBeanInfo(name);
    }

    public boolean equals(Object o) {
        if (o instanceof XMBean) {
            XMBean mbean = (XMBean)o;
            return this.getObjectName().equals(mbean.getObjectName());
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String toString() {
        return this.getText();
    }
}

