/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XOperations;
import sun.tools.jconsole.inspector.XTextField;

public class OperationEntry
extends JPanel {
    private MBeanOperationInfo operation;
    private JComboBox sigs;
    private Dimension preferredSize;
    private XTextField[] inputs;

    public OperationEntry(MBeanOperationInfo operation, boolean isCallable, JButton button, XOperations xoperations) {
        super(new BorderLayout());
        this.operation = operation;
        this.setLayout(new FlowLayout(0));
        this.setPanel(isCallable, button, xoperations);
    }

    private String preProcessSignature(String signature) {
        int index = signature.indexOf(" throws");
        if (index > 0) {
            signature = signature.substring(0, index);
        }
        while ((index = signature.indexOf("java.lang.")) > 0) {
            signature = signature.substring(0, index) + signature.substring(index + 10, signature.length());
        }
        return signature;
    }

    private void setPanel(boolean isCallable, JButton button, XOperations xoperations) {
        try {
            MBeanParameterInfo[] params = this.operation.getSignature();
            this.add(new JLabel("(", 0));
            this.inputs = new XTextField[params.length];
            for (int i = 0; i < params.length; ++i) {
                String defaultTextValue;
                int fieldWidth;
                if (params[i].getName() != null) {
                    JLabel name = new JLabel(params[i].getName(), 0);
                    name.setToolTipText(params[i].getDescription());
                    this.add(name);
                }
                if ((fieldWidth = (defaultTextValue = Utils.getDefaultValue(params[i].getType())).length()) > 15) {
                    fieldWidth = 15;
                } else if (fieldWidth < 10) {
                    fieldWidth = 10;
                }
                this.inputs[i] = new XTextField(Utils.getReadableClassName(defaultTextValue), Utils.getClass(params[i].getType()), fieldWidth, isCallable, button, xoperations);
                this.add(this.inputs[i]);
                this.inputs[i].setHorizontalAlignment(0);
                if (i >= params.length - 1) continue;
                this.add(new JLabel(",", 0));
            }
            this.add(new JLabel(")", 0));
            this.validate();
            this.doLayout();
        }
        catch (Exception e) {
            System.out.println("Error setting Operation panel :" + e.getMessage());
        }
    }

    public String[] getSignature() {
        MBeanParameterInfo[] params = this.operation.getSignature();
        String[] result = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = params[i].getType();
        }
        return result;
    }

    public Object[] getParameters() throws Exception {
        MBeanParameterInfo[] params = this.operation.getSignature();
        String[] signature = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            signature[i] = params[i].getType();
        }
        return Utils.getParameters(this.inputs, signature);
    }

    public String getReturnType() {
        return this.operation.getReturnType();
    }
}

