/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class VariableGridLayout
extends GridLayout {
    private boolean fillRows;
    private boolean fillColumns;

    public VariableGridLayout(int rows, int cols, int hgap, int vgap, boolean fillRows, boolean fillColumns) {
        super(rows, cols, hgap, vgap);
        this.fillRows = fillRows;
        this.fillColumns = fillColumns;
    }

    public void setFillRow(JComponent c, boolean b) {
        c.putClientProperty("VariableGridLayout.fillRow", b);
    }

    public void setFillColumn(JComponent c, boolean b) {
        c.putClientProperty("VariableGridLayout.fillColumn", b);
    }

    public boolean getFillRow(JComponent c) {
        Boolean b = (Boolean)c.getClientProperty("VariableGridLayout.fillRow");
        return b != null ? b : this.fillRows;
    }

    public boolean getFillColumn(JComponent c) {
        Boolean b = (Boolean)c.getClientProperty("VariableGridLayout.fillColumn");
        return b != null ? b : this.fillColumns;
    }

    public void layoutContainer(Container parent) {
        int x;
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int nrows = this.getRows();
        int ncols = this.getColumns();
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        int nFills = 0;
        boolean[] fills = new boolean[nrows];
        int lastFillRow = -1;
        int nComps = parent.getComponentCount();
        int y = insets.top;
        for (int row = 0; row < nrows; ++row) {
            Component c;
            int col;
            int h = 0;
            for (col = 0; col < ncols; ++col) {
                if (row * ncols + col >= nComps) continue;
                c = parent.getComponent(row * ncols + col);
                h = Math.max(h, c.getMinimumSize().height);
            }
            x = insets.left;
            for (col = 0; col < ncols; ++col) {
                if (row * ncols + col >= nComps) continue;
                c = (JComponent)parent.getComponent(row * ncols + col);
                int w = ((JComponent)c).getWidth();
                c.setBounds(x, y, w, h);
                x += w + hgap;
                if (col != 0 || !this.getFillRow((JComponent)c)) continue;
                fills[row] = true;
            }
            y += h + vgap;
            if (!fills[row]) continue;
            ++nFills;
            lastFillRow = row;
        }
        if (nFills > 0 && y < parent.getHeight()) {
            int hAdd = (parent.getHeight() - y) / nFills;
            int hAdded = 0;
            for (int row = 0; row < nrows; ++row) {
                if (!fills[row]) continue;
                if (row == lastFillRow) {
                    hAdd = parent.getHeight() - (y + hAdded);
                }
                for (int col = 0; col < ncols; ++col) {
                    if (row * ncols + col >= nComps) continue;
                    Component c = parent.getComponent(row * ncols + col);
                    Rectangle b = c.getBounds();
                    c.setBounds(b.x, b.y + hAdded, b.width, b.height + hAdd);
                }
                hAdded += hAdd;
            }
        }
        nFills = 0;
        fills = new boolean[ncols];
        int lastFillCol = -1;
        x = insets.left;
        for (int col = 0; col < ncols; ++col) {
            Component c;
            int row;
            int w = 0;
            for (row = 0; row < nrows; ++row) {
                if (row * ncols + col >= nComps) continue;
                c = parent.getComponent(row * ncols + col);
                w = Math.max(w, c.getMinimumSize().width);
            }
            y = insets.top;
            for (row = 0; row < nrows; ++row) {
                if (row * ncols + col >= nComps) continue;
                c = (JComponent)parent.getComponent(row * ncols + col);
                int h = ((JComponent)c).getHeight();
                c.setBounds(x, y, w, h);
                y += h + vgap;
                if (row != 0 || !this.getFillColumn((JComponent)c)) continue;
                fills[col] = true;
            }
            x += w + hgap;
            if (!fills[col]) continue;
            ++nFills;
            lastFillCol = col;
        }
        if (nFills > 0 && x < parent.getWidth()) {
            int wAdd = (parent.getWidth() - x) / nFills;
            int wAdded = 0;
            for (int col = 0; col < ncols; ++col) {
                if (!fills[col]) continue;
                if (col == lastFillCol) {
                    wAdd = parent.getWidth() - (x + wAdded);
                }
                for (int row = 0; row < nrows; ++row) {
                    if (row * ncols + col >= nComps) continue;
                    Component c = parent.getComponent(row * ncols + col);
                    Rectangle b = c.getBounds();
                    c.setBounds(b.x + wAdded, b.y, b.width + wAdd, b.height);
                }
                wAdded += wAdd;
            }
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int nrows = this.getRows();
        int ncols = this.getColumns();
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        int nComps = parent.getComponentCount();
        int y = insets.top;
        for (int row = 0; row < nrows; ++row) {
            int h = 0;
            for (int col = 0; col < ncols; ++col) {
                if (row * ncols + col >= nComps) continue;
                Component c = parent.getComponent(row * ncols + col);
                h = Math.max(h, c.getMinimumSize().height);
            }
            y += h + vgap;
        }
        int x = insets.left;
        for (int col = 0; col < ncols; ++col) {
            int w = 0;
            for (int row = 0; row < nrows; ++row) {
                if (row * ncols + col >= nComps) continue;
                Component c = parent.getComponent(row * ncols + col);
                w = Math.max(w, c.getMinimumSize().width);
            }
            x += w + hgap;
        }
        return new Dimension(x, y);
    }
}

