/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.net.ssl.SSLException;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.JsseJce;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CipherSuiteList {
    private static CipherSuiteList supportedSuites;
    private static CipherSuiteList defaultSuites;
    private final Collection<CipherSuite> cipherSuites;
    private String[] suiteNames;
    private volatile Boolean containsEC;

    private CipherSuiteList(Collection<CipherSuite> cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    CipherSuiteList(CipherSuite suite) {
        this.cipherSuites = new ArrayList<CipherSuite>(1);
        this.cipherSuites.add(suite);
    }

    CipherSuiteList(String[] names) {
        if (names == null) {
            throw new IllegalArgumentException("CipherSuites may not be null");
        }
        this.cipherSuites = new ArrayList<CipherSuite>(names.length);
        boolean refreshed = false;
        for (int i = 0; i < names.length; ++i) {
            String suiteName = names[i];
            CipherSuite suite = CipherSuite.valueOf(suiteName);
            if (!suite.isAvailable()) {
                if (!refreshed) {
                    CipherSuiteList.clearAvailableCache();
                    refreshed = true;
                }
                if (!suite.isAvailable()) {
                    throw new IllegalArgumentException("Cannot support " + suiteName + " with currently installed providers");
                }
            }
            this.cipherSuites.add(suite);
        }
    }

    CipherSuiteList(HandshakeInStream in) throws IOException {
        byte[] bytes = in.getBytes16();
        if ((bytes.length & 1) != 0) {
            throw new SSLException("Invalid ClientHello message");
        }
        this.cipherSuites = new ArrayList<CipherSuite>(bytes.length >> 1);
        for (int i = 0; i < bytes.length; i += 2) {
            this.cipherSuites.add(CipherSuite.valueOf(bytes[i], bytes[i + 1]));
        }
    }

    boolean contains(CipherSuite suite) {
        return this.cipherSuites.contains(suite);
    }

    boolean containsEC() {
        if (this.containsEC == null) {
            for (CipherSuite c : this.cipherSuites) {
                switch (c.keyExchange) {
                    case K_ECDH_ECDSA: 
                    case K_ECDH_RSA: 
                    case K_ECDHE_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDH_ANON: {
                        this.containsEC = true;
                        return true;
                    }
                }
            }
            this.containsEC = false;
        }
        return this.containsEC;
    }

    Iterator<CipherSuite> iterator() {
        return this.cipherSuites.iterator();
    }

    Collection<CipherSuite> collection() {
        return this.cipherSuites;
    }

    int size() {
        return this.cipherSuites.size();
    }

    synchronized String[] toStringArray() {
        if (this.suiteNames == null) {
            this.suiteNames = new String[this.cipherSuites.size()];
            int i = 0;
            for (CipherSuite c : this.cipherSuites) {
                this.suiteNames[i++] = c.name;
            }
        }
        return (String[])this.suiteNames.clone();
    }

    public String toString() {
        return this.cipherSuites.toString();
    }

    void send(HandshakeOutStream s) throws IOException {
        byte[] suiteBytes = new byte[this.cipherSuites.size() * 2];
        int i = 0;
        for (CipherSuite c : this.cipherSuites) {
            suiteBytes[i] = (byte)(c.id >> 8);
            suiteBytes[i + 1] = (byte)c.id;
            i += 2;
        }
        s.putBytes16(suiteBytes);
    }

    static synchronized void clearAvailableCache() {
        supportedSuites = null;
        defaultSuites = null;
        CipherSuite.BulkCipher.clearAvailableCache();
        JsseJce.clearEcAvailable();
    }

    private static CipherSuiteList buildAvailableCache(int minPriority) {
        TreeSet<CipherSuite> cipherSuites = new TreeSet<CipherSuite>();
        Collection<CipherSuite> allowedCipherSuites = CipherSuite.allowedCipherSuites();
        for (CipherSuite c : allowedCipherSuites) {
            if (!c.allowed || c.priority < minPriority || !c.isAvailable()) continue;
            cipherSuites.add(c);
        }
        return new CipherSuiteList(cipherSuites);
    }

    static synchronized CipherSuiteList getSupported() {
        if (supportedSuites == null) {
            supportedSuites = CipherSuiteList.buildAvailableCache(1);
        }
        return supportedSuites;
    }

    static synchronized CipherSuiteList getDefault() {
        if (defaultSuites == null) {
            defaultSuites = CipherSuiteList.buildAvailableCache(300);
        }
        return defaultSuites;
    }
}

