/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import javax.sound.sampled.FloatControl;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioPlaybackLine;

final class PulseAudioVolumeControl
extends FloatControl {
    static final int MAX_VOLUME = 65536;
    static final int MIN_VOLUME = 0;
    private EventLoop eventLoop;
    private PulseAudioPlaybackLine line;

    protected PulseAudioVolumeControl(PulseAudioPlaybackLine line, EventLoop eventLoop) {
        super(FloatControl.Type.VOLUME, 0.0f, 65536.0f, 1.0f, -1, line.getCachedVolume(), "pulseaudio units", "Volume Off", "Default Volume", "Full Volume");
        this.line = line;
        this.eventLoop = eventLoop;
    }

    @Override
    public synchronized void setValue(float newValue) {
        if (newValue > 65536.0f || newValue < 0.0f) {
            throw new IllegalArgumentException("invalid value");
        }
        if (!this.line.isOpen()) {
            return;
        }
        this.setStreamVolume(newValue);
        this.line.setCachedVolume(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setStreamVolume(float newValue) {
        Operation op;
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            op = new Operation(this.line.native_set_volume(newValue));
        }
        op.waitForCompletion();
        op.releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized float getValue() {
        Operation op;
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            op = new Operation(this.line.native_update_volume());
        }
        op.waitForCompletion();
        op.releaseReference();
        return this.line.getCachedVolume();
    }
}

