/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ktab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTabConstants;
import sun.security.krb5.internal.ktab.KeyTabEntry;
import sun.security.krb5.internal.ktab.KeyTabInputStream;
import sun.security.krb5.internal.ktab.KeyTabOutputStream;

public class KeyTab
implements KeyTabConstants {
    int kt_vno;
    private static KeyTab singleton = null;
    private static final boolean DEBUG = Krb5.DEBUG;
    private static String name;
    private Vector<KeyTabEntry> entries = new Vector();

    private KeyTab(String filename) throws IOException, RealmException {
        this.init(filename);
    }

    public static KeyTab getInstance(String s) {
        name = KeyTab.parse(s);
        if (name == null) {
            return KeyTab.getInstance();
        }
        return KeyTab.getInstance(new File(name));
    }

    public static KeyTab getInstance(File file) {
        block7: {
            try {
                if (!file.exists()) {
                    singleton = null;
                } else {
                    String fname = file.getAbsolutePath();
                    if (singleton != null) {
                        File kfile = new File(name);
                        String kname = kfile.getAbsolutePath();
                        if (kname.equalsIgnoreCase(fname) && DEBUG) {
                            System.out.println("KeyTab instance already exists");
                        }
                    } else {
                        singleton = new KeyTab(fname);
                    }
                }
            }
            catch (Exception e) {
                singleton = null;
                if (!DEBUG) break block7;
                System.out.println("Could not obtain an instance of KeyTab" + e.getMessage());
            }
        }
        return singleton;
    }

    public static KeyTab getInstance() {
        block3: {
            try {
                name = KeyTab.getDefaultKeyTab();
                if (name != null) {
                    singleton = KeyTab.getInstance(new File(name));
                }
            }
            catch (Exception e) {
                singleton = null;
                if (!DEBUG) break block3;
                System.out.println("Could not obtain an instance of KeyTab" + e.getMessage());
            }
        }
        return singleton;
    }

    private static String getDefaultKeyTab() {
        if (name != null) {
            return name;
        }
        String kname = null;
        try {
            String keytab_names = Config.getInstance().getDefault("default_keytab_name", "libdefaults");
            if (keytab_names != null) {
                StringTokenizer st = new StringTokenizer(keytab_names, " ");
                while (st.hasMoreTokens() && (kname = KeyTab.parse(st.nextToken())) == null) {
                }
            }
        }
        catch (KrbException e) {
            kname = null;
        }
        if (kname == null) {
            String user_home = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            if (user_home == null) {
                user_home = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
            }
            if (user_home != null) {
                kname = user_home + File.separator + "krb5.keytab";
            }
        }
        return kname;
    }

    private static String parse(String name) {
        String kname = null;
        if (name == null) {
            return null;
        }
        kname = name.length() >= 5 && name.substring(0, 5).equalsIgnoreCase("FILE:") ? name.substring(5) : (name.length() >= 9 && name.substring(0, 9).equalsIgnoreCase("ANY:FILE:") ? name.substring(9) : (name.length() >= 7 && name.substring(0, 7).equalsIgnoreCase("SRVTAB:") ? name.substring(7) : name));
        return kname;
    }

    private synchronized void init(String filename) throws IOException, RealmException {
        if (filename != null) {
            KeyTabInputStream kis = new KeyTabInputStream(new FileInputStream(filename));
            this.load(kis);
            kis.close();
            name = filename;
        }
    }

    private void load(KeyTabInputStream kis) throws IOException, RealmException {
        this.entries.clear();
        this.kt_vno = kis.readVersion();
        if (this.kt_vno == 1281) {
            kis.setNativeByteOrder();
        }
        int entryLength = 0;
        while (kis.available() > 0) {
            entryLength = kis.readEntryLength();
            KeyTabEntry entry = kis.readEntry(entryLength, this.kt_vno);
            if (DEBUG) {
                System.out.println(">>> KeyTab: load() entry length: " + entryLength + "; type: " + (entry != null ? entry.keyType : 0));
            }
            if (entry == null) continue;
            this.entries.addElement(entry);
        }
    }

    public EncryptionKey readServiceKey(PrincipalName service) {
        KeyTabEntry entry = null;
        if (this.entries != null) {
            for (int i = this.entries.size() - 1; i >= 0; --i) {
                entry = this.entries.elementAt(i);
                if (!entry.service.match(service)) continue;
                if (EType.isSupported(entry.keyType)) {
                    return new EncryptionKey(entry.keyblock, entry.keyType, new Integer(entry.keyVersion));
                }
                if (!DEBUG) continue;
                System.out.println("Found unsupported keytype (" + entry.keyType + ") for " + service);
            }
        }
        return null;
    }

    public EncryptionKey[] readServiceKeys(PrincipalName service) {
        int[] etypes;
        int size = this.entries.size();
        ArrayList<EncryptionKey> keys = new ArrayList<EncryptionKey>(size);
        if (this.entries != null) {
            for (int i = size - 1; i >= 0; --i) {
                KeyTabEntry entry = this.entries.elementAt(i);
                if (!entry.service.match(service)) continue;
                if (EType.isSupported(entry.keyType)) {
                    EncryptionKey key = new EncryptionKey(entry.keyblock, entry.keyType, new Integer(entry.keyVersion));
                    keys.add(key);
                    if (!DEBUG) continue;
                    System.out.println("Added key: " + entry.keyType + "version: " + entry.keyVersion);
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("Found unsupported keytype (" + entry.keyType + ") for " + service);
            }
        }
        if ((size = keys.size()) == 0) {
            return null;
        }
        EncryptionKey[] retVal = new EncryptionKey[size];
        int pos = 0;
        if (DEBUG) {
            System.out.println("Ordering keys wrt default_tkt_enctypes list");
        }
        if ((etypes = EType.getDefaults("default_tkt_enctypes")) == null || etypes == EType.getBuiltInDefaults()) {
            for (int i = 0; i < size; ++i) {
                retVal[pos++] = (EncryptionKey)keys.get(i);
            }
        } else {
            EncryptionKey k;
            for (int j = 0; j < etypes.length && pos < size; ++j) {
                int target = etypes[j];
                for (int i = 0; i < size && pos < size; ++i) {
                    k = (EncryptionKey)keys.get(i);
                    if (k == null || k.getEType() != target) continue;
                    if (DEBUG) {
                        System.out.println(pos + ": " + k);
                    }
                    retVal[pos++] = k;
                    keys.set(i, null);
                }
            }
            for (int i = 0; i < size && pos < size; ++i) {
                k = (EncryptionKey)keys.get(i);
                if (k == null) continue;
                retVal[pos++] = k;
            }
        }
        if (pos != size) {
            throw new RuntimeException("Internal Error: did not copy all keys;expecting " + size + "; got " + pos);
        }
        return retVal;
    }

    public boolean findServiceEntry(PrincipalName service) {
        if (this.entries != null) {
            for (int i = 0; i < this.entries.size(); ++i) {
                KeyTabEntry entry = this.entries.elementAt(i);
                if (!entry.service.match(service)) continue;
                if (EType.isSupported(entry.keyType)) {
                    return true;
                }
                if (!DEBUG) continue;
                System.out.println("Found unsupported keytype (" + entry.keyType + ") for " + service);
            }
        }
        return false;
    }

    public static String tabName() {
        return name;
    }

    public void addEntry(PrincipalName service, char[] psswd) throws KrbException {
        EncryptionKey[] encKeys = EncryptionKey.acquireSecretKeys(psswd, service.getSalt());
        for (int i = 0; encKeys != null && i < encKeys.length; ++i) {
            int keyType = encKeys[i].getEType();
            byte[] keyValue = encKeys[i].getBytes();
            int result = this.retrieveEntry(service, keyType);
            int kvno = 1;
            if (result != -1) {
                KeyTabEntry oldEntry = this.entries.elementAt(result);
                kvno = oldEntry.keyVersion;
                this.entries.removeElementAt(result);
                ++kvno;
            } else {
                kvno = 1;
            }
            KeyTabEntry newEntry = new KeyTabEntry(service, service.getRealm(), new KerberosTime(System.currentTimeMillis()), kvno, keyType, keyValue);
            if (this.entries == null) {
                this.entries = new Vector();
            }
            this.entries.addElement(newEntry);
        }
    }

    private int retrieveEntry(PrincipalName service, int keyType) {
        int found = -1;
        if (this.entries != null) {
            for (int i = 0; i < this.entries.size(); ++i) {
                KeyTabEntry e = this.entries.elementAt(i);
                if (!service.match(e.getService()) || keyType != -1 && e.keyType != keyType) continue;
                return i;
            }
        }
        return found;
    }

    public KeyTabEntry[] getEntries() {
        if (this.entries != null) {
            KeyTabEntry[] kentries = new KeyTabEntry[this.entries.size()];
            for (int i = 0; i < kentries.length; ++i) {
                kentries[i] = this.entries.elementAt(i);
            }
            return kentries;
        }
        return null;
    }

    public static synchronized KeyTab create() throws IOException, RealmException {
        String dname = KeyTab.getDefaultKeyTab();
        return KeyTab.create(dname);
    }

    public static synchronized KeyTab create(String name) throws IOException, RealmException {
        KeyTabOutputStream kos = new KeyTabOutputStream(new FileOutputStream(name));
        kos.writeVersion(1282);
        kos.close();
        singleton = new KeyTab(name);
        return singleton;
    }

    public synchronized void save() throws IOException {
        KeyTabOutputStream kos = new KeyTabOutputStream(new FileOutputStream(name));
        kos.writeVersion(this.kt_vno);
        for (int i = 0; i < this.entries.size(); ++i) {
            kos.writeEntry(this.entries.elementAt(i));
        }
        kos.close();
    }

    public void deleteEntry(PrincipalName service) {
        int result = this.retrieveEntry(service, -1);
        if (result != -1) {
            this.entries.removeElementAt(result);
        }
    }

    public synchronized void createVersion(File file) throws IOException {
        KeyTabOutputStream kos = new KeyTabOutputStream(new FileOutputStream(file));
        kos.write16(1282);
        kos.close();
    }

    public static void refresh() {
        if (singleton != null) {
            if (DEBUG) {
                System.out.println("Refreshing Keytab");
            }
            singleton = null;
        }
    }
}

