/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.ArcFourHmac;
import sun.security.krb5.internal.crypto.EType;

public final class ArcFourHmacEType
extends EType {
    public int eType() {
        return 23;
    }

    public int minimumPadSize() {
        return 1;
    }

    public int confounderSize() {
        return 8;
    }

    public int checksumType() {
        return -138;
    }

    public int checksumSize() {
        return ArcFourHmac.getChecksumLength();
    }

    public int blockSize() {
        return 1;
    }

    public int keyType() {
        return 4;
    }

    public int keySize() {
        return 16;
    }

    public byte[] encrypt(byte[] data, byte[] key, int usage) throws KrbCryptoException {
        byte[] ivec = new byte[this.blockSize()];
        return this.encrypt(data, key, ivec, usage);
    }

    public byte[] encrypt(byte[] data, byte[] key, byte[] ivec, int usage) throws KrbCryptoException {
        try {
            return ArcFourHmac.encrypt(key, usage, ivec, data, 0, data.length);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws KrbApErrException, KrbCryptoException {
        byte[] ivec = new byte[this.blockSize()];
        return this.decrypt(cipher, key, ivec, usage);
    }

    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage) throws KrbApErrException, KrbCryptoException {
        try {
            return ArcFourHmac.decrypt(key, usage, ivec, cipher, 0, cipher.length);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public byte[] decryptedData(byte[] data) {
        return data;
    }
}

