/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.ReferenceQueue;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.ExportException;
import java.rmi.server.ObjID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.misc.GC;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.ObjectEndpoint;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.WeakRef;
import sun.security.action.GetLongAction;

public final class ObjectTable {
    private static final long gcInterval = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.server.gcInterval", 3600000L));
    private static final Object tableLock = new Object();
    private static final Map<ObjectEndpoint, Target> objTable = new HashMap<ObjectEndpoint, Target>();
    private static final Map<WeakRef, Target> implTable = new HashMap<WeakRef, Target>();
    private static final Object keepAliveLock = new Object();
    private static int keepAliveCount = 0;
    private static Thread reaper = null;
    static final ReferenceQueue reapQueue = new ReferenceQueue();
    private static GC.LatencyRequest gcLatencyRequest = null;

    private ObjectTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Target getTarget(ObjectEndpoint oe) {
        Object object = tableLock;
        synchronized (object) {
            return objTable.get(oe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Target getTarget(Remote impl) {
        Object object = tableLock;
        synchronized (object) {
            return implTable.get(new WeakRef(impl));
        }
    }

    public static Remote getStub(Remote impl) throws NoSuchObjectException {
        Target target = ObjectTable.getTarget(impl);
        if (target == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return target.getStub();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        Object object = tableLock;
        synchronized (object) {
            Target target = ObjectTable.getTarget(obj);
            if (target == null) {
                throw new NoSuchObjectException("object not exported");
            }
            if (target.unexport(force)) {
                ObjectTable.removeTarget(target);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putTarget(Target target) throws ExportException {
        Remote impl;
        ObjectEndpoint oe = target.getObjectEndpoint();
        WeakRef weakImpl = target.getWeakImpl();
        if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
            DGCImpl.dgcLog.log(Log.VERBOSE, "add object " + oe);
        }
        if ((impl = target.getImpl()) == null) {
            throw new ExportException("internal error: attempt to export collected object");
        }
        Object object = tableLock;
        synchronized (object) {
            if (objTable.containsKey(oe)) {
                throw new ExportException("internal error: ObjID already in use");
            }
            if (implTable.containsKey(weakImpl)) {
                throw new ExportException("object already exported");
            }
            objTable.put(oe, target);
            implTable.put(weakImpl, target);
            if (!target.isPermanent()) {
                ObjectTable.incrementKeepAliveCount();
            }
        }
    }

    private static void removeTarget(Target target) {
        ObjectEndpoint oe = target.getObjectEndpoint();
        WeakRef weakImpl = target.getWeakImpl();
        if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
            DGCImpl.dgcLog.log(Log.VERBOSE, "remove object " + oe);
        }
        objTable.remove(oe);
        implTable.remove(weakImpl);
        target.markRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void referenced(ObjID id, long sequenceNum, VMID vmid) {
        Object object = tableLock;
        synchronized (object) {
            ObjectEndpoint oe = new ObjectEndpoint(id, Transport.currentTransport());
            Target target = objTable.get(oe);
            if (target != null) {
                target.referenced(sequenceNum, vmid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unreferenced(ObjID id, long sequenceNum, VMID vmid, boolean strong) {
        Object object = tableLock;
        synchronized (object) {
            ObjectEndpoint oe = new ObjectEndpoint(id, Transport.currentTransport());
            Target target = objTable.get(oe);
            if (target != null) {
                target.unreferenced(sequenceNum, vmid, strong);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementKeepAliveCount() {
        Object object = keepAliveLock;
        synchronized (object) {
            ++keepAliveCount;
            if (reaper == null) {
                reaper = AccessController.doPrivileged(new NewThreadAction(new Reaper(), "Reaper", false));
                reaper.start();
            }
            if (gcLatencyRequest == null) {
                gcLatencyRequest = GC.requestLatency(gcInterval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void decrementKeepAliveCount() {
        Object object = keepAliveLock;
        synchronized (object) {
            if (--keepAliveCount == 0) {
                if (reaper == null) {
                    throw new AssertionError();
                }
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        reaper.interrupt();
                        return null;
                    }
                });
                reaper = null;
                gcLatencyRequest.cancel();
                gcLatencyRequest = null;
            }
        }
    }

    private static class Reaper
    implements Runnable {
        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                do {
                    WeakRef weakImpl = (WeakRef)reapQueue.remove();
                    Object object = tableLock;
                    synchronized (object) {
                        Target target = (Target)implTable.get(weakImpl);
                        if (target != null) {
                            if (!target.isEmpty()) {
                                throw new Error("object with known references collected");
                            }
                            if (target.isPermanent()) {
                                throw new Error("permanent object collected");
                            }
                            ObjectTable.removeTarget(target);
                        }
                    }
                } while (!Thread.interrupted());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

