/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    private static final int TEMP_BUF_POOL_SIZE = 3;
    private static ThreadLocal[] bufferPool = new ThreadLocal[3];
    private static ThreadLocal localSelector;
    private static ThreadLocal localSelectorWrapper;
    private static Unsafe unsafe;
    private static int pageSize;
    private static volatile Constructor directByteBufferConstructor;
    private static volatile Constructor directByteBufferRConstructor;
    private static volatile String bugLevel;
    private static boolean loaded;

    Util() {
    }

    static ByteBuffer getTemporaryDirectBuffer(int size) {
        ByteBuffer buf = null;
        for (int i = 0; i < 3; ++i) {
            SoftReference ref = (SoftReference)bufferPool[i].get();
            if (ref == null || (buf = (ByteBuffer)ref.get()) == null || buf.capacity() < size) continue;
            buf.rewind();
            buf.limit(size);
            bufferPool[i].set(null);
            return buf;
        }
        return ByteBuffer.allocateDirect(size);
    }

    static void releaseTemporaryDirectBuffer(ByteBuffer buf) {
        SoftReference ref;
        int i;
        if (buf == null) {
            return;
        }
        for (i = 0; i < 3; ++i) {
            ref = (SoftReference)bufferPool[i].get();
            if (ref != null && ref.get() != null) continue;
            bufferPool[i].set(new SoftReference<ByteBuffer>(buf));
            return;
        }
        for (i = 0; i < 3; ++i) {
            ref = (SoftReference)bufferPool[i].get();
            ByteBuffer inCacheBuf = (ByteBuffer)ref.get();
            if (inCacheBuf != null && buf.capacity() <= inCacheBuf.capacity()) continue;
            bufferPool[i].set(new SoftReference<ByteBuffer>(buf));
            return;
        }
    }

    static Selector getTemporarySelector(SelectableChannel sc) throws IOException {
        SoftReference ref = (SoftReference)localSelector.get();
        SelectorWrapper selWrapper = null;
        Selector sel = null;
        if (ref == null || (selWrapper = (SelectorWrapper)ref.get()) == null || (sel = selWrapper.get()) == null || sel.provider() != sc.provider()) {
            sel = sc.provider().openSelector();
            localSelector.set(new SoftReference<SelectorWrapper>(new SelectorWrapper(sel)));
        } else {
            localSelectorWrapper.set(selWrapper);
        }
        return sel;
    }

    static void releaseTemporarySelector(Selector sel) throws IOException {
        sel.selectNow();
        assert (sel.keys().isEmpty()) : "Temporary selector not empty";
        localSelectorWrapper.set(null);
    }

    static ByteBuffer[] subsequence(ByteBuffer[] bs, int offset, int length) {
        if (offset == 0 && length == bs.length) {
            return bs;
        }
        int n = length;
        ByteBuffer[] bs2 = new ByteBuffer[n];
        for (int i = 0; i < n; ++i) {
            bs2[i] = bs[offset + i];
        }
        return bs2;
    }

    static <E> Set<E> ungrowableSet(final Set<E> s) {
        return new Set<E>(){

            @Override
            public int size() {
                return s.size();
            }

            @Override
            public boolean isEmpty() {
                return s.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return s.contains(o);
            }

            @Override
            public Object[] toArray() {
                return s.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return s.toArray(a);
            }

            public String toString() {
                return s.toString();
            }

            @Override
            public Iterator<E> iterator() {
                return s.iterator();
            }

            @Override
            public boolean equals(Object o) {
                return ((Object)s).equals(o);
            }

            @Override
            public int hashCode() {
                return ((Object)s).hashCode();
            }

            @Override
            public void clear() {
                s.clear();
            }

            @Override
            public boolean remove(Object o) {
                return s.remove(o);
            }

            @Override
            public boolean containsAll(Collection<?> coll) {
                return s.containsAll(coll);
            }

            @Override
            public boolean removeAll(Collection<?> coll) {
                return s.removeAll(coll);
            }

            @Override
            public boolean retainAll(Collection<?> coll) {
                return s.retainAll(coll);
            }

            @Override
            public boolean add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> coll) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static byte _get(long a) {
        return unsafe.getByte(a);
    }

    private static void _put(long a, byte b) {
        unsafe.putByte(a, b);
    }

    static void erase(ByteBuffer bb) {
        unsafe.setMemory(((DirectBuffer)((Object)bb)).address(), bb.capacity(), (byte)0);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Util.unsafe().pageSize();
        }
        return pageSize;
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> cl = Class.forName("java.nio.DirectByteBuffer");
                    Constructor<?> ctor = cl.getDeclaredConstructor(Integer.TYPE, Long.TYPE, Runnable.class);
                    ctor.setAccessible(true);
                    directByteBufferConstructor = ctor;
                }
                catch (ClassNotFoundException x) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException x) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException x) {
                    throw new InternalError();
                }
                catch (ClassCastException x) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBuffer(int size, long addr, Runnable unmapper) {
        MappedByteBuffer dbb;
        if (directByteBufferConstructor == null) {
            Util.initDBBConstructor();
        }
        try {
            dbb = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Integer(size), new Long(addr), unmapper);
        }
        catch (InstantiationException e) {
            throw new InternalError();
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
        catch (InvocationTargetException e) {
            throw new InternalError();
        }
        return dbb;
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> cl = Class.forName("java.nio.DirectByteBufferR");
                    Constructor<?> ctor = cl.getDeclaredConstructor(Integer.TYPE, Long.TYPE, Runnable.class);
                    ctor.setAccessible(true);
                    directByteBufferRConstructor = ctor;
                }
                catch (ClassNotFoundException x) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException x) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException x) {
                    throw new InternalError();
                }
                catch (ClassCastException x) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBufferR(int size, long addr, Runnable unmapper) {
        MappedByteBuffer dbb;
        if (directByteBufferRConstructor == null) {
            Util.initDBBRConstructor();
        }
        try {
            dbb = (MappedByteBuffer)directByteBufferRConstructor.newInstance(new Integer(size), new Long(addr), unmapper);
        }
        catch (InstantiationException e) {
            throw new InternalError();
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
        catch (InvocationTargetException e) {
            throw new InternalError();
        }
        return dbb;
    }

    static boolean atBugLevel(String bl) {
        if (bugLevel == null) {
            if (!VM.isBooted()) {
                return false;
            }
            String value = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.bugLevel"));
            bugLevel = value != null ? value : "";
        }
        return bugLevel.equals(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            if (loaded) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            loaded = true;
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            AccessController.doPrivileged(new LoadLibraryAction("nio"));
            IOUtil.initIDs();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            Util.bufferPool[i] = new ThreadLocal();
        }
        localSelector = new ThreadLocal();
        localSelectorWrapper = new ThreadLocal();
        unsafe = Unsafe.getUnsafe();
        pageSize = -1;
        directByteBufferConstructor = null;
        directByteBufferRConstructor = null;
        bugLevel = null;
        loaded = false;
    }

    private static class SelectorWrapper {
        private Selector sel;

        private SelectorWrapper(Selector sel) {
            this.sel = sel;
            Cleaner.create(this, new Closer(sel));
        }

        public Selector get() {
            return this.sel;
        }

        private static class Closer
        implements Runnable {
            private Selector sel;

            private Closer(Selector sel) {
                this.sel = sel;
            }

            public void run() {
                try {
                    this.sel.close();
                }
                catch (Throwable th) {
                    throw new Error(th);
                }
            }
        }
    }
}

