/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import sun.nio.ch.DevPollArrayWrapper;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

class DevPollSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    DevPollArrayWrapper pollWrapper;
    private int totalChannels;
    private HashMap fdToKey;
    private boolean closed = false;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    DevPollSelectorImpl(SelectorProvider sp) {
        super(sp);
        int[] fdes = new int[2];
        IOUtil.initPipe(fdes, false);
        this.fd0 = fdes[0];
        this.fd1 = fdes[1];
        this.pollWrapper = new DevPollArrayWrapper();
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.fdToKey = new HashMap();
        this.totalChannels = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long timeout) throws IOException {
        Object object;
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(timeout);
            object = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.end();
            throw throwable;
        }
        this.end();
        this.processDeregisterQueue();
        int numKeysUpdated = this.updateSelectedKeys();
        if (this.pollWrapper.interrupted()) {
            this.pollWrapper.putReventOps(this.pollWrapper.interruptedIndex(), 0);
            object = this.interruptLock;
            synchronized (object) {
                this.pollWrapper.clearInterrupted();
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return numKeysUpdated;
    }

    private int updateSelectedKeys() {
        int entries = this.pollWrapper.updated;
        int numKeysUpdated = 0;
        for (int i = 0; i < entries; ++i) {
            int nextFD = this.pollWrapper.getDescriptor(i);
            SelectionKeyImpl ski = (SelectionKeyImpl)this.fdToKey.get(new Integer(nextFD));
            if (ski == null) continue;
            int rOps = this.pollWrapper.getReventOps(i);
            if (this.selectedKeys.contains(ski)) {
                if (!ski.channel.translateAndSetReadyOps(rOps, ski)) continue;
                ++numKeysUpdated;
                continue;
            }
            ski.channel.translateAndSetReadyOps(rOps, ski);
            if ((ski.nioReadyOps() & ski.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(ski);
            ++numKeysUpdated;
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            Object object = this.interruptLock;
            synchronized (object) {
                this.interruptTriggered = true;
            }
            FileDispatcher.closeIntFD(this.fd0);
            FileDispatcher.closeIntFD(this.fd1);
            if (this.pollWrapper != null) {
                this.pollWrapper.release(this.fd0);
                this.pollWrapper.closeDevPollFD();
                this.pollWrapper = null;
                this.selectedKeys = null;
                Iterator i = this.keys.iterator();
                while (i.hasNext()) {
                    SelectionKeyImpl ski = (SelectionKeyImpl)i.next();
                    this.deregister(ski);
                    SelectableChannel selch = ski.channel();
                    if (!selch.isOpen() && !selch.isRegistered()) {
                        ((SelChImpl)((Object)selch)).kill();
                    }
                    i.remove();
                }
                this.totalChannels = 0;
            }
            this.fd0 = -1;
            this.fd1 = -1;
        }
    }

    protected void implRegister(SelectionKeyImpl ski) {
        int fd = IOUtil.fdVal(ski.channel.getFD());
        this.fdToKey.put(new Integer(fd), ski);
        ++this.totalChannels;
        this.keys.add(ski);
    }

    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        int i = ski.getIndex();
        assert (i >= 0);
        int fd = ski.channel.getFDVal();
        this.fdToKey.remove(new Integer(fd));
        this.pollWrapper.release(fd);
        --this.totalChannels;
        ski.setIndex(-1);
        this.keys.remove(ski);
        this.selectedKeys.remove(ski);
        this.deregister(ski);
        SelectableChannel selch = ski.channel();
        if (!selch.isOpen() && !selch.isRegistered()) {
            ((SelChImpl)((Object)selch)).kill();
        }
    }

    void putEventOps(SelectionKeyImpl sk, int ops) {
        int fd = IOUtil.fdVal(sk.channel.getFD());
        this.pollWrapper.setInterest(fd, ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        Util.load();
    }
}

