/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.IOException;
import java.io.InputStream;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;

class FixedLengthInputStream
extends LeftOverInputStream {
    private int remaining;

    FixedLengthInputStream(ExchangeImpl t, InputStream src, int len) {
        super(t, src);
        this.remaining = len;
    }

    protected int readImpl(byte[] b, int off, int len) throws IOException {
        int n;
        boolean bl = this.eof = this.remaining == 0;
        if (this.eof) {
            return -1;
        }
        if (len > this.remaining) {
            len = this.remaining;
        }
        if ((n = this.in.read(b, off, len)) > -1) {
            this.remaining -= n;
        }
        return n;
    }

    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        int n = this.in.available();
        return n < this.remaining ? n : this.remaining;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int l) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

