/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp;

import com.sun.jmx.snmp.IPAcl.SnmpAcl;
import com.sun.jmx.snmp.InetAddressAcl;
import com.sun.jmx.snmp.daemon.CommunicationException;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import sun.management.Agent;
import sun.management.AgentConfigurationError;
import sun.management.FileSystem;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.NotificationTarget;
import sun.management.snmp.jvminstr.NotificationTargetImpl;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdaptorBootstrap {
    private static final MibLogger log = new MibLogger(AdaptorBootstrap.class);
    private SnmpAdaptorServer adaptor;
    private JVM_MANAGEMENT_MIB_IMPL jvmmib;

    private AdaptorBootstrap(SnmpAdaptorServer snmpas, JVM_MANAGEMENT_MIB_IMPL mib) {
        this.jvmmib = mib;
        this.adaptor = snmpas;
    }

    private static String getDefaultFileName(String basename) {
        String fileSeparator = File.separator;
        return System.getProperty("java.home") + fileSeparator + "lib" + fileSeparator + "management" + fileSeparator + basename;
    }

    private static List<NotificationTarget> getTargetList(InetAddressAcl acl, int defaultTrapPort) {
        ArrayList<NotificationTarget> result = new ArrayList<NotificationTarget>();
        if (acl != null) {
            if (log.isDebugOn()) {
                log.debug("getTargetList", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.processing"));
            }
            Enumeration td = acl.getTrapDestinations();
            while (td.hasMoreElements()) {
                InetAddress targetAddr = (InetAddress)td.nextElement();
                Enumeration tc = acl.getTrapCommunities(targetAddr);
                while (tc.hasMoreElements()) {
                    String community = (String)tc.nextElement();
                    NotificationTargetImpl target = new NotificationTargetImpl(targetAddr, defaultTrapPort, community);
                    if (log.isDebugOn()) {
                        log.debug("getTargetList", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.adding", ((Object)target).toString()));
                    }
                    result.add(target);
                }
            }
        }
        return result;
    }

    public static synchronized AdaptorBootstrap initialize() {
        Properties props = Agent.loadManagementProperties();
        if (props == null) {
            return null;
        }
        String portStr = props.getProperty("com.sun.management.snmp.port");
        return AdaptorBootstrap.initialize(portStr, props);
    }

    public static synchronized AdaptorBootstrap initialize(String portStr, Properties props) {
        int trapPort;
        int port;
        if (portStr.length() == 0) {
            portStr = "161";
        }
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException x) {
            throw new AgentConfigurationError("agent.err.invalid.snmp.port", x, portStr);
        }
        if (port < 0) {
            throw new AgentConfigurationError("agent.err.invalid.snmp.port", portStr);
        }
        String trapPortStr = props.getProperty("com.sun.management.snmp.trap", "162");
        try {
            trapPort = Integer.parseInt(trapPortStr);
        }
        catch (NumberFormatException x) {
            throw new AgentConfigurationError("agent.err.invalid.snmp.trap.port", x, trapPortStr);
        }
        if (trapPort < 0) {
            throw new AgentConfigurationError("agent.err.invalid.snmp.trap.port", trapPortStr);
        }
        String addrStr = props.getProperty("com.sun.management.snmp.interface", "localhost");
        String defaultAclFileName = AdaptorBootstrap.getDefaultFileName("snmp.acl");
        String aclFileName = props.getProperty("com.sun.management.snmp.acl.file", defaultAclFileName);
        String useAclStr = props.getProperty("com.sun.management.snmp.acl", "true");
        boolean useAcl = Boolean.valueOf(useAclStr);
        if (useAcl) {
            AdaptorBootstrap.checkAclFile(aclFileName);
        }
        AdaptorBootstrap adaptor = null;
        try {
            adaptor = AdaptorBootstrap.getAdaptorBootstrap(port, trapPort, addrStr, useAcl, aclFileName);
        }
        catch (Exception e) {
            throw new AgentConfigurationError("agent.err.exception", e, e.getMessage());
        }
        return adaptor;
    }

    private static AdaptorBootstrap getAdaptorBootstrap(int port, int trapPort, String bindAddress, boolean useAcl, String aclFileName) {
        SnmpAcl acl;
        InetAddress address;
        try {
            address = InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException e) {
            throw new AgentConfigurationError("agent.err.unknown.snmp.interface", e, bindAddress);
        }
        if (log.isDebugOn()) {
            log.debug("initialize", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.starting\n\tcom.sun.management.snmp.port=" + port + "\n\t" + "com.sun.management.snmp.trap" + "=" + trapPort + "\n\t" + "com.sun.management.snmp.interface" + "=" + address + (useAcl ? "\n\tcom.sun.management.snmp.acl.file=" + aclFileName : "\n\tNo ACL") + ""));
        }
        try {
            acl = useAcl ? new SnmpAcl(System.getProperty("user.name"), aclFileName) : null;
        }
        catch (UnknownHostException e) {
            throw new AgentConfigurationError("agent.err.unknown.snmp.interface", e, e.getMessage());
        }
        SnmpAdaptorServer adaptor = new SnmpAdaptorServer(acl, port, address);
        adaptor.setUserDataFactory(new JvmContextFactory());
        adaptor.setTrapPort(trapPort);
        JVM_MANAGEMENT_MIB_IMPL mib = new JVM_MANAGEMENT_MIB_IMPL();
        try {
            mib.init();
        }
        catch (IllegalAccessException x) {
            throw new AgentConfigurationError("agent.err.snmp.mib.init.failed", x, x.getMessage());
        }
        mib.addTargets(AdaptorBootstrap.getTargetList(acl, trapPort));
        try {
            adaptor.start(Long.MAX_VALUE);
        }
        catch (Exception x) {
            Throwable next;
            Throwable t = x;
            if (x instanceof CommunicationException && (next = t.getCause()) != null) {
                t = next;
            }
            throw new AgentConfigurationError("agent.err.snmp.adaptor.start.failed", t, address + ":" + port, "(" + t.getMessage() + ")");
        }
        if (!adaptor.isActive()) {
            throw new AgentConfigurationError("agent.err.snmp.adaptor.start.failed", address + ":" + port);
        }
        try {
            adaptor.addMib(mib);
            mib.setSnmpAdaptor(adaptor);
        }
        catch (RuntimeException x) {
            new AdaptorBootstrap(adaptor, mib).terminate();
            throw x;
        }
        log.debug("initialize", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.initialize1"));
        log.config("initialize", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.initialize2", address.toString(), Integer.toString(adaptor.getPort())));
        return new AdaptorBootstrap(adaptor, mib);
    }

    private static void checkAclFile(String aclFileName) {
        if (aclFileName == null || aclFileName.length() == 0) {
            throw new AgentConfigurationError("agent.err.acl.file.notset");
        }
        File file = new File(aclFileName);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.acl.file.notfound", aclFileName);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.acl.file.not.readable", aclFileName);
        }
        FileSystem fs = FileSystem.open();
        try {
            if (fs.supportsFileSecurity(file) && !fs.isAccessUserOnly(file)) {
                throw new AgentConfigurationError("agent.err.acl.file.access.notrestricted", aclFileName);
            }
        }
        catch (IOException e) {
            throw new AgentConfigurationError("agent.err.acl.file.read.failed", aclFileName);
        }
    }

    public synchronized int getPort() {
        if (this.adaptor != null) {
            return this.adaptor.getPort();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        if (this.adaptor == null) {
            return;
        }
        try {
            this.jvmmib.terminate();
        }
        catch (Exception x) {
            log.debug("jmxremote.AdaptorBootstrap.getTargetList.terminate", x.toString());
        }
        finally {
            this.jvmmib = null;
        }
        try {
            this.adaptor.stop();
        }
        finally {
            this.adaptor = null;
        }
    }

    public static interface PropertyNames {
        public static final String PORT = "com.sun.management.snmp.port";
        public static final String CONFIG_FILE_NAME = "com.sun.management.config.file";
        public static final String TRAP_PORT = "com.sun.management.snmp.trap";
        public static final String USE_ACL = "com.sun.management.snmp.acl";
        public static final String ACL_FILE_NAME = "com.sun.management.snmp.acl.file";
        public static final String BIND_ADDRESS = "com.sun.management.snmp.interface";
    }

    public static interface DefaultValues {
        public static final String PORT = "161";
        public static final String CONFIG_FILE_NAME = "management.properties";
        public static final String TRAP_PORT = "162";
        public static final String USE_ACL = "true";
        public static final String ACL_FILE_NAME = "snmp.acl";
        public static final String BIND_ADDRESS = "localhost";
    }
}

