/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import sun.awt.SunToolkit;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.xr.XRSurfaceData;

public class XRRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    public static XRRenderer getInstance() {
        return new XRRenderer();
    }

    private final void validate(SunGraphics2D sg2d) {
        XRSurfaceData xrsd = (XRSurfaceData)sg2d.surfaceData;
        xrsd.validate(sg2d.getCompClip(), sg2d.composite, sg2d.transform, sg2d.paint, sg2d, 0);
    }

    native void XRDrawLine(long var1, int var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(SunGraphics2D sg2d, int x1, int y1, int x2, int y2) {
        try {
            SunToolkit.awtLock();
            this.validate(sg2d);
            int transx = sg2d.transX;
            int transy = sg2d.transY;
            this.XRDrawLine(sg2d.surfaceData.getNativeOps(), x1 + transx, y1 + transy, x2 + transx, y2 + transy);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public void drawRect(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.draw(sg2d, new Rectangle2D.Float(x, y, width, height));
    }

    public void drawPolyline(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        Path2D.Float p2d = new Path2D.Float();
        if (npoints > 1) {
            p2d.moveTo(xpoints[0], ypoints[0]);
            for (int i = 1; i < npoints; ++i) {
                p2d.lineTo(xpoints[i], ypoints[i]);
            }
        }
        this.draw(sg2d, p2d);
    }

    public void drawPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        this.draw(sg2d, new Polygon(xpoints, ypoints, npoints));
    }

    native void XRFillRect(long var1, int var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRect(SunGraphics2D sg2d, int x, int y, int width, int height) {
        SunToolkit.awtLock();
        try {
            this.validate(sg2d);
            x = (int)((double)x + sg2d.transform.getTranslateX());
            y = (int)((double)y + sg2d.transform.getTranslateY());
            this.XRFillRect(sg2d.surfaceData.getNativeOps(), x, y, width, height);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public void fillPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        this.fill(sg2d, new Polygon(xpoints, ypoints, npoints));
    }

    public void drawRoundRect(SunGraphics2D sg2d, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(sg2d, new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void fillRoundRect(SunGraphics2D sg2d, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(sg2d, new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void drawOval(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.draw(sg2d, new Ellipse2D.Float(x, y, width, height));
    }

    public void fillOval(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.fill(sg2d, new Ellipse2D.Float(x, y, width, height));
    }

    public void drawArc(SunGraphics2D sg2d, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(sg2d, new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void fillArc(SunGraphics2D sg2d, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(sg2d, new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2));
    }

    native void XRFillSpans(long var1, SpanIterator var3, long var4, int var6, int var7);

    native void XRDoPath(SunGraphics2D var1, long var2, int var4, int var5, Path2D.Float var6, boolean var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPath(SunGraphics2D sg2d, Shape s, boolean isFill) {
        int transy;
        int transx;
        Path2D.Float p2df;
        if (sg2d.transformState <= 1) {
            p2df = s instanceof Path2D.Float ? (Path2D.Float)s : new Path2D.Float(s);
            transx = sg2d.transX;
            transy = sg2d.transY;
        } else {
            p2df = new Path2D.Float(s, sg2d.transform);
            transx = 0;
            transy = 0;
        }
        try {
            SunToolkit.awtLock();
            this.validate(sg2d);
            this.XRDoPath(sg2d, sg2d.surfaceData.getNativeOps(), transx, transy, p2df, isFill);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(SunGraphics2D sg2d, Shape s) {
        block8: {
            if (sg2d.strokeState == 0) {
                this.doPath(sg2d, s, false);
                return;
            }
            if (sg2d.strokeState < 3) {
                ShapeSpanIterator si = LoopPipe.getStrokeSpans(sg2d, s);
                try {
                    try {
                        SunToolkit.awtLock();
                        this.validate(sg2d);
                        this.XRFillSpans(sg2d.surfaceData.getNativeOps(), si, si.getNativeIterator(), 0, 0);
                        break block8;
                    }
                    finally {
                        SunToolkit.awtUnlock();
                    }
                }
                finally {
                    si.dispose();
                }
            }
            this.fill(sg2d, sg2d.stroke.createStrokedShape(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(SunGraphics2D sg2d, Shape s) {
        int transy;
        int transx;
        AffineTransform at;
        if (sg2d.strokeState == 0) {
            this.doPath(sg2d, s, true);
            return;
        }
        if (sg2d.transformState < 3) {
            at = null;
            transx = sg2d.transX;
            transy = sg2d.transY;
        } else {
            at = sg2d.transform;
            transy = 0;
            transx = 0;
        }
        ShapeSpanIterator ssi = LoopPipe.getFillSSI(sg2d);
        try {
            Region clip = sg2d.getCompClip();
            ssi.setOutputAreaXYXY(clip.getLoX() - transx, clip.getLoY() - transy, clip.getHiX() - transx, clip.getHiY() - transy);
            ssi.appendPath(s.getPathIterator(at));
            try {
                SunToolkit.awtLock();
                this.validate(sg2d);
                this.XRFillSpans(sg2d.surfaceData.getNativeOps(), ssi, ssi.getNativeIterator(), transx, transy);
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
        finally {
            ssi.dispose();
        }
    }

    native void devCopyArea(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);
}

