/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import sun.java2d.pisces.LineSink;
import sun.java2d.pisces.PiscesMath;
import sun.java2d.pisces.Transform4;

public class Dasher
extends LineSink {
    LineSink output;
    int[] dash;
    int startPhase;
    boolean startDashOn;
    int startIdx;
    int idx;
    boolean dashOn;
    int phase;
    int sx;
    int sy;
    int x0;
    int y0;
    int m00;
    int m01;
    int m10;
    int m11;
    Transform4 transform;
    boolean symmetric;
    long ldet;
    boolean firstDashOn;
    boolean starting;
    int sx1;
    int sy1;

    public Dasher() {
    }

    public Dasher(LineSink output, int[] dash, int phase, Transform4 transform) {
        this.setOutput(output);
        this.setParameters(dash, phase, transform);
    }

    public void setOutput(LineSink output) {
        this.output = output;
    }

    public void setParameters(int[] dash, int phase, Transform4 transform) {
        int d;
        if (phase < 0) {
            throw new IllegalArgumentException("phase < 0 !");
        }
        int idx = 0;
        this.dashOn = true;
        while (phase >= (d = dash[idx])) {
            phase -= d;
            idx = (idx + 1) % dash.length;
            this.dashOn = !this.dashOn;
        }
        this.dash = new int[dash.length];
        for (int i = 0; i < dash.length; ++i) {
            this.dash[i] = dash[i];
        }
        this.startPhase = this.phase = phase;
        this.startDashOn = this.dashOn;
        this.startIdx = idx;
        this.transform = transform;
        this.m00 = transform.m00;
        this.m01 = transform.m01;
        this.m10 = transform.m10;
        this.m11 = transform.m11;
        this.ldet = (long)this.m00 * (long)this.m11 - (long)this.m01 * (long)this.m10 >> 16;
        this.symmetric = this.m00 == this.m11 && this.m10 == -this.m01;
    }

    public void moveTo(int x0, int y0) {
        this.output.moveTo(x0, y0);
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.sx = this.x0 = x0;
        this.sy = this.y0 = y0;
        this.starting = true;
    }

    public void lineJoin() {
        this.output.lineJoin();
    }

    private void goTo(int x1, int y1) {
        if (this.dashOn) {
            if (this.starting) {
                this.sx1 = x1;
                this.sy1 = y1;
                this.firstDashOn = true;
                this.starting = false;
            }
            this.output.lineTo(x1, y1);
        } else {
            if (this.starting) {
                this.firstDashOn = false;
                this.starting = false;
            }
            this.output.moveTo(x1, y1);
        }
        this.x0 = x1;
        this.y0 = y1;
    }

    public void lineTo(int x1, int y1) {
        while (true) {
            int l;
            int d = this.dash[this.idx] - this.phase;
            int lx = x1 - this.x0;
            int ly = y1 - this.y0;
            if (this.symmetric) {
                l = (int)((long)PiscesMath.hypot(lx, ly) * 65536L / this.ldet);
            } else {
                long la = ((long)ly * (long)this.m00 - (long)lx * (long)this.m10) / this.ldet;
                long lb = ((long)ly * (long)this.m01 - (long)lx * (long)this.m11) / this.ldet;
                l = (int)PiscesMath.hypot(la, lb);
            }
            if (l < d) {
                this.goTo(x1, y1);
                this.phase += l;
                return;
            }
            long t = ((long)d << 16) / (long)l;
            int xsplit = this.x0 + (int)(t * (long)(x1 - this.x0) >> 16);
            int ysplit = this.y0 + (int)(t * (long)(y1 - this.y0) >> 16);
            this.goTo(xsplit, ysplit);
            this.idx = (this.idx + 1) % this.dash.length;
            this.dashOn = !this.dashOn;
            this.phase = 0;
        }
    }

    public void close() {
        this.lineTo(this.sx, this.sy);
        if (this.firstDashOn) {
            this.output.lineTo(this.sx1, this.sy1);
        }
    }

    public void end() {
        this.output.end();
    }
}

