/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import sun.awt.X11.Native;
import sun.awt.X11.UnsafeXDisposerRecord;
import sun.awt.X11.XAtom;
import sun.awt.X11.XPropertyCache;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.java2d.Disposer;
import sun.misc.Unsafe;

public class WindowPropertyGetter {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private final long actual_type = unsafe.allocateMemory(8L);
    private final long actual_format = unsafe.allocateMemory(4L);
    private final long nitems_ptr = unsafe.allocateMemory(8L);
    private final long bytes_after = unsafe.allocateMemory(8L);
    private final long data = unsafe.allocateMemory(8L);
    private final long window;
    private final XAtom property;
    private final long offset;
    private final long length;
    private final boolean auto_delete;
    private final long type;
    private boolean executed = false;
    UnsafeXDisposerRecord disposer;
    static Set<XAtom> cacheableProperties = new HashSet<XAtom>(Arrays.asList(XAtom.get("_NET_WM_STATE"), XAtom.get("WM_STATE"), XAtom.get("_MOTIF_WM_HINTS")));

    public WindowPropertyGetter(long window, XAtom property, long offset, long length, boolean auto_delete, long type) {
        if (property.getAtom() == 0L) {
            throw new IllegalArgumentException("Property ATOM should be initialized first:" + property);
        }
        if (window == 0L) {
            throw new IllegalArgumentException("Window must not be zero");
        }
        this.window = window;
        this.property = property;
        this.offset = offset;
        this.length = length;
        this.auto_delete = auto_delete;
        this.type = type;
        Native.putLong(this.data, 0L);
        this.disposer = new UnsafeXDisposerRecord("WindowPropertyGetter", new long[]{this.actual_type, this.actual_format, this.nitems_ptr, this.bytes_after}, new long[]{this.data});
        Disposer.addRecord(this, this.disposer);
    }

    public WindowPropertyGetter(long window, XAtom property, long offset, long length, boolean auto_delete, XAtom type) {
        this(window, property, offset, length, auto_delete, type.getAtom());
    }

    public int execute() {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(XToolkit.XErrorHandler errorHandler) {
        XToolkit.awtLock();
        try {
            if (this.isDisposed()) {
                throw new IllegalStateException("Disposed");
            }
            if (this.executed) {
                throw new IllegalStateException("Already executed");
            }
            this.executed = true;
            if (WindowPropertyGetter.isCachingSupported() && this.isCached()) {
                this.readFromCache();
                int n = 0;
                return n;
            }
            if (errorHandler == XToolkit.IgnoreBadWindowHandler) {
                errorHandler = null;
            }
            if (errorHandler != null) {
                XToolkit.WITH_XERROR_HANDLER(errorHandler);
            }
            Native.putLong(this.data, 0L);
            int status = XlibWrapper.XGetWindowProperty(XToolkit.getDisplay(), this.window, this.property.getAtom(), this.offset, this.length, this.auto_delete ? 1 : 0, this.type, this.actual_type, this.actual_format, this.nitems_ptr, this.bytes_after, this.data);
            if (WindowPropertyGetter.isCachingSupported() && status == 0 && this.getData() != 0L && WindowPropertyGetter.isCacheableProperty(this.property)) {
                this.cacheProperty();
            }
            if (errorHandler != null) {
                XToolkit.RESTORE_XERROR_HANDLER();
            }
            int n = status;
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isDisposed() {
        return this.disposer.disposed;
    }

    public int getActualFormat() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.executed) {
            throw new IllegalStateException("Not executed");
        }
        return unsafe.getInt(this.actual_format);
    }

    public long getActualType() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.executed) {
            throw new IllegalStateException("Not executed");
        }
        return XAtom.getAtom(this.actual_type);
    }

    public int getNumberOfItems() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.executed) {
            throw new IllegalStateException("Not executed");
        }
        return (int)Native.getLong(this.nitems_ptr);
    }

    public long getData() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        return Native.getLong(this.data);
    }

    public long getBytesAfter() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.bytes_after);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        XToolkit.awtLock();
        try {
            if (this.isDisposed()) {
                return;
            }
            this.disposer.dispose();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static boolean isCachingSupported() {
        return XPropertyCache.isCachingSupported();
    }

    static boolean isCacheableProperty(XAtom property) {
        return cacheableProperties.contains(property);
    }

    boolean isCached() {
        return XPropertyCache.isCached(this.window, this.property);
    }

    int getDataLength() {
        return this.getActualFormat() / 8 * this.getNumberOfItems();
    }

    void readFromCache() {
        this.property.putAtom(this.actual_type);
        XPropertyCache.PropertyCacheEntry entry = XPropertyCache.getCacheEntry(this.window, this.property);
        Native.putInt(this.actual_format, entry.getFormat());
        Native.putLong(this.nitems_ptr, entry.getNumberOfItems());
        Native.putLong(this.bytes_after, entry.getBytesAfter());
        Native.putLong(this.data, unsafe.allocateMemory(this.getDataLength()));
        XlibWrapper.memcpy(this.getData(), entry.getData(), this.getDataLength());
    }

    void cacheProperty() {
        XPropertyCache.storeCache(new XPropertyCache.PropertyCacheEntry(this.getActualFormat(), this.getNumberOfItems(), this.getBytesAfter(), this.getData(), this.getDataLength()), this.window, this.property);
    }
}

