/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import sun.awt.AWTAutoShutdown;
import sun.awt.EventQueueItem;
import sun.awt.SunToolkit;

class PostEventQueue {
    private EventQueueItem queueHead = null;
    private EventQueueItem queueTail = null;
    private final EventQueue eventQueue;

    PostEventQueue(EventQueue eq) {
        this.eventQueue = eq;
    }

    public boolean noEvents() {
        return this.queueHead == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.queueHead != null) {
            PostEventQueue postEventQueue = this;
            synchronized (postEventQueue) {
                EventQueueItem tempQueue = this.queueHead;
                this.queueTail = null;
                this.queueHead = null;
                while (tempQueue != null) {
                    this.eventQueue.postEvent(tempQueue.event);
                    tempQueue = tempQueue.next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postEvent(AWTEvent event) {
        EventQueueItem item = new EventQueueItem(event);
        PostEventQueue postEventQueue = this;
        synchronized (postEventQueue) {
            if (this.queueHead == null) {
                this.queueHead = this.queueTail = item;
            } else {
                this.queueTail.next = item;
                this.queueTail = item;
            }
        }
        SunToolkit.wakeupEventQueue(this.eventQueue, event.getSource() == AWTAutoShutdown.getInstance());
    }
}

