/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.services.XServiceManagerStub;

public class ServiceUtil {
    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    public static BasicService getBasicService() {
        return (BasicService)ServiceUtil.getService("javax.jnlp.BasicService");
    }

    public static ClipboardService getClipboardService() {
        return (ClipboardService)ServiceUtil.getService("javax.jnlp.ClipboardService");
    }

    public static DownloadService getDownloadService() {
        return (DownloadService)ServiceUtil.getService("javax.jnlp.DownloadService");
    }

    public static ExtensionInstallerService getExtensionInstallerService() {
        return (ExtensionInstallerService)ServiceUtil.getService("javax.jnlp.ExtensionInstallerService");
    }

    public static FileOpenService getFileOpenService() {
        return (FileOpenService)ServiceUtil.getService("javax.jnlp.FileOpenService");
    }

    public static FileSaveService getFileSaveService() {
        return (FileSaveService)ServiceUtil.getService("javax.jnlp.FileSaveService");
    }

    public static PersistenceService getPersistenceService() {
        return (PersistenceService)ServiceUtil.getService("javax.jnlp.PersistenceService");
    }

    public static PrintService getPrintService() {
        return (PrintService)ServiceUtil.getService("javax.jnlp.PrintService");
    }

    private static Object getService(String name) {
        try {
            return ServiceManager.lookup(name);
        }
        catch (UnavailableServiceException ex) {
            return null;
        }
    }

    static Object createPrivilegedProxy(Class iface, Object receiver) {
        return Proxy.newProxyInstance(XServiceManagerStub.class.getClassLoader(), new Class[]{iface}, new PrivilegedHandler(receiver));
    }

    public static boolean checkAccess(SecurityWarningDialog.AccessType type, Object ... extras) {
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app != null) {
            if (!app.isSigned()) {
                final SecurityWarningDialog.AccessType tmpType = type;
                final Object[] tmpExtras = extras;
                final ApplicationInstance tmpApp = app;
                Object o = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        boolean b = SecurityWarningDialog.showAccessWarningDialog(tmpType, tmpApp.getJNLPFile(), tmpExtras);
                        return new Boolean(b);
                    }
                });
                return (Boolean)o;
            }
            if (app.isSigned()) {
                return true;
            }
        }
        return false;
    }

    private static class PrivilegedHandler
    implements InvocationHandler {
        private final Object receiver;

        PrivilegedHandler(Object receiver) {
            this.receiver = receiver;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            if (JNLPRuntime.isDebug()) {
                System.err.println("call privileged method: " + method.getName());
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        System.err.println("           arg: " + args[i]);
                    }
                }
            }
            PrivilegedExceptionAction invoker = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return method.invoke(PrivilegedHandler.this.receiver, args);
                }
            };
            try {
                Object result = AccessController.doPrivileged(invoker);
                if (JNLPRuntime.isDebug()) {
                    System.err.println("        result: " + result);
                }
                return result;
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof InvocationTargetException) {
                    throw e.getCause().getCause();
                }
                throw e.getCause();
            }
        }
    }

    public static enum AccessType {
        READ_FILE,
        WRITE_FILE,
        CLIPBOARD_READ,
        CLIPBOARD_WRITE,
        PRINTER;

    }
}

