/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.VariableX509TrustManager;
import net.sourceforge.jnlp.tools.KeyTool;

public class HttpsCertVerifier
implements CertVerifier {
    private VariableX509TrustManager tm;
    private X509Certificate[] chain;
    private String authType;
    private ArrayList<String> details = new ArrayList();

    public HttpsCertVerifier(VariableX509TrustManager tm, X509Certificate[] chain, String authType) {
        this.tm = tm;
        this.chain = chain;
        this.authType = authType;
    }

    @Override
    public boolean getAlreadyTrustPublisher() {
        try {
            this.tm.checkServerTrusted(this.chain, this.authType, true);
            return true;
        }
        catch (CertificateException ce) {
            return false;
        }
    }

    @Override
    public ArrayList<CertPath> getCerts() {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (int i = 0; i < this.chain.length; ++i) {
            list.add(this.chain[i]);
        }
        ArrayList<CertPath> certPaths = new ArrayList<CertPath>();
        try {
            certPaths.add(CertificateFactory.getInstance("X.509").generateCertPath(list));
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        return certPaths;
    }

    @Override
    public ArrayList<String> getDetails() {
        boolean hasExpiredCert = false;
        boolean hasExpiringCert = false;
        boolean notYetValidCert = false;
        boolean isUntrusted = false;
        if (!this.getAlreadyTrustPublisher()) {
            isUntrusted = true;
        }
        for (int i = 0; i < this.chain.length; ++i) {
            X509Certificate cert = this.chain[i];
            long now = System.currentTimeMillis();
            long SIX_MONTHS = 15552000000L;
            long notAfter = cert.getNotAfter().getTime();
            if (notAfter < now) {
                hasExpiredCert = true;
            } else if (notAfter < now + SIX_MONTHS) {
                hasExpiringCert = true;
            }
            try {
                cert.checkValidity();
                continue;
            }
            catch (CertificateNotYetValidException cnyve) {
                notYetValidCert = true;
                continue;
            }
            catch (CertificateExpiredException cee) {
                hasExpiredCert = true;
            }
        }
        if (isUntrusted || hasExpiredCert || hasExpiringCert || notYetValidCert) {
            if (isUntrusted) {
                this.addToDetails(HttpsCertVerifier.R("SUntrustedCertificate"));
            }
            if (hasExpiredCert) {
                this.addToDetails(HttpsCertVerifier.R("SHasExpiredCert"));
            }
            if (hasExpiringCert) {
                this.addToDetails(HttpsCertVerifier.R("SHasExpiringCert"));
            }
            if (notYetValidCert) {
                this.addToDetails(HttpsCertVerifier.R("SNotYetValidCert"));
            }
        }
        return this.details;
    }

    private void addToDetails(String detail) {
        if (!this.details.contains(detail)) {
            this.details.add(detail);
        }
    }

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    @Override
    public Certificate getPublisher() {
        if (this.chain.length > 0) {
            return this.chain[0];
        }
        return null;
    }

    @Override
    public Certificate getRoot() {
        if (this.chain.length > 0) {
            return this.chain[this.chain.length - 1];
        }
        return null;
    }

    @Override
    public boolean getRootInCacerts() {
        try {
            KeyTool kt = new KeyTool();
            return kt.checkCacertsForCertificate(this.getRoot());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean hasSigningIssues() {
        return false;
    }

    @Override
    public boolean noSigningIssues() {
        return false;
    }
}

