/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.HttpsCertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogUI;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.tools.KeyTool;
import sun.misc.Launcher;

public class CertWarningPane
extends SecurityDialogUI {
    JCheckBox alwaysTrust;
    CertVerifier certVerifier;

    public CertWarningPane(JComponent x, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.certVerifier = certVerifier;
    }

    @Override
    protected void installComponents() {
        SecurityWarningDialog.AccessType type = ((SecurityWarningDialog)this.optionPane).getType();
        JNLPFile file = ((SecurityWarningDialog)this.optionPane).getFile();
        Certificate c = ((SecurityWarningDialog)this.optionPane).getJarSigner().getPublisher();
        String name = "";
        String publisher = "";
        String from = "";
        try {
            name = this.certVerifier instanceof HttpsCertVerifier && c instanceof X509Certificate ? this.getCN(((X509Certificate)c).getSubjectX500Principal().getName()) : (file instanceof PluginBridge ? file.getTitle() : file.getInformation().getTitle());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (c instanceof X509Certificate) {
                publisher = this.getCN(((X509Certificate)c).getSubjectX500Principal().getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            from = file instanceof PluginBridge ? file.getCodeBase().getHost() : file.getInformation().getHomepage().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        String topLabelText = "";
        String propertyName = "";
        if (this.certVerifier instanceof HttpsCertVerifier) {
            topLabelText = "The website's certificate cannot be verified. Do you want to continue?";
            propertyName = "OptionPane.warningIcon";
        } else {
            switch (type) {
                case VERIFIED: {
                    topLabelText = CertWarningPane.R("SSigVerified");
                    propertyName = "OptionPane.informationIcon";
                    break;
                }
                case UNVERIFIED: {
                    topLabelText = CertWarningPane.R("SSigUnverified");
                    propertyName = "OptionPane.warningIcon";
                    break;
                }
                case SIGNING_ERROR: {
                    topLabelText = CertWarningPane.R("SSignatureError");
                    propertyName = "OptionPane.warningIcon";
                }
            }
        }
        ImageIcon icon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/warning.png"));
        JLabel topLabel = new JLabel(this.htmlWrap(topLabelText), icon, 2);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(400, 60));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel nameLabel = new JLabel("Name:   " + name);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel publisherLabel = new JLabel("Publisher: " + publisher);
        publisherLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel fromLabel = new JLabel("From:   " + from);
        fromLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.alwaysTrust = new JCheckBox("Always trust content from this publisher");
        this.alwaysTrust.setEnabled(true);
        JPanel infoPanel = new JPanel(new GridLayout(4, 1));
        infoPanel.add(nameLabel);
        infoPanel.add(publisherLabel);
        if (!(this.certVerifier instanceof HttpsCertVerifier)) {
            infoPanel.add(fromLabel);
        }
        infoPanel.add(this.alwaysTrust);
        infoPanel.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton run = new JButton("Run");
        JButton cancel = new JButton("Cancel");
        int buttonWidth = Math.max(run.getMinimumSize().width, cancel.getMinimumSize().width);
        int buttonHeight = run.getMinimumSize().height;
        Dimension d = new Dimension(buttonWidth, buttonHeight);
        run.setPreferredSize(d);
        cancel.setPreferredSize(d);
        run.addActionListener(this.createButtonActionListener(0));
        run.addActionListener(new CheckBoxListener());
        cancel.addActionListener(this.createButtonActionListener(1));
        this.initialFocusComponent = cancel;
        buttonPanel.add(run);
        buttonPanel.add(cancel);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        main.add(topPanel);
        main.add(infoPanel);
        main.add(buttonPanel);
        JButton moreInfo = new JButton("More information...");
        moreInfo.addActionListener(new MoreInfoButtonListener());
        JLabel bottomLabel = ((SecurityWarningDialog)this.optionPane).getJarSigner().getRootInCacerts() ? new JLabel(this.htmlWrap(CertWarningPane.R("STrustedSource"))) : new JLabel(this.htmlWrap(CertWarningPane.R("SUntrustedSource")));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(bottomLabel);
        bottomPanel.add(moreInfo);
        bottomPanel.setPreferredSize(new Dimension(500, 100));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        main.add(bottomPanel);
        this.optionPane.add((Component)main, "Center");
    }

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    protected String htmlWrap(String s) {
        return "<html>" + s + "</html>";
    }

    private String getCN(String principal) {
        int start = principal.indexOf("CN=");
        int end = principal.indexOf(",", start);
        if (end == -1) {
            end = principal.length();
        }
        if (start >= 0) {
            return principal.substring(start + 3, end);
        }
        return principal;
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CertWarningPane.this.alwaysTrust != null && CertWarningPane.this.alwaysTrust.isSelected()) {
                try {
                    KeyTool kt = new KeyTool();
                    Certificate c = ((SecurityWarningDialog)CertWarningPane.this.optionPane).getJarSigner().getPublisher();
                    kt.importCert(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class MoreInfoButtonListener
    implements ActionListener {
        private MoreInfoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityWarningDialog.showMoreInfoDialog(((SecurityWarningDialog)CertWarningPane.this.optionPane).getJarSigner(), CertWarningPane.this.optionPane);
        }
    }
}

