/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class DefaultLaunchHandler
implements LaunchHandler {
    @Override
    public void launchError(LaunchException exception) {
        this.printMessage(exception);
    }

    @Override
    public boolean launchWarning(LaunchException warning) {
        this.printMessage(warning);
        return true;
    }

    @Override
    public boolean validationError(LaunchException security) {
        this.printMessage(security);
        return true;
    }

    @Override
    public void launchCompleted(ApplicationInstance application) {
    }

    protected void printMessage(LaunchException ex) {
        StringBuffer result = new StringBuffer();
        result.append("netx: ");
        result.append(ex.getCategory());
        if (ex.getSummary() != null) {
            result.append(": ");
            result.append(ex.getSummary());
        }
        if (JNLPRuntime.isDebug()) {
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            } else {
                ex.printStackTrace();
            }
        }
        Throwable[] causes = ex.getCauses();
        for (int i = 0; i < causes.length; ++i) {
            result.append(" (");
            result.append(causes[i].getClass().getName());
            result.append(" ");
            result.append(causes[i].getMessage());
            result.append(")");
        }
    }
}

