/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.LayoutQueue;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AsyncBoxView
extends View {
    int axis;
    List stats = new ArrayList();
    float majorSpan;
    boolean estimatedMajorSpan;
    float minorSpan;
    protected ChildLocator locator;
    float topInset;
    float bottomInset;
    float leftInset;
    float rightInset;
    ChildState minRequest;
    ChildState prefRequest;
    boolean majorChanged;
    boolean minorChanged;
    Runnable flushTask;
    ChildState changing;

    public AsyncBoxView(Element elem, int axis) {
        super(elem);
        this.axis = axis;
        this.locator = new ChildLocator();
        this.flushTask = new FlushTask();
        this.minorSpan = 32767.0f;
        this.estimatedMajorSpan = false;
    }

    public int getMajorAxis() {
        return this.axis;
    }

    public int getMinorAxis() {
        return this.axis == 0 ? 1 : 0;
    }

    public float getTopInset() {
        return this.topInset;
    }

    public void setTopInset(float i) {
        this.topInset = i;
    }

    public float getBottomInset() {
        return this.bottomInset;
    }

    public void setBottomInset(float i) {
        this.bottomInset = i;
    }

    public float getLeftInset() {
        return this.leftInset;
    }

    public void setLeftInset(float i) {
        this.leftInset = i;
    }

    public float getRightInset() {
        return this.rightInset;
    }

    public void setRightInset(float i) {
        this.rightInset = i;
    }

    protected float getInsetSpan(int axis) {
        float margin = axis == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
        return margin;
    }

    protected void setEstimatedMajorSpan(boolean isEstimated) {
        this.estimatedMajorSpan = isEstimated;
    }

    protected boolean getEstimatedMajorSpan() {
        return this.estimatedMajorSpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChildState getChildState(int index) {
        List list = this.stats;
        synchronized (list) {
            if (index >= 0 && index < this.stats.size()) {
                return (ChildState)this.stats.get(index);
            }
            return null;
        }
    }

    protected LayoutQueue getLayoutQueue() {
        return LayoutQueue.getDefaultQueue();
    }

    protected ChildState createChildState(View v) {
        return new ChildState(v);
    }

    protected synchronized void majorRequirementChange(ChildState cs, float delta) {
        if (!this.estimatedMajorSpan) {
            this.majorSpan += delta;
        }
        this.majorChanged = true;
    }

    protected synchronized void minorRequirementChange(ChildState cs) {
        this.minorChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushRequirementChanges() {
        AbstractDocument doc = (AbstractDocument)this.getDocument();
        try {
            doc.readLock();
            View parent = null;
            boolean horizontal = false;
            boolean vertical = false;
            AsyncBoxView asyncBoxView = this;
            synchronized (asyncBoxView) {
                List list = this.stats;
                synchronized (list) {
                    int n = this.getViewCount();
                    if (n > 0 && (this.minorChanged || this.estimatedMajorSpan)) {
                        LayoutQueue q = this.getLayoutQueue();
                        ChildState min = this.getChildState(0);
                        ChildState pref = this.getChildState(0);
                        float span = 0.0f;
                        for (int i = 1; i < n; ++i) {
                            ChildState cs = this.getChildState(i);
                            if (this.minorChanged) {
                                if (cs.min > min.min) {
                                    min = cs;
                                }
                                if (cs.pref > pref.pref) {
                                    pref = cs;
                                }
                            }
                            if (!this.estimatedMajorSpan) continue;
                            span += cs.getMajorSpan();
                        }
                        if (this.minorChanged) {
                            this.minRequest = min;
                            this.prefRequest = pref;
                        }
                        if (this.estimatedMajorSpan) {
                            this.majorSpan = span;
                            this.estimatedMajorSpan = false;
                            this.majorChanged = true;
                        }
                    }
                }
                if (this.majorChanged || this.minorChanged) {
                    parent = this.getParent();
                    if (parent != null) {
                        if (this.axis == 0) {
                            horizontal = this.majorChanged;
                            vertical = this.minorChanged;
                        } else {
                            vertical = this.majorChanged;
                            horizontal = this.minorChanged;
                        }
                    }
                    this.majorChanged = false;
                    this.minorChanged = false;
                }
            }
            if (parent != null) {
                parent.preferenceChanged(this, horizontal, vertical);
                Container c = this.getContainer();
                if (c != null) {
                    c.repaint();
                }
            }
        }
        finally {
            doc.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int offset, int length, View[] views) {
        List list = this.stats;
        synchronized (list) {
            for (int i = 0; i < length; ++i) {
                ChildState cs = (ChildState)this.stats.remove(offset);
                float csSpan = cs.getMajorSpan();
                cs.getChildView().setParent(null);
                if (csSpan == 0.0f) continue;
                this.majorRequirementChange(cs, -csSpan);
            }
            LayoutQueue q = this.getLayoutQueue();
            if (views != null) {
                for (int i = 0; i < views.length; ++i) {
                    ChildState s = this.createChildState(views[i]);
                    this.stats.add(offset + i, s);
                    q.addTask(s);
                }
            }
            q.addTask(this.flushTask);
        }
    }

    protected void loadChildren(ViewFactory f) {
        Element e = this.getElement();
        int n = e.getElementCount();
        if (n > 0) {
            View[] added = new View[n];
            for (int i = 0; i < n; ++i) {
                added[i] = f.create(e.getElement(i));
            }
            this.replace(0, 0, added);
        }
    }

    protected synchronized int getViewIndexAtPosition(int pos, Position.Bias b) {
        boolean isBackward = b == Position.Bias.Backward;
        pos = isBackward ? Math.max(0, pos - 1) : pos;
        Element elem = this.getElement();
        return elem.getElementIndex(pos);
    }

    protected void updateLayout(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a) {
        if (ec != null) {
            int index = Math.max(ec.getIndex() - 1, 0);
            ChildState cs = this.getChildState(index);
            this.locator.childChanged(cs);
        }
    }

    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null && this.getViewCount() == 0) {
            ViewFactory f = this.getViewFactory();
            this.loadChildren(f);
        }
    }

    public synchronized void preferenceChanged(View child, boolean width, boolean height) {
        if (child == null) {
            this.getParent().preferenceChanged(this, width, height);
        } else {
            View cv;
            if (this.changing != null && (cv = this.changing.getChildView()) == child) {
                this.changing.preferenceChanged(width, height);
                return;
            }
            int index = this.getViewIndex(child.getStartOffset(), Position.Bias.Forward);
            ChildState cs = this.getChildState(index);
            cs.preferenceChanged(width, height);
            LayoutQueue q = this.getLayoutQueue();
            q.addTask(cs);
            q.addTask(this.flushTask);
        }
    }

    public void setSize(float width, float height) {
        this.setSpanOnAxis(0, width);
        this.setSpanOnAxis(1, height);
    }

    float getSpanOnAxis(int axis) {
        if (axis == this.getMajorAxis()) {
            return this.majorSpan;
        }
        return this.minorSpan;
    }

    void setSpanOnAxis(int axis, float span) {
        float margin = this.getInsetSpan(axis);
        if (axis == this.getMinorAxis()) {
            float targetSpan = span - margin;
            if (targetSpan != this.minorSpan) {
                this.minorSpan = targetSpan;
                int n = this.getViewCount();
                if (n != 0) {
                    LayoutQueue q = this.getLayoutQueue();
                    for (int i = 0; i < n; ++i) {
                        ChildState cs = this.getChildState(i);
                        cs.childSizeValid = false;
                        q.addTask(cs);
                    }
                    q.addTask(this.flushTask);
                }
            }
        } else if (this.estimatedMajorSpan) {
            this.majorSpan = span - margin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, Shape alloc) {
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            this.locator.setAllocation(alloc);
            this.locator.paintChildren(g);
        }
    }

    public float getPreferredSpan(int axis) {
        float margin = this.getInsetSpan(axis);
        if (axis == this.axis) {
            return this.majorSpan + margin;
        }
        if (this.prefRequest != null) {
            View child = this.prefRequest.getChildView();
            return child.getPreferredSpan(axis) + margin;
        }
        return margin + 30.0f;
    }

    public float getMinimumSpan(int axis) {
        if (axis == this.axis) {
            return this.getPreferredSpan(axis);
        }
        if (this.minRequest != null) {
            View child = this.minRequest.getChildView();
            return child.getMinimumSpan(axis);
        }
        if (axis == 0) {
            return this.getLeftInset() + this.getRightInset() + 5.0f;
        }
        return this.getTopInset() + this.getBottomInset() + 5.0f;
    }

    public float getMaximumSpan(int axis) {
        if (axis == this.axis) {
            return this.getPreferredSpan(axis);
        }
        return 2.1474836E9f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getViewCount() {
        List list = this.stats;
        synchronized (list) {
            return this.stats.size();
        }
    }

    public View getView(int n) {
        ChildState cs = this.getChildState(n);
        if (cs != null) {
            return cs.getChildView();
        }
        return null;
    }

    public Shape getChildAllocation(int index, Shape a) {
        Shape ca = this.locator.getChildAllocation(index, a);
        return ca;
    }

    public int getViewIndex(int pos, Position.Bias b) {
        return this.getViewIndexAtPosition(pos, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        ChildState cs;
        int index = this.getViewIndex(pos, b);
        Shape ca = this.locator.getChildAllocation(index, a);
        ChildState childState = cs = this.getChildState(index);
        synchronized (childState) {
            View cv = cs.getChildView();
            Shape v = cv.modelToView(pos, ca, b);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        int pos;
        ChildState cs;
        Shape ca;
        int index;
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            index = this.locator.getViewIndexAtPoint(x, y, a);
            ca = this.locator.getChildAllocation(index, a);
        }
        ChildState childState = cs = this.getChildState(index);
        synchronized (childState) {
            View v = cs.getChildView();
            pos = v.viewToModel(x, y, ca, biasReturn);
        }
        return pos;
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return Utilities.getNextVisualPositionFrom(this, pos, b, a, direction, biasRet);
    }

    class FlushTask
    implements Runnable {
        FlushTask() {
        }

        public void run() {
            AsyncBoxView.this.flushRequirementChanges();
        }
    }

    public class ChildState
    implements Runnable {
        private float min;
        private float pref;
        private float max;
        private float align;
        private boolean minorValid;
        private float span;
        private float offset;
        private boolean majorValid;
        private View child;
        private boolean childSizeValid;

        public ChildState(View v) {
            this.child = v;
            this.minorValid = false;
            this.majorValid = false;
            this.childSizeValid = false;
            this.child.setParent(AsyncBoxView.this);
        }

        public View getChildView() {
            return this.child;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                AbstractDocument doc = (AbstractDocument)AsyncBoxView.this.getDocument();
                try {
                    doc.readLock();
                    if (this.minorValid && this.majorValid && this.childSizeValid) {
                        return;
                    }
                    if (this.child.getParent() != AsyncBoxView.this) break block11;
                    AsyncBoxView asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = this;
                    }
                    this.updateChild();
                    asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = null;
                    }
                    this.updateChild();
                }
                finally {
                    doc.readUnlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateChild() {
            boolean minorUpdated = false;
            ChildState childState = this;
            synchronized (childState) {
                if (!this.minorValid) {
                    int minorAxis = AsyncBoxView.this.getMinorAxis();
                    this.min = this.child.getMinimumSpan(minorAxis);
                    this.pref = this.child.getPreferredSpan(minorAxis);
                    this.max = this.child.getMaximumSpan(minorAxis);
                    this.minorValid = true;
                    minorUpdated = true;
                }
            }
            if (minorUpdated) {
                AsyncBoxView.this.minorRequirementChange(this);
            }
            boolean majorUpdated = false;
            float delta = 0.0f;
            ChildState childState2 = this;
            synchronized (childState2) {
                if (!this.majorValid) {
                    float old = this.span;
                    this.span = this.child.getPreferredSpan(AsyncBoxView.this.axis);
                    delta = this.span - old;
                    this.majorValid = true;
                    majorUpdated = true;
                }
            }
            if (majorUpdated) {
                AsyncBoxView.this.majorRequirementChange(this, delta);
                AsyncBoxView.this.locator.childChanged(this);
            }
            childState2 = this;
            synchronized (childState2) {
                if (!this.childSizeValid) {
                    float h;
                    float w;
                    if (AsyncBoxView.this.axis == 0) {
                        w = this.span;
                        h = this.getMinorSpan();
                    } else {
                        w = this.getMinorSpan();
                        h = this.span;
                    }
                    this.childSizeValid = true;
                    this.child.setSize(w, h);
                }
            }
        }

        public float getMinorSpan() {
            if (this.max < AsyncBoxView.this.minorSpan) {
                return this.max;
            }
            return Math.max(this.min, AsyncBoxView.this.minorSpan);
        }

        public float getMinorOffset() {
            if (this.max < AsyncBoxView.this.minorSpan) {
                float align = this.child.getAlignment(AsyncBoxView.this.getMinorAxis());
                return (AsyncBoxView.this.minorSpan - this.max) * align;
            }
            return 0.0f;
        }

        public float getMajorSpan() {
            return this.span;
        }

        public float getMajorOffset() {
            return this.offset;
        }

        public void setMajorOffset(float offs) {
            this.offset = offs;
        }

        public void preferenceChanged(boolean width, boolean height) {
            if (AsyncBoxView.this.axis == 0) {
                if (width) {
                    this.majorValid = false;
                }
                if (height) {
                    this.minorValid = false;
                }
            } else {
                if (width) {
                    this.minorValid = false;
                }
                if (height) {
                    this.majorValid = false;
                }
            }
            this.childSizeValid = false;
        }

        public boolean isLayoutValid() {
            return this.minorValid && this.majorValid && this.childSizeValid;
        }
    }

    public class ChildLocator {
        protected ChildState lastValidOffset;
        protected Rectangle lastAlloc = new Rectangle();
        protected Rectangle childAlloc = new Rectangle();

        public synchronized void childChanged(ChildState cs) {
            if (this.lastValidOffset == null) {
                this.lastValidOffset = cs;
            } else if (cs.getChildView().getStartOffset() < this.lastValidOffset.getChildView().getStartOffset()) {
                this.lastValidOffset = cs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void paintChildren(Graphics g) {
            Rectangle clip = g.getClipBounds();
            float targetOffset = AsyncBoxView.this.axis == 0 ? (float)(clip.x - this.lastAlloc.x) : (float)(clip.y - this.lastAlloc.y);
            int index = this.getViewIndexAtVisualOffset(targetOffset);
            int n = AsyncBoxView.this.getViewCount();
            float offs = AsyncBoxView.this.getChildState(index).getMajorOffset();
            for (int i = index; i < n; ++i) {
                ChildState cs = AsyncBoxView.this.getChildState(i);
                cs.setMajorOffset(offs);
                Shape ca = this.getChildAllocation(i);
                if (!this.intersectsClip(ca, clip)) break;
                ChildState childState = cs;
                synchronized (childState) {
                    View v = cs.getChildView();
                    v.paint(g, ca);
                }
                offs += cs.getMajorSpan();
            }
        }

        public synchronized Shape getChildAllocation(int index, Shape a) {
            if (a == null) {
                return null;
            }
            this.setAllocation(a);
            ChildState cs = AsyncBoxView.this.getChildState(index);
            if (this.lastValidOffset == null) {
                this.lastValidOffset = AsyncBoxView.this.getChildState(0);
            }
            if (cs.getChildView().getStartOffset() > this.lastValidOffset.getChildView().getStartOffset()) {
                this.updateChildOffsetsToIndex(index);
            }
            Shape ca = this.getChildAllocation(index);
            return ca;
        }

        public int getViewIndexAtPoint(float x, float y, Shape a) {
            this.setAllocation(a);
            float targetOffset = AsyncBoxView.this.axis == 0 ? x - (float)this.lastAlloc.x : y - (float)this.lastAlloc.y;
            int index = this.getViewIndexAtVisualOffset(targetOffset);
            return index;
        }

        protected Shape getChildAllocation(int index) {
            ChildState cs = AsyncBoxView.this.getChildState(index);
            if (!cs.isLayoutValid()) {
                cs.run();
            }
            if (AsyncBoxView.this.axis == 0) {
                this.childAlloc.x = this.lastAlloc.x + (int)cs.getMajorOffset();
                this.childAlloc.y = this.lastAlloc.y + (int)cs.getMinorOffset();
                this.childAlloc.width = (int)cs.getMajorSpan();
                this.childAlloc.height = (int)cs.getMinorSpan();
            } else {
                this.childAlloc.y = this.lastAlloc.y + (int)cs.getMajorOffset();
                this.childAlloc.x = this.lastAlloc.x + (int)cs.getMinorOffset();
                this.childAlloc.height = (int)cs.getMajorSpan();
                this.childAlloc.width = (int)cs.getMinorSpan();
            }
            this.childAlloc.x += (int)AsyncBoxView.this.getLeftInset();
            this.childAlloc.y += (int)AsyncBoxView.this.getRightInset();
            return this.childAlloc;
        }

        protected void setAllocation(Shape a) {
            if (a instanceof Rectangle) {
                this.lastAlloc.setBounds((Rectangle)a);
            } else {
                this.lastAlloc.setBounds(a.getBounds());
            }
            AsyncBoxView.this.setSize(this.lastAlloc.width, this.lastAlloc.height);
        }

        protected int getViewIndexAtVisualOffset(float targetOffset) {
            int n = AsyncBoxView.this.getViewCount();
            if (n > 0) {
                boolean lastValid;
                boolean bl = lastValid = this.lastValidOffset != null;
                if (this.lastValidOffset == null) {
                    this.lastValidOffset = AsyncBoxView.this.getChildState(0);
                }
                if (targetOffset > AsyncBoxView.this.majorSpan) {
                    if (!lastValid) {
                        return 0;
                    }
                    int pos = this.lastValidOffset.getChildView().getStartOffset();
                    int index = AsyncBoxView.this.getViewIndex(pos, Position.Bias.Forward);
                    return index;
                }
                if (targetOffset > this.lastValidOffset.getMajorOffset()) {
                    return this.updateChildOffsets(targetOffset);
                }
                float offs = 0.0f;
                for (int i = 0; i < n; ++i) {
                    ChildState cs = AsyncBoxView.this.getChildState(i);
                    float nextOffs = offs + cs.getMajorSpan();
                    if (targetOffset < nextOffs) {
                        return i;
                    }
                    offs = nextOffs;
                }
            }
            return n - 1;
        }

        int updateChildOffsets(float targetOffset) {
            float start;
            int n = AsyncBoxView.this.getViewCount();
            int targetIndex = n - 1;
            int pos = this.lastValidOffset.getChildView().getStartOffset();
            int startIndex = AsyncBoxView.this.getViewIndex(pos, Position.Bias.Forward);
            float lastOffset = start = this.lastValidOffset.getMajorOffset();
            for (int i = startIndex; i < n; ++i) {
                ChildState cs = AsyncBoxView.this.getChildState(i);
                cs.setMajorOffset(lastOffset);
                lastOffset += cs.getMajorSpan();
                if (!(targetOffset < lastOffset)) continue;
                targetIndex = i;
                this.lastValidOffset = cs;
                break;
            }
            return targetIndex;
        }

        void updateChildOffsetsToIndex(int index) {
            int pos = this.lastValidOffset.getChildView().getStartOffset();
            int startIndex = AsyncBoxView.this.getViewIndex(pos, Position.Bias.Forward);
            float lastOffset = this.lastValidOffset.getMajorOffset();
            for (int i = startIndex; i <= index; ++i) {
                ChildState cs = AsyncBoxView.this.getChildState(i);
                cs.setMajorOffset(lastOffset);
                lastOffset += cs.getMajorSpan();
            }
        }

        boolean intersectsClip(Shape childAlloc, Rectangle clip) {
            Rectangle cs;
            Rectangle rectangle = cs = childAlloc instanceof Rectangle ? (Rectangle)childAlloc : childAlloc.getBounds();
            if (cs.intersects(clip)) {
                return this.lastAlloc.intersects(cs);
            }
            return false;
        }
    }
}

