/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthScrollPaneUI
extends BasicScrollPaneUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthScrollPaneUI() {
    }

    public static ComponentUI createUI(JComponent x) {
        return new SynthScrollPaneUI();
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintScrollPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        Border vpBorder = this.scrollpane.getViewportBorder();
        if (vpBorder != null) {
            Rectangle r = this.scrollpane.getViewportBorderBounds();
            vpBorder.paintBorder(this.scrollpane, g, r.x, r.y, r.width, r.height);
        }
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintScrollPaneBorder(context, g, x, y, w, h);
    }

    protected void installDefaults(JScrollPane scrollpane) {
        this.updateStyle(scrollpane);
    }

    private void updateStyle(JScrollPane c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Border vpBorder = this.scrollpane.getViewportBorder();
            if (vpBorder == null || vpBorder instanceof UIResource) {
                this.scrollpane.setViewportBorder(new ViewportBorder(context));
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions(c);
                this.installKeyboardActions(c);
            }
        }
        context.dispose();
    }

    protected void installListeners(JScrollPane c) {
        super.installListeners(c);
        c.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults(JScrollPane c) {
        SynthContext context = this.getContext(c, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        c.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.scrollpane);
        }
    }

    private class ViewportBorder
    extends AbstractBorder
    implements UIResource {
        private Insets insets;

        ViewportBorder(SynthContext context) {
            this.insets = (Insets)context.getStyle().get(context, "ScrollPane.viewportBorderInsets");
            if (this.insets == null) {
                this.insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JComponent jc = (JComponent)c;
            SynthContext context = SynthScrollPaneUI.this.getContext(jc);
            SynthStyle style = context.getStyle();
            if (style == null) {
                assert (false) : "SynthBorder is being used outside after the  UI has been uninstalled";
                return;
            }
            context.getPainter().paintViewportBorder(context, g, x, y, width, height);
            context.dispose();
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
            insets.left = this.insets.left;
            insets.right = this.insets.left;
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

