/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthScrollBarUI
extends BasicScrollBarUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle thumbStyle;
    private SynthStyle trackStyle;
    private boolean validMinimumThumbSize;
    private int scrollBarWidth;

    SynthScrollBarUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthScrollBarUI();
    }

    protected void installDefaults() {
        this.trackHighlight = 0;
        if (this.scrollbar.getLayout() == null || this.scrollbar.getLayout() instanceof UIResource) {
            this.scrollbar.setLayout(this);
        }
        this.updateStyle(this.scrollbar);
    }

    protected void configureScrollBarColors() {
    }

    private void updateStyle(JScrollBar c) {
        SynthStyle oldStyle = this.style;
        SynthContext context = this.getContext((JComponent)c, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.scrollBarWidth = this.style.getInt(context, "ScrollBar.thumbHeight", 14);
            this.minimumThumbSize = (Dimension)this.style.get(context, "ScrollBar.minimumThumbSize");
            if (this.minimumThumbSize == null) {
                this.minimumThumbSize = new Dimension();
                this.validMinimumThumbSize = false;
            } else {
                this.validMinimumThumbSize = true;
            }
            this.maximumThumbSize = (Dimension)this.style.get(context, "ScrollBar.maximumThumbSize");
            if (this.maximumThumbSize == null) {
                this.maximumThumbSize = new Dimension(4096, 4097);
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        context = this.getContext(c, Region.SCROLL_BAR_TRACK, 1);
        this.trackStyle = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, Region.SCROLL_BAR_THUMB, 1);
        this.thumbStyle = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.scrollbar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removePropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext((JComponent)this.scrollbar, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        context = this.getContext(this.scrollbar, Region.SCROLL_BAR_TRACK, 1);
        this.trackStyle.uninstallDefaults(context);
        context.dispose();
        this.trackStyle = null;
        context = this.getContext(this.scrollbar, Region.SCROLL_BAR_THUMB, 1);
        this.thumbStyle.uninstallDefaults(context);
        context.dispose();
        this.thumbStyle = null;
        super.uninstallDefaults();
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    private SynthContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SynthContext getContext(JComponent c, Region region, int state) {
        SynthStyle style = this.trackStyle;
        if (region == Region.SCROLL_BAR_THUMB) {
            style = this.thumbStyle;
        }
        return SynthContext.getContext(SynthContext.class, c, region, style, state);
    }

    private int getComponentState(JComponent c, Region region) {
        if (region == Region.SCROLL_BAR_THUMB && this.isThumbRollover() && c.isEnabled()) {
            return 2;
        }
        return SynthLookAndFeel.getComponentState(c);
    }

    public boolean getSupportsAbsolutePositioning() {
        SynthContext context = this.getContext(this.scrollbar);
        boolean value = this.style.getBoolean(context, "ScrollBar.allowsAbsolutePositioning", false);
        context.dispose();
        return value;
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintScrollBarBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), this.scrollbar.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        SynthContext subcontext = this.getContext((JComponent)this.scrollbar, Region.SCROLL_BAR_TRACK);
        this.paintTrack(subcontext, g, this.getTrackBounds());
        subcontext.dispose();
        subcontext = this.getContext((JComponent)this.scrollbar, Region.SCROLL_BAR_THUMB);
        this.paintThumb(subcontext, g, this.getThumbBounds());
        subcontext.dispose();
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintScrollBarBorder(context, g, x, y, w, h, this.scrollbar.getOrientation());
    }

    protected void paintTrack(SynthContext ss, Graphics g, Rectangle trackBounds) {
        SynthLookAndFeel.updateSubregion(ss, g, trackBounds);
        ss.getPainter().paintScrollBarTrackBackground(ss, g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, this.scrollbar.getOrientation());
        ss.getPainter().paintScrollBarTrackBorder(ss, g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, this.scrollbar.getOrientation());
    }

    protected void paintThumb(SynthContext ss, Graphics g, Rectangle thumbBounds) {
        SynthLookAndFeel.updateSubregion(ss, g, thumbBounds);
        int orientation = this.scrollbar.getOrientation();
        ss.getPainter().paintScrollBarThumbBackground(ss, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, orientation);
        ss.getPainter().paintScrollBarThumbBorder(ss, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, orientation);
    }

    public Dimension getPreferredSize(JComponent c) {
        Insets insets = c.getInsets();
        return this.scrollbar.getOrientation() == 1 ? new Dimension(this.scrollBarWidth + insets.left + insets.right, 48) : new Dimension(48, this.scrollBarWidth + insets.top + insets.bottom);
    }

    protected Dimension getMinimumThumbSize() {
        if (!this.validMinimumThumbSize) {
            if (this.scrollbar.getOrientation() == 1) {
                this.minimumThumbSize.width = this.scrollBarWidth;
                this.minimumThumbSize.height = 7;
            } else {
                this.minimumThumbSize.width = 7;
                this.minimumThumbSize.height = this.scrollBarWidth;
            }
        }
        return this.minimumThumbSize;
    }

    protected JButton createDecreaseButton(int orientation) {
        SynthArrowButton synthArrowButton = new SynthArrowButton(orientation);
        synthArrowButton.setName("ScrollBar.button");
        return synthArrowButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        SynthArrowButton synthArrowButton = new SynthArrowButton(orientation);
        synthArrowButton.setName("ScrollBar.button");
        return synthArrowButton;
    }

    protected void setThumbRollover(boolean active) {
        if (this.isThumbRollover() != active) {
            this.scrollbar.repaint(this.getThumbBounds());
            super.setThumbRollover(active);
        }
    }

    private void updateButtonDirections() {
        int orient = this.scrollbar.getOrientation();
        if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            ((SynthArrowButton)this.incrButton).setDirection(orient == 0 ? 3 : 5);
            ((SynthArrowButton)this.decrButton).setDirection(orient == 0 ? 7 : 1);
        } else {
            ((SynthArrowButton)this.incrButton).setDirection(orient == 0 ? 7 : 5);
            ((SynthArrowButton)this.decrButton).setDirection(orient == 0 ? 3 : 1);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JScrollBar)e.getSource());
        }
        if ("orientation" == propertyName) {
            this.updateButtonDirections();
        } else if ("componentOrientation" == propertyName) {
            this.updateButtonDirections();
        }
    }
}

