/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthComboPopup;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthComboBoxUI
extends BasicComboBoxUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;

    SynthComboBoxUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthComboBoxUI();
    }

    protected void installDefaults() {
        this.updateStyle(this.comboBox);
    }

    private void updateStyle(JComboBox comboBox) {
        SynthStyle oldStyle = this.style;
        SynthContext context = this.getContext(comboBox, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.useListColors = this.style.getBoolean(context, "ComboBox.rendererUseListColors", true);
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        if (this.listBox != null) {
            SynthLookAndFeel.updateStyles(this.listBox);
        }
    }

    protected void installListeners() {
        this.comboBox.addPropertyChangeListener(this);
        super.installListeners();
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.comboBox, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    protected ComboPopup createPopup() {
        SynthComboPopup popup = new SynthComboPopup(this.comboBox);
        return popup;
    }

    protected ListCellRenderer createRenderer() {
        return new SynthComboBoxRenderer();
    }

    protected ComboBoxEditor createEditor() {
        return new SynthComboBoxEditor();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.comboBox);
        }
    }

    protected JButton createArrowButton() {
        SynthArrowButton button = new SynthArrowButton(5);
        button.setName("ComboBox.arrowButton");
        return button;
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintComboBoxBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintComboBoxBorder(context, g, x, y, w, h);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer renderer = this.comboBox.getRenderer();
        Component c = hasFocus && !this.isPopupVisible(this.comboBox) ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        if (c instanceof UIResource) {
            c.setName("ComboBox.renderer");
            this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
        } else {
            this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
        }
    }

    private static class SynthComboBoxEditor
    implements ComboBoxEditor,
    UIResource {
        protected JTextField editor = new JTextField("", 9);
        private Object oldValue;

        public SynthComboBoxEditor() {
            this.editor.setName("ComboBox.textField");
        }

        public Component getEditorComponent() {
            return this.editor;
        }

        public void setItem(Object anObject) {
            String text;
            if (anObject != null) {
                text = anObject.toString();
                this.oldValue = anObject;
            } else {
                text = "";
            }
            if (!text.equals(this.editor.getText())) {
                this.editor.setText(text);
            }
        }

        public Object getItem() {
            Object newValue = this.editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (newValue.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke(this.oldValue, this.editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }

        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        public void addActionListener(ActionListener l) {
            this.editor.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.editor.removeActionListener(l);
        }
    }

    private class SynthComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public SynthComboBoxRenderer() {
            this.setText(" ");
        }

        public String getName() {
            String name = super.getName();
            if (name == null) {
                return "ComboBox.renderer";
            }
            return name;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            SynthLookAndFeel.resetSelectedUI();
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (!SynthComboBoxUI.this.useListColors) {
                    SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), isSelected, cellHasFocus, list.isEnabled(), false);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                String text;
                String string = text = value == null ? " " : value.toString();
                if ("".equals(text)) {
                    text = " ";
                }
                this.setText(text);
            }
            this.setEnabled(SynthComboBoxUI.this.comboBox.isEnabled());
            this.setComponentOrientation(SynthComboBoxUI.this.comboBox.getComponentOrientation());
            return this;
        }

        public void paint(Graphics g) {
            super.paint(g);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

