/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.spi.CurrencyNameProvider;
import sun.util.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private final transient int defaultFractionDigits;
    private final transient int numericCode;
    private static HashMap<String, Currency> instances = new HashMap(7);
    private static HashSet<Currency> available;
    static int formatVersion;
    static int dataVersion;
    static int[] mainTable;
    static long[] scCutOverTimes;
    static String[] scOldCurrencies;
    static String[] scNewCurrencies;
    static int[] scOldCurrenciesDFD;
    static int[] scNewCurrenciesDFD;
    static int[] scOldCurrenciesNumericCode;
    static int[] scNewCurrenciesNumericCode;
    static String otherCurrencies;
    static int[] otherCurrenciesDFD;
    static int[] otherCurrenciesNumericCode;
    private static final int MAGIC_NUMBER = 1131770436;
    private static final int A_TO_Z = 26;
    private static final int INVALID_COUNTRY_ENTRY = 127;
    private static final int COUNTRY_WITHOUT_CURRENCY_ENTRY = 128;
    private static final int SIMPLE_CASE_COUNTRY_MASK = 0;
    private static final int SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK = 31;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK = 96;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT = 5;
    private static final int SPECIAL_CASE_COUNTRY_MASK = 128;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_MASK = 31;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_DELTA = 1;
    private static final int COUNTRY_TYPE_MASK = 128;
    private static final int NUMERIC_CODE_MASK = 261888;
    private static final int NUMERIC_CODE_SHIFT = 8;
    private static final int VALID_FORMAT_VERSION = 1;
    private static final int SYMBOL = 0;
    private static final int DISPLAYNAME = 1;

    private Currency(String currencyCode, int defaultFractionDigits, int numericCode) {
        this.currencyCode = currencyCode;
        this.defaultFractionDigits = defaultFractionDigits;
        this.numericCode = numericCode;
    }

    public static Currency getInstance(String currencyCode) {
        return Currency.getInstance(currencyCode, Integer.MIN_VALUE, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Currency getInstance(String currencyCode, int defaultFractionDigits, int numericCode) {
        HashMap<String, Currency> hashMap = instances;
        synchronized (hashMap) {
            Currency instance = instances.get(currencyCode);
            if (instance != null) {
                return instance;
            }
            if (defaultFractionDigits == Integer.MIN_VALUE) {
                char char2;
                if (currencyCode.length() != 3) {
                    throw new IllegalArgumentException();
                }
                char char1 = currencyCode.charAt(0);
                int tableEntry = Currency.getMainTableEntry(char1, char2 = currencyCode.charAt(1));
                if ((tableEntry & 0x80) == 0 && tableEntry != 127 && currencyCode.charAt(2) - 65 == (tableEntry & 0x1F)) {
                    defaultFractionDigits = (tableEntry & 0x60) >> 5;
                    numericCode = (tableEntry & 0x3FF00) >> 8;
                } else {
                    if (currencyCode.charAt(2) == '-') {
                        throw new IllegalArgumentException();
                    }
                    int index = otherCurrencies.indexOf(currencyCode);
                    if (index == -1) {
                        throw new IllegalArgumentException();
                    }
                    defaultFractionDigits = otherCurrenciesDFD[index / 4];
                    numericCode = otherCurrenciesNumericCode[index / 4];
                }
            }
            instance = new Currency(currencyCode, defaultFractionDigits, numericCode);
            instances.put(currencyCode, instance);
            return instance;
        }
    }

    public static Currency getInstance(Locale locale) {
        char char2;
        String country = locale.getCountry();
        if (country == null) {
            throw new NullPointerException();
        }
        if (country.length() != 2) {
            throw new IllegalArgumentException();
        }
        char char1 = country.charAt(0);
        int tableEntry = Currency.getMainTableEntry(char1, char2 = country.charAt(1));
        if ((tableEntry & 0x80) == 0 && tableEntry != 127) {
            char finalChar = (char)((tableEntry & 0x1F) + 65);
            int defaultFractionDigits = (tableEntry & 0x60) >> 5;
            int numericCode = (tableEntry & 0x3FF00) >> 8;
            StringBuffer sb = new StringBuffer(country);
            sb.append(finalChar);
            return Currency.getInstance(sb.toString(), defaultFractionDigits, numericCode);
        }
        if (tableEntry == 127) {
            throw new IllegalArgumentException();
        }
        if (tableEntry == 128) {
            return null;
        }
        int index = (tableEntry & 0x1F) - 1;
        if (scCutOverTimes[index] == Long.MAX_VALUE || System.currentTimeMillis() < scCutOverTimes[index]) {
            return Currency.getInstance(scOldCurrencies[index], scOldCurrenciesDFD[index], scOldCurrenciesNumericCode[index]);
        }
        return Currency.getInstance(scNewCurrencies[index], scNewCurrenciesDFD[index], scNewCurrenciesNumericCode[index]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Currency> getAvailableCurrencies() {
        Class<Currency> clazz = Currency.class;
        synchronized (Currency.class) {
            if (available == null) {
                available = new HashSet(256);
                for (char c1 = 'A'; c1 <= 'Z'; c1 = (char)(c1 + '\u0001')) {
                    for (char c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
                        int tableEntry = Currency.getMainTableEntry(c1, c2);
                        if ((tableEntry & 0x80) != 0 || tableEntry == 127) continue;
                        char finalChar = (char)((tableEntry & 0x1F) + 65);
                        int defaultFractionDigits = (tableEntry & 0x60) >> 5;
                        int numericCode = (tableEntry & 0x3FF00) >> 8;
                        StringBuilder sb = new StringBuilder();
                        sb.append(c1);
                        sb.append(c2);
                        sb.append(finalChar);
                        available.add(Currency.getInstance(sb.toString(), defaultFractionDigits, numericCode));
                    }
                }
                StringTokenizer st = new StringTokenizer(otherCurrencies, "-");
                while (st.hasMoreElements()) {
                    available.add(Currency.getInstance((String)st.nextElement()));
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return (Set)available.clone();
        }
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public String getSymbol(Locale locale) {
        try {
            String symbol;
            LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
            if (pool.hasProviders() && (symbol = pool.getLocalizedObject(CurrencyNameGetter.INSTANCE, locale, (OpenListResourceBundle)null, this.currencyCode, 0)) != null) {
                return symbol;
            }
            OpenListResourceBundle bundle = LocaleData.getCurrencyNames(locale);
            return bundle.getString(this.currencyCode);
        }
        catch (MissingResourceException e) {
            return this.currencyCode;
        }
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    private int getNumericCode() {
        return this.numericCode;
    }

    private String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    private String getDisplayName(Locale locale) {
        try {
            OpenListResourceBundle bundle = LocaleData.getCurrencyNames(locale);
            String result = null;
            String bundleKey = this.currencyCode.toLowerCase(Locale.ROOT);
            LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
            if (pool.hasProviders()) {
                result = pool.getLocalizedObject(CurrencyNameGetter.INSTANCE, locale, bundleKey, bundle, this.currencyCode, 1);
            }
            if (result == null) {
                result = bundle.getString(bundleKey);
            }
            if (result != null) {
                return result;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.currencyCode;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    private static int getMainTableEntry(char char1, char char2) {
        if (char1 < 'A' || char1 > 'Z' || char2 < 'A' || char2 > 'Z') {
            throw new IllegalArgumentException();
        }
        return mainTable[(char1 - 65) * 26 + (char2 - 65)];
    }

    private static void setMainTableEntry(char char1, char char2, int entry) {
        if (char1 < 'A' || char1 > 'Z' || char2 < 'A' || char2 > 'Z') {
            throw new IllegalArgumentException();
        }
        Currency.mainTable[(char1 - 65) * 26 + (char2 - 65)] = entry;
    }

    private static int[] readIntArray(DataInputStream dis, int count) throws IOException {
        int[] ret = new int[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = dis.readInt();
        }
        return ret;
    }

    private static long[] readLongArray(DataInputStream dis, int count) throws IOException {
        long[] ret = new long[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = dis.readLong();
        }
        return ret;
    }

    private static String[] readStringArray(DataInputStream dis, int count) throws IOException {
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = dis.readUTF();
        }
        return ret;
    }

    private static void replaceCurrencyData(Pattern pattern, String ctry, String curdata) {
        int index;
        if (ctry.length() != 2) {
            String message = "The entry in currency.properties for " + ctry + " is ignored because of the invalid country code.";
            Currency.log(Level.INFO, message, null);
            return;
        }
        Matcher m = pattern.matcher(curdata);
        if (!m.find()) {
            String message = "The entry in currency.properties for " + ctry + " is ignored because the value format is not recognized.";
            Currency.log(Level.INFO, message, null);
            return;
        }
        String code = m.group(1);
        int numeric = Integer.parseInt(m.group(2));
        int fraction = Integer.parseInt(m.group(3));
        int entry = numeric << 8;
        for (index = 0; index < scOldCurrencies.length && !scOldCurrencies[index].equals(code); ++index) {
        }
        entry = index == scOldCurrencies.length ? (entry |= fraction << 5 | code.charAt(2) - 65) : (entry |= 0x80 | index + 1);
        Currency.setMainTableEntry(ctry.charAt(0), ctry.charAt(1), entry);
    }

    private static void log(Level level, String message, Throwable t) {
        Logger logger = Logger.getLogger("java.util.Currency");
        if (logger.isLoggable(level)) {
            if (t != null) {
                logger.log(level, message, t);
            } else {
                logger.log(level, message);
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String homeDir = System.getProperty("java.home");
                try {
                    String dataFile = homeDir + File.separator + "lib" + File.separator + "currency.data";
                    DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(dataFile)));
                    if (dis.readInt() != 1131770436) {
                        throw new InternalError("Currency data is possibly corrupted");
                    }
                    formatVersion = dis.readInt();
                    if (formatVersion != 1) {
                        throw new InternalError("Currency data format is incorrect");
                    }
                    dataVersion = dis.readInt();
                    mainTable = Currency.readIntArray(dis, 676);
                    int scCount = dis.readInt();
                    scCutOverTimes = Currency.readLongArray(dis, scCount);
                    scOldCurrencies = Currency.readStringArray(dis, scCount);
                    scNewCurrencies = Currency.readStringArray(dis, scCount);
                    scOldCurrenciesDFD = Currency.readIntArray(dis, scCount);
                    scNewCurrenciesDFD = Currency.readIntArray(dis, scCount);
                    scOldCurrenciesNumericCode = Currency.readIntArray(dis, scCount);
                    scNewCurrenciesNumericCode = Currency.readIntArray(dis, scCount);
                    int ocCount = dis.readInt();
                    otherCurrencies = dis.readUTF();
                    otherCurrenciesDFD = Currency.readIntArray(dis, ocCount);
                    otherCurrenciesNumericCode = Currency.readIntArray(dis, ocCount);
                    dis.close();
                }
                catch (IOException e) {
                    InternalError ie = new InternalError();
                    ie.initCause(e);
                    throw ie;
                }
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurrencyNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CurrencyNameProvider, String> {
        private static final CurrencyNameGetter INSTANCE = new CurrencyNameGetter();

        private CurrencyNameGetter() {
        }

        @Override
        public String getObject(CurrencyNameProvider currencyNameProvider, Locale locale, String key, Object ... params) {
            assert (params.length == 1);
            int type = (Integer)params[0];
            switch (type) {
                case 0: {
                    return currencyNameProvider.getSymbol(key, locale);
                }
            }
            assert (false);
            return null;
        }
    }
}

