/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;

public class ChoiceFormat
extends NumberFormat {
    private static final long serialVersionUID = 1795184449645032964L;
    private double[] choiceLimits;
    private String[] choiceFormats;
    static final long SIGN = Long.MIN_VALUE;
    static final long EXPONENT = 0x7FF0000000000000L;
    static final long POSITIVEINFINITY = 0x7FF0000000000000L;

    public void applyPattern(String newPattern) {
        StringBuffer[] segments = new StringBuffer[2];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = new StringBuffer();
        }
        double[] newChoiceLimits = new double[30];
        String[] newChoiceFormats = new String[30];
        int count = 0;
        int part = 0;
        double startValue = 0.0;
        double oldStartValue = Double.NaN;
        boolean inQuote = false;
        for (int i = 0; i < newPattern.length(); ++i) {
            char ch = newPattern.charAt(i);
            if (ch == '\'') {
                if (i + 1 < newPattern.length() && newPattern.charAt(i + 1) == ch) {
                    segments[part].append(ch);
                    ++i;
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) {
                segments[part].append(ch);
                continue;
            }
            if (ch == '<' || ch == '#' || ch == '\u2264') {
                if (segments[0].length() == 0) {
                    throw new IllegalArgumentException();
                }
                try {
                    String tempBuffer = segments[0].toString();
                    startValue = tempBuffer.equals("\u221e") ? Double.POSITIVE_INFINITY : (tempBuffer.equals("-\u221e") ? Double.NEGATIVE_INFINITY : Double.valueOf(segments[0].toString()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException();
                }
                if (ch == '<' && startValue != Double.POSITIVE_INFINITY && startValue != Double.NEGATIVE_INFINITY) {
                    startValue = ChoiceFormat.nextDouble(startValue);
                }
                if (startValue <= oldStartValue) {
                    throw new IllegalArgumentException();
                }
                segments[0].setLength(0);
                part = 1;
                continue;
            }
            if (ch == '|') {
                if (count == newChoiceLimits.length) {
                    newChoiceLimits = ChoiceFormat.doubleArraySize(newChoiceLimits);
                    newChoiceFormats = this.doubleArraySize(newChoiceFormats);
                }
                newChoiceLimits[count] = startValue;
                newChoiceFormats[count] = segments[1].toString();
                ++count;
                oldStartValue = startValue;
                segments[1].setLength(0);
                part = 0;
                continue;
            }
            segments[part].append(ch);
        }
        if (part == 1) {
            if (count == newChoiceLimits.length) {
                newChoiceLimits = ChoiceFormat.doubleArraySize(newChoiceLimits);
                newChoiceFormats = this.doubleArraySize(newChoiceFormats);
            }
            newChoiceLimits[count] = startValue;
            newChoiceFormats[count] = segments[1].toString();
            ++count;
        }
        this.choiceLimits = new double[count];
        System.arraycopy(newChoiceLimits, 0, this.choiceLimits, 0, count);
        this.choiceFormats = new String[count];
        System.arraycopy(newChoiceFormats, 0, this.choiceFormats, 0, count);
    }

    public String toPattern() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            boolean needQuote;
            double tryLess;
            if (i != 0) {
                result.append('|');
            }
            double less = ChoiceFormat.previousDouble(this.choiceLimits[i]);
            double tryLessOrEqual = Math.abs(Math.IEEEremainder(this.choiceLimits[i], 1.0));
            if (tryLessOrEqual < (tryLess = Math.abs(Math.IEEEremainder(less, 1.0)))) {
                result.append("" + this.choiceLimits[i]);
                result.append('#');
            } else {
                if (this.choiceLimits[i] == Double.POSITIVE_INFINITY) {
                    result.append("\u221e");
                } else if (this.choiceLimits[i] == Double.NEGATIVE_INFINITY) {
                    result.append("-\u221e");
                } else {
                    result.append("" + less);
                }
                result.append('<');
            }
            String text = this.choiceFormats[i];
            boolean bl = needQuote = text.indexOf(60) >= 0 || text.indexOf(35) >= 0 || text.indexOf(8804) >= 0 || text.indexOf(124) >= 0;
            if (needQuote) {
                result.append('\'');
            }
            if (text.indexOf(39) < 0) {
                result.append(text);
            } else {
                for (int j = 0; j < text.length(); ++j) {
                    char c = text.charAt(j);
                    result.append(c);
                    if (c != '\'') continue;
                    result.append(c);
                }
            }
            if (!needQuote) continue;
            result.append('\'');
        }
        return result.toString();
    }

    public ChoiceFormat(String newPattern) {
        this.applyPattern(newPattern);
    }

    public ChoiceFormat(double[] limits, String[] formats) {
        this.setChoices(limits, formats);
    }

    public void setChoices(double[] limits, String[] formats) {
        if (limits.length != formats.length) {
            throw new IllegalArgumentException("Array and limit arrays must be of the same length.");
        }
        this.choiceLimits = limits;
        this.choiceFormats = formats;
    }

    public double[] getLimits() {
        return this.choiceLimits;
    }

    public Object[] getFormats() {
        return this.choiceFormats;
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition status) {
        return this.format((double)number, toAppendTo, status);
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition status) {
        int i;
        for (i = 0; i < this.choiceLimits.length && number >= this.choiceLimits[i]; ++i) {
        }
        if (--i < 0) {
            i = 0;
        }
        return toAppendTo.append(this.choiceFormats[i]);
    }

    public Number parse(String text, ParsePosition status) {
        int start;
        int furthest = start = status.index;
        double bestNumber = Double.NaN;
        double tempNumber = 0.0;
        for (int i = 0; i < this.choiceFormats.length; ++i) {
            String tempString = this.choiceFormats[i];
            if (!text.regionMatches(start, tempString, 0, tempString.length())) continue;
            status.index = start + tempString.length();
            tempNumber = this.choiceLimits[i];
            if (status.index <= furthest) continue;
            furthest = status.index;
            bestNumber = tempNumber;
            if (furthest == text.length()) break;
        }
        status.index = furthest;
        if (status.index == start) {
            status.errorIndex = furthest;
        }
        return new Double(bestNumber);
    }

    public static final double nextDouble(double d) {
        return ChoiceFormat.nextDouble(d, true);
    }

    public static final double previousDouble(double d) {
        return ChoiceFormat.nextDouble(d, false);
    }

    public Object clone() {
        ChoiceFormat other = (ChoiceFormat)super.clone();
        other.choiceLimits = (double[])this.choiceLimits.clone();
        other.choiceFormats = (String[])this.choiceFormats.clone();
        return other;
    }

    public int hashCode() {
        int result = this.choiceLimits.length;
        if (this.choiceFormats.length > 0) {
            result ^= this.choiceFormats[this.choiceFormats.length - 1].hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceFormat other = (ChoiceFormat)obj;
        return Arrays.equals(this.choiceLimits, other.choiceLimits) && Arrays.equals(this.choiceFormats, other.choiceFormats);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.choiceLimits.length != this.choiceFormats.length) {
            throw new InvalidObjectException("limits and format arrays of different length.");
        }
    }

    public static double nextDouble(double d, boolean positive) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (d == 0.0) {
            double smallestPositiveDouble = Double.longBitsToDouble(1L);
            if (positive) {
                return smallestPositiveDouble;
            }
            return -smallestPositiveDouble;
        }
        long bits = Double.doubleToLongBits(d);
        long magnitude = bits & Long.MAX_VALUE;
        if (bits > 0L == positive) {
            if (magnitude != 0x7FF0000000000000L) {
                ++magnitude;
            }
        } else {
            --magnitude;
        }
        long signbit = bits & Long.MIN_VALUE;
        return Double.longBitsToDouble(magnitude | signbit);
    }

    private static double[] doubleArraySize(double[] array) {
        int oldSize = array.length;
        double[] newArray = new double[oldSize * 2];
        System.arraycopy(array, 0, newArray, 0, oldSize);
        return newArray;
    }

    private String[] doubleArraySize(String[] array) {
        int oldSize = array.length;
        String[] newArray = new String[oldSize * 2];
        System.arraycopy(array, 0, newArray, 0, oldSize);
        return newArray;
    }
}

