/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import sun.font.Decoration;
import sun.font.FontResolver;
import sun.text.CodePointIterator;

final class StyledParagraph {
    private int length;
    private Decoration decoration;
    private Object font;
    private Vector decorations;
    int[] decorationStarts;
    private Vector fonts;
    int[] fontStarts;
    private static int INITIAL_SIZE = 8;

    public StyledParagraph(AttributedCharacterIterator aci, char[] chars) {
        int nextRunStart;
        int start = aci.getBeginIndex();
        int end = aci.getEndIndex();
        this.length = end - start;
        int index = start;
        aci.first();
        do {
            nextRunStart = aci.getRunLimit();
            int localIndex = index - start;
            Map attributes = aci.getAttributes();
            attributes = StyledParagraph.addInputMethodAttrs(attributes);
            Decoration d = Decoration.getDecoration(attributes);
            this.addDecoration(d, localIndex);
            Object f = StyledParagraph.getGraphicOrFont(attributes);
            if (f == null) {
                this.addFonts(chars, attributes, localIndex, nextRunStart - start);
            } else {
                this.addFont(f, localIndex);
            }
            aci.setIndex(nextRunStart);
        } while ((index = nextRunStart) < end);
        if (this.decorations != null) {
            this.decorationStarts = StyledParagraph.addToVector(this, this.length, this.decorations, this.decorationStarts);
        }
        if (this.fonts != null) {
            this.fontStarts = StyledParagraph.addToVector(this, this.length, this.fonts, this.fontStarts);
        }
    }

    private static void insertInto(int pos, int[] starts, int numStarts) {
        while (starts[--numStarts] > pos) {
            int n = numStarts;
            starts[n] = starts[n] + 1;
        }
    }

    public static StyledParagraph insertChar(AttributedCharacterIterator aci, char[] chars, int insertPos, StyledParagraph oldParagraph) {
        char ch = aci.setIndex(insertPos);
        int relativePos = Math.max(insertPos - aci.getBeginIndex() - 1, 0);
        Map attributes = StyledParagraph.addInputMethodAttrs(aci.getAttributes());
        Decoration d = Decoration.getDecoration(attributes);
        if (!oldParagraph.getDecorationAt(relativePos).equals(d)) {
            return new StyledParagraph(aci, chars);
        }
        Object f = StyledParagraph.getGraphicOrFont(attributes);
        if (f == null) {
            FontResolver resolver = FontResolver.getInstance();
            int fontIndex = resolver.getFontIndex(ch);
            f = resolver.getFont(fontIndex, attributes);
        }
        if (!oldParagraph.getFontOrGraphicAt(relativePos).equals(f)) {
            return new StyledParagraph(aci, chars);
        }
        ++oldParagraph.length;
        if (oldParagraph.decorations != null) {
            StyledParagraph.insertInto(relativePos, oldParagraph.decorationStarts, oldParagraph.decorations.size());
        }
        if (oldParagraph.fonts != null) {
            StyledParagraph.insertInto(relativePos, oldParagraph.fontStarts, oldParagraph.fonts.size());
        }
        return oldParagraph;
    }

    private static void deleteFrom(int deleteAt, int[] starts, int numStarts) {
        while (starts[--numStarts] > deleteAt) {
            int n = numStarts;
            starts[n] = starts[n] - 1;
        }
    }

    public static StyledParagraph deleteChar(AttributedCharacterIterator aci, char[] chars, int deletePos, StyledParagraph oldParagraph) {
        deletePos -= aci.getBeginIndex();
        if (oldParagraph.decorations == null && oldParagraph.fonts == null) {
            --oldParagraph.length;
            return oldParagraph;
        }
        if (oldParagraph.getRunLimit(deletePos) == deletePos + 1 && (deletePos == 0 || oldParagraph.getRunLimit(deletePos - 1) == deletePos)) {
            return new StyledParagraph(aci, chars);
        }
        --oldParagraph.length;
        if (oldParagraph.decorations != null) {
            StyledParagraph.deleteFrom(deletePos, oldParagraph.decorationStarts, oldParagraph.decorations.size());
        }
        if (oldParagraph.fonts != null) {
            StyledParagraph.deleteFrom(deletePos, oldParagraph.fontStarts, oldParagraph.fonts.size());
        }
        return oldParagraph;
    }

    public int getRunLimit(int index) {
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        int limit1 = this.length;
        if (this.decorations != null) {
            int run = StyledParagraph.findRunContaining(index, this.decorationStarts);
            limit1 = this.decorationStarts[run + 1];
        }
        int limit2 = this.length;
        if (this.fonts != null) {
            int run = StyledParagraph.findRunContaining(index, this.fontStarts);
            limit2 = this.fontStarts[run + 1];
        }
        return Math.min(limit1, limit2);
    }

    public Decoration getDecorationAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.decorations == null) {
            return this.decoration;
        }
        int run = StyledParagraph.findRunContaining(index, this.decorationStarts);
        return (Decoration)this.decorations.elementAt(run);
    }

    public Object getFontOrGraphicAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.fonts == null) {
            return this.font;
        }
        int run = StyledParagraph.findRunContaining(index, this.fontStarts);
        return this.fonts.elementAt(run);
    }

    private static int findRunContaining(int index, int[] starts) {
        int i = 1;
        while (starts[i] <= index) {
            ++i;
        }
        return i - 1;
    }

    private static int[] addToVector(Object obj, int index, Vector v, int[] starts) {
        if (!v.lastElement().equals(obj)) {
            v.addElement(obj);
            int count = v.size();
            if (starts.length == count) {
                int[] temp = new int[starts.length * 2];
                System.arraycopy(starts, 0, temp, 0, starts.length);
                starts = temp;
            }
            starts[count - 1] = index;
        }
        return starts;
    }

    private void addDecoration(Decoration d, int index) {
        if (this.decorations != null) {
            this.decorationStarts = StyledParagraph.addToVector(d, index, this.decorations, this.decorationStarts);
        } else if (this.decoration == null) {
            this.decoration = d;
        } else if (!this.decoration.equals(d)) {
            this.decorations = new Vector(INITIAL_SIZE);
            this.decorations.addElement(this.decoration);
            this.decorations.addElement(d);
            this.decorationStarts = new int[INITIAL_SIZE];
            this.decorationStarts[0] = 0;
            this.decorationStarts[1] = index;
        }
    }

    private void addFont(Object f, int index) {
        if (this.fonts != null) {
            this.fontStarts = StyledParagraph.addToVector(f, index, this.fonts, this.fontStarts);
        } else if (this.font == null) {
            this.font = f;
        } else if (!this.font.equals(f)) {
            this.fonts = new Vector(INITIAL_SIZE);
            this.fonts.addElement(this.font);
            this.fonts.addElement(f);
            this.fontStarts = new int[INITIAL_SIZE];
            this.fontStarts[0] = 0;
            this.fontStarts[1] = index;
        }
    }

    private void addFonts(char[] chars, Map attributes, int start, int limit) {
        FontResolver resolver = FontResolver.getInstance();
        CodePointIterator iter = CodePointIterator.create(chars, start, limit);
        int runStart = iter.charIndex();
        while (runStart < limit) {
            int fontIndex = resolver.nextFontRunIndex(iter);
            this.addFont(resolver.getFont(fontIndex, attributes), runStart);
            runStart = iter.charIndex();
        }
    }

    static Map addInputMethodAttrs(Map oldStyles) {
        block7: {
            Object value = oldStyles.get(TextAttribute.INPUT_METHOD_HIGHLIGHT);
            try {
                if (value == null) break block7;
                if (value instanceof Annotation) {
                    value = ((Annotation)value).getValue();
                }
                InputMethodHighlight hl = (InputMethodHighlight)value;
                Map<TextAttribute, ?> imStyles = null;
                try {
                    imStyles = hl.getStyle();
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
                if (imStyles == null) {
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    imStyles = tk.mapInputMethodHighlight(hl);
                }
                if (imStyles != null) {
                    HashMap newStyles = new HashMap(5, 0.9f);
                    newStyles.putAll(oldStyles);
                    newStyles.putAll(imStyles);
                    return newStyles;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return oldStyles;
    }

    private static Object getGraphicOrFont(Map attributes) {
        Object value = attributes.get(TextAttribute.CHAR_REPLACEMENT);
        if (value != null) {
            return value;
        }
        value = attributes.get(TextAttribute.FONT);
        if (value != null) {
            return value;
        }
        if (attributes.get(TextAttribute.FAMILY) != null) {
            return Font.getFont(attributes);
        }
        return null;
    }
}

